/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.firehose.model.KinesisStreamSourceConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class KinesisStreamSourceConfigurationMarshaller {
    private static final MarshallingInfo<String> KINESISSTREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisStreamARN").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").isBinary(false).build();
    private static final KinesisStreamSourceConfigurationMarshaller INSTANCE = new KinesisStreamSourceConfigurationMarshaller();

    private KinesisStreamSourceConfigurationMarshaller() {
    }

    public static KinesisStreamSourceConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KinesisStreamSourceConfiguration kinesisStreamSourceConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)kinesisStreamSourceConfiguration, (String)"kinesisStreamSourceConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)kinesisStreamSourceConfiguration.kinesisStreamARN(), KINESISSTREAMARN_BINDING);
            protocolMarshaller.marshall((Object)kinesisStreamSourceConfiguration.roleARN(), ROLEARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

