/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.InputFormatConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InputFormatConfigurationMarshaller {
    private static final MarshallingInfo<StructuredPojo> DESERIALIZER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Deserializer").isBinary(false).build();
    private static final InputFormatConfigurationMarshaller INSTANCE = new InputFormatConfigurationMarshaller();

    private InputFormatConfigurationMarshaller() {
    }

    public static InputFormatConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InputFormatConfiguration inputFormatConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)inputFormatConfiguration, (String)"inputFormatConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)inputFormatConfiguration.deserializer(), DESERIALIZER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

