/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.firehose.model.Deserializer;
import software.amazon.awssdk.services.firehose.transform.HiveJsonSerDeUnmarshaller;
import software.amazon.awssdk.services.firehose.transform.OpenXJsonSerDeUnmarshaller;

public class DeserializerUnmarshaller
implements Unmarshaller<Deserializer, JsonUnmarshallerContext> {
    private static final DeserializerUnmarshaller INSTANCE = new DeserializerUnmarshaller();

    public Deserializer unmarshall(JsonUnmarshallerContext context) throws Exception {
        Deserializer.Builder deserializerBuilder = Deserializer.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("OpenXJsonSerDe", targetDepth)) {
                    context.nextToken();
                    deserializerBuilder.openXJsonSerDe(OpenXJsonSerDeUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("HiveJsonSerDe", targetDepth)) {
                    context.nextToken();
                    deserializerBuilder.hiveJsonSerDe(HiveJsonSerDeUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Deserializer)deserializerBuilder.build();
    }

    public static DeserializerUnmarshaller getInstance() {
        return INSTANCE;
    }
}

