/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.firehose.model.CopyCommand;

public class CopyCommandUnmarshaller
implements Unmarshaller<CopyCommand, JsonUnmarshallerContext> {
    private static final CopyCommandUnmarshaller INSTANCE = new CopyCommandUnmarshaller();

    public CopyCommand unmarshall(JsonUnmarshallerContext context) throws Exception {
        CopyCommand.Builder copyCommandBuilder = CopyCommand.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("DataTableName", targetDepth)) {
                    context.nextToken();
                    copyCommandBuilder.dataTableName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DataTableColumns", targetDepth)) {
                    context.nextToken();
                    copyCommandBuilder.dataTableColumns((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CopyOptions", targetDepth)) {
                    context.nextToken();
                    copyCommandBuilder.copyOptions((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (CopyCommand)copyCommandBuilder.build();
    }

    public static CopyCommandUnmarshaller getInstance() {
        return INSTANCE;
    }
}

