/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.firehose.model.BufferingHints;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BufferingHintsMarshaller {
    private static final MarshallingInfo<Integer> SIZEINMBS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizeInMBs").isBinary(false).build();
    private static final MarshallingInfo<Integer> INTERVALINSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IntervalInSeconds").isBinary(false).build();
    private static final BufferingHintsMarshaller INSTANCE = new BufferingHintsMarshaller();

    private BufferingHintsMarshaller() {
    }

    public static BufferingHintsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BufferingHints bufferingHints, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)bufferingHints, (String)"bufferingHints");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)bufferingHints.sizeInMBs(), SIZEINMBS_BINDING);
            protocolMarshaller.marshall((Object)bufferingHints.intervalInSeconds(), INTERVALINSECONDS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

