/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.HECEndpointType;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.model.S3DestinationConfiguration;
import software.amazon.awssdk.services.firehose.model.SplunkRetryOptions;
import software.amazon.awssdk.services.firehose.model.SplunkS3BackupMode;
import software.amazon.awssdk.services.firehose.transform.SplunkDestinationConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SplunkDestinationConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, SplunkDestinationConfiguration> {
    private final String hecEndpoint;
    private final String hecEndpointType;
    private final String hecToken;
    private final Integer hecAcknowledgmentTimeoutInSeconds;
    private final SplunkRetryOptions retryOptions;
    private final String s3BackupMode;
    private final S3DestinationConfiguration s3Configuration;
    private final ProcessingConfiguration processingConfiguration;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private SplunkDestinationConfiguration(BuilderImpl builder) {
        this.hecEndpoint = builder.hecEndpoint;
        this.hecEndpointType = builder.hecEndpointType;
        this.hecToken = builder.hecToken;
        this.hecAcknowledgmentTimeoutInSeconds = builder.hecAcknowledgmentTimeoutInSeconds;
        this.retryOptions = builder.retryOptions;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3Configuration = builder.s3Configuration;
        this.processingConfiguration = builder.processingConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
    }

    public String hecEndpoint() {
        return this.hecEndpoint;
    }

    public HECEndpointType hecEndpointType() {
        return HECEndpointType.fromValue(this.hecEndpointType);
    }

    public String hecEndpointTypeAsString() {
        return this.hecEndpointType;
    }

    public String hecToken() {
        return this.hecToken;
    }

    public Integer hecAcknowledgmentTimeoutInSeconds() {
        return this.hecAcknowledgmentTimeoutInSeconds;
    }

    public SplunkRetryOptions retryOptions() {
        return this.retryOptions;
    }

    public SplunkS3BackupMode s3BackupMode() {
        return SplunkS3BackupMode.fromValue(this.s3BackupMode);
    }

    public String s3BackupModeAsString() {
        return this.s3BackupMode;
    }

    public S3DestinationConfiguration s3Configuration() {
        return this.s3Configuration;
    }

    public ProcessingConfiguration processingConfiguration() {
        return this.processingConfiguration;
    }

    public CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hecEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.hecEndpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hecToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hecAcknowledgmentTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BackupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SplunkDestinationConfiguration)) {
            return false;
        }
        SplunkDestinationConfiguration other = (SplunkDestinationConfiguration)obj;
        return Objects.equals(this.hecEndpoint(), other.hecEndpoint()) && Objects.equals(this.hecEndpointTypeAsString(), other.hecEndpointTypeAsString()) && Objects.equals(this.hecToken(), other.hecToken()) && Objects.equals(this.hecAcknowledgmentTimeoutInSeconds(), other.hecAcknowledgmentTimeoutInSeconds()) && Objects.equals(this.retryOptions(), other.retryOptions()) && Objects.equals(this.s3BackupModeAsString(), other.s3BackupModeAsString()) && Objects.equals(this.s3Configuration(), other.s3Configuration()) && Objects.equals(this.processingConfiguration(), other.processingConfiguration()) && Objects.equals(this.cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions());
    }

    public String toString() {
        return ToString.builder((String)"SplunkDestinationConfiguration").add("HECEndpoint", (Object)this.hecEndpoint()).add("HECEndpointType", (Object)this.hecEndpointTypeAsString()).add("HECToken", (Object)this.hecToken()).add("HECAcknowledgmentTimeoutInSeconds", (Object)this.hecAcknowledgmentTimeoutInSeconds()).add("RetryOptions", (Object)this.retryOptions()).add("S3BackupMode", (Object)this.s3BackupModeAsString()).add("S3Configuration", (Object)this.s3Configuration()).add("ProcessingConfiguration", (Object)this.processingConfiguration()).add("CloudWatchLoggingOptions", (Object)this.cloudWatchLoggingOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HECEndpoint": {
                return Optional.ofNullable(clazz.cast(this.hecEndpoint()));
            }
            case "HECEndpointType": {
                return Optional.ofNullable(clazz.cast(this.hecEndpointTypeAsString()));
            }
            case "HECToken": {
                return Optional.ofNullable(clazz.cast(this.hecToken()));
            }
            case "HECAcknowledgmentTimeoutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.hecAcknowledgmentTimeoutInSeconds()));
            }
            case "RetryOptions": {
                return Optional.ofNullable(clazz.cast(this.retryOptions()));
            }
            case "S3BackupMode": {
                return Optional.ofNullable(clazz.cast(this.s3BackupModeAsString()));
            }
            case "S3Configuration": {
                return Optional.ofNullable(clazz.cast(this.s3Configuration()));
            }
            case "ProcessingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.processingConfiguration()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptions()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SplunkDestinationConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String hecEndpoint;
        private String hecEndpointType;
        private String hecToken;
        private Integer hecAcknowledgmentTimeoutInSeconds;
        private SplunkRetryOptions retryOptions;
        private String s3BackupMode;
        private S3DestinationConfiguration s3Configuration;
        private ProcessingConfiguration processingConfiguration;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(SplunkDestinationConfiguration model) {
            this.hecEndpoint(model.hecEndpoint);
            this.hecEndpointType(model.hecEndpointType);
            this.hecToken(model.hecToken);
            this.hecAcknowledgmentTimeoutInSeconds(model.hecAcknowledgmentTimeoutInSeconds);
            this.retryOptions(model.retryOptions);
            this.s3BackupMode(model.s3BackupMode);
            this.s3Configuration(model.s3Configuration);
            this.processingConfiguration(model.processingConfiguration);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
        }

        public final String getHECEndpoint() {
            return this.hecEndpoint;
        }

        @Override
        public final Builder hecEndpoint(String hecEndpoint) {
            this.hecEndpoint = hecEndpoint;
            return this;
        }

        public final void setHECEndpoint(String hecEndpoint) {
            this.hecEndpoint = hecEndpoint;
        }

        public final String getHECEndpointType() {
            return this.hecEndpointType;
        }

        @Override
        public final Builder hecEndpointType(String hecEndpointType) {
            this.hecEndpointType = hecEndpointType;
            return this;
        }

        @Override
        public final Builder hecEndpointType(HECEndpointType hecEndpointType) {
            this.hecEndpointType(hecEndpointType.toString());
            return this;
        }

        public final void setHECEndpointType(String hecEndpointType) {
            this.hecEndpointType = hecEndpointType;
        }

        public final String getHECToken() {
            return this.hecToken;
        }

        @Override
        public final Builder hecToken(String hecToken) {
            this.hecToken = hecToken;
            return this;
        }

        public final void setHECToken(String hecToken) {
            this.hecToken = hecToken;
        }

        public final Integer getHECAcknowledgmentTimeoutInSeconds() {
            return this.hecAcknowledgmentTimeoutInSeconds;
        }

        @Override
        public final Builder hecAcknowledgmentTimeoutInSeconds(Integer hecAcknowledgmentTimeoutInSeconds) {
            this.hecAcknowledgmentTimeoutInSeconds = hecAcknowledgmentTimeoutInSeconds;
            return this;
        }

        public final void setHECAcknowledgmentTimeoutInSeconds(Integer hecAcknowledgmentTimeoutInSeconds) {
            this.hecAcknowledgmentTimeoutInSeconds = hecAcknowledgmentTimeoutInSeconds;
        }

        public final SplunkRetryOptions.Builder getRetryOptions() {
            return this.retryOptions != null ? this.retryOptions.toBuilder() : null;
        }

        @Override
        public final Builder retryOptions(SplunkRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final void setRetryOptions(SplunkRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        public final String getS3BackupMode() {
            return this.s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(SplunkS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode.toString());
            return this;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        public final S3DestinationConfiguration.Builder getS3Configuration() {
            return this.s3Configuration != null ? this.s3Configuration.toBuilder() : null;
        }

        @Override
        public final Builder s3Configuration(S3DestinationConfiguration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final void setS3Configuration(S3DestinationConfiguration.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return this.processingConfiguration != null ? this.processingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        public SplunkDestinationConfiguration build() {
            return new SplunkDestinationConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SplunkDestinationConfiguration> {
        public Builder hecEndpoint(String var1);

        public Builder hecEndpointType(String var1);

        public Builder hecEndpointType(HECEndpointType var1);

        public Builder hecToken(String var1);

        public Builder hecAcknowledgmentTimeoutInSeconds(Integer var1);

        public Builder retryOptions(SplunkRetryOptions var1);

        default public Builder retryOptions(Consumer<SplunkRetryOptions.Builder> retryOptions) {
            return this.retryOptions((SplunkRetryOptions)((SplunkRetryOptions.Builder)SplunkRetryOptions.builder().applyMutation(retryOptions)).build());
        }

        public Builder s3BackupMode(String var1);

        public Builder s3BackupMode(SplunkS3BackupMode var1);

        public Builder s3Configuration(S3DestinationConfiguration var1);

        default public Builder s3Configuration(Consumer<S3DestinationConfiguration.Builder> s3Configuration) {
            return this.s3Configuration((S3DestinationConfiguration)((S3DestinationConfiguration.Builder)S3DestinationConfiguration.builder().applyMutation(s3Configuration)).build());
        }

        public Builder processingConfiguration(ProcessingConfiguration var1);

        default public Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return this.processingConfiguration((ProcessingConfiguration)((ProcessingConfiguration.Builder)ProcessingConfiguration.builder().applyMutation(processingConfiguration)).build());
        }

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);

        default public Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return this.cloudWatchLoggingOptions((CloudWatchLoggingOptions)((CloudWatchLoggingOptions.Builder)CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions)).build());
        }
    }
}

