/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.firehose.model.ProcessorParameter;
import software.amazon.awssdk.services.firehose.model.ProcessorParameterListCopier;
import software.amazon.awssdk.services.firehose.model.ProcessorType;
import software.amazon.awssdk.services.firehose.transform.ProcessorMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Processor
implements StructuredPojo,
ToCopyableBuilder<Builder, Processor> {
    private final String type;
    private final List<ProcessorParameter> parameters;

    private Processor(BuilderImpl builder) {
        this.type = builder.type;
        this.parameters = builder.parameters;
    }

    public ProcessorType type() {
        return ProcessorType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public List<ProcessorParameter> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Processor)) {
            return false;
        }
        Processor other = (Processor)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.parameters(), other.parameters());
    }

    public String toString() {
        return ToString.builder((String)"Processor").add("Type", (Object)this.typeAsString()).add("Parameters", this.parameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProcessorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private List<ProcessorParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Processor model) {
            this.type(model.type);
            this.parameters(model.parameters);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ProcessorType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<ProcessorParameter.Builder> getParameters() {
            return this.parameters != null ? (Collection)this.parameters.stream().map(ProcessorParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<ProcessorParameter> parameters) {
            this.parameters = ProcessorParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(ProcessorParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<ProcessorParameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (ProcessorParameter)((ProcessorParameter.Builder)ProcessorParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameters(Collection<ProcessorParameter.BuilderImpl> parameters) {
            this.parameters = ProcessorParameterListCopier.copyFromBuilder(parameters);
        }

        public Processor build() {
            return new Processor(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Processor> {
        public Builder type(String var1);

        public Builder type(ProcessorType var1);

        public Builder parameters(Collection<ProcessorParameter> var1);

        public Builder parameters(ProcessorParameter ... var1);

        public Builder parameters(Consumer<ProcessorParameter.Builder> ... var1);
    }
}

