/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.KinesisStreamSourceConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KinesisStreamSourceConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, KinesisStreamSourceConfiguration> {
    private final String kinesisStreamARN;
    private final String roleARN;

    private KinesisStreamSourceConfiguration(BuilderImpl builder) {
        this.kinesisStreamARN = builder.kinesisStreamARN;
        this.roleARN = builder.roleARN;
    }

    public String kinesisStreamARN() {
        return this.kinesisStreamARN;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisStreamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisStreamSourceConfiguration)) {
            return false;
        }
        KinesisStreamSourceConfiguration other = (KinesisStreamSourceConfiguration)obj;
        return Objects.equals(this.kinesisStreamARN(), other.kinesisStreamARN()) && Objects.equals(this.roleARN(), other.roleARN());
    }

    public String toString() {
        return ToString.builder((String)"KinesisStreamSourceConfiguration").add("KinesisStreamARN", (Object)this.kinesisStreamARN()).add("RoleARN", (Object)this.roleARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KinesisStreamARN": {
                return Optional.ofNullable(clazz.cast(this.kinesisStreamARN()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KinesisStreamSourceConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String kinesisStreamARN;
        private String roleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisStreamSourceConfiguration model) {
            this.kinesisStreamARN(model.kinesisStreamARN);
            this.roleARN(model.roleARN);
        }

        public final String getKinesisStreamARN() {
            return this.kinesisStreamARN;
        }

        @Override
        public final Builder kinesisStreamARN(String kinesisStreamARN) {
            this.kinesisStreamARN = kinesisStreamARN;
            return this;
        }

        public final void setKinesisStreamARN(String kinesisStreamARN) {
            this.kinesisStreamARN = kinesisStreamARN;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public KinesisStreamSourceConfiguration build() {
            return new KinesisStreamSourceConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KinesisStreamSourceConfiguration> {
        public Builder kinesisStreamARN(String var1);

        public Builder roleARN(String var1);
    }
}

