/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.BufferingHints;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.CompressionFormat;
import software.amazon.awssdk.services.firehose.model.DataFormatConversionConfiguration;
import software.amazon.awssdk.services.firehose.model.EncryptionConfiguration;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.model.S3BackupMode;
import software.amazon.awssdk.services.firehose.model.S3DestinationUpdate;
import software.amazon.awssdk.services.firehose.transform.ExtendedS3DestinationUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExtendedS3DestinationUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, ExtendedS3DestinationUpdate> {
    private final String roleARN;
    private final String bucketARN;
    private final String prefix;
    private final BufferingHints bufferingHints;
    private final String compressionFormat;
    private final EncryptionConfiguration encryptionConfiguration;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;
    private final ProcessingConfiguration processingConfiguration;
    private final String s3BackupMode;
    private final S3DestinationUpdate s3BackupUpdate;
    private final DataFormatConversionConfiguration dataFormatConversionConfiguration;

    private ExtendedS3DestinationUpdate(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.bucketARN = builder.bucketARN;
        this.prefix = builder.prefix;
        this.bufferingHints = builder.bufferingHints;
        this.compressionFormat = builder.compressionFormat;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.processingConfiguration = builder.processingConfiguration;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3BackupUpdate = builder.s3BackupUpdate;
        this.dataFormatConversionConfiguration = builder.dataFormatConversionConfiguration;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public String bucketARN() {
        return this.bucketARN;
    }

    public String prefix() {
        return this.prefix;
    }

    public BufferingHints bufferingHints() {
        return this.bufferingHints;
    }

    public CompressionFormat compressionFormat() {
        return CompressionFormat.fromValue(this.compressionFormat);
    }

    public String compressionFormatAsString() {
        return this.compressionFormat;
    }

    public EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public ProcessingConfiguration processingConfiguration() {
        return this.processingConfiguration;
    }

    public S3BackupMode s3BackupMode() {
        return S3BackupMode.fromValue(this.s3BackupMode);
    }

    public String s3BackupModeAsString() {
        return this.s3BackupMode;
    }

    public S3DestinationUpdate s3BackupUpdate() {
        return this.s3BackupUpdate;
    }

    public DataFormatConversionConfiguration dataFormatConversionConfiguration() {
        return this.dataFormatConversionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferingHints());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BackupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BackupUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFormatConversionConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtendedS3DestinationUpdate)) {
            return false;
        }
        ExtendedS3DestinationUpdate other = (ExtendedS3DestinationUpdate)obj;
        return Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.bucketARN(), other.bucketARN()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.bufferingHints(), other.bufferingHints()) && Objects.equals(this.compressionFormatAsString(), other.compressionFormatAsString()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && Objects.equals(this.cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions()) && Objects.equals(this.processingConfiguration(), other.processingConfiguration()) && Objects.equals(this.s3BackupModeAsString(), other.s3BackupModeAsString()) && Objects.equals(this.s3BackupUpdate(), other.s3BackupUpdate()) && Objects.equals(this.dataFormatConversionConfiguration(), other.dataFormatConversionConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"ExtendedS3DestinationUpdate").add("RoleARN", (Object)this.roleARN()).add("BucketARN", (Object)this.bucketARN()).add("Prefix", (Object)this.prefix()).add("BufferingHints", (Object)this.bufferingHints()).add("CompressionFormat", (Object)this.compressionFormatAsString()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("CloudWatchLoggingOptions", (Object)this.cloudWatchLoggingOptions()).add("ProcessingConfiguration", (Object)this.processingConfiguration()).add("S3BackupMode", (Object)this.s3BackupModeAsString()).add("S3BackupUpdate", (Object)this.s3BackupUpdate()).add("DataFormatConversionConfiguration", (Object)this.dataFormatConversionConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "BucketARN": {
                return Optional.ofNullable(clazz.cast(this.bucketARN()));
            }
            case "Prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "BufferingHints": {
                return Optional.ofNullable(clazz.cast(this.bufferingHints()));
            }
            case "CompressionFormat": {
                return Optional.ofNullable(clazz.cast(this.compressionFormatAsString()));
            }
            case "EncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptions()));
            }
            case "ProcessingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.processingConfiguration()));
            }
            case "S3BackupMode": {
                return Optional.ofNullable(clazz.cast(this.s3BackupModeAsString()));
            }
            case "S3BackupUpdate": {
                return Optional.ofNullable(clazz.cast(this.s3BackupUpdate()));
            }
            case "DataFormatConversionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataFormatConversionConfiguration()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExtendedS3DestinationUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleARN;
        private String bucketARN;
        private String prefix;
        private BufferingHints bufferingHints;
        private String compressionFormat;
        private EncryptionConfiguration encryptionConfiguration;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;
        private ProcessingConfiguration processingConfiguration;
        private String s3BackupMode;
        private S3DestinationUpdate s3BackupUpdate;
        private DataFormatConversionConfiguration dataFormatConversionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ExtendedS3DestinationUpdate model) {
            this.roleARN(model.roleARN);
            this.bucketARN(model.bucketARN);
            this.prefix(model.prefix);
            this.bufferingHints(model.bufferingHints);
            this.compressionFormat(model.compressionFormat);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            this.processingConfiguration(model.processingConfiguration);
            this.s3BackupMode(model.s3BackupMode);
            this.s3BackupUpdate(model.s3BackupUpdate);
            this.dataFormatConversionConfiguration(model.dataFormatConversionConfiguration);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getBucketARN() {
            return this.bucketARN;
        }

        @Override
        public final Builder bucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
            return this;
        }

        public final void setBucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final BufferingHints.Builder getBufferingHints() {
            return this.bufferingHints != null ? this.bufferingHints.toBuilder() : null;
        }

        @Override
        public final Builder bufferingHints(BufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final void setBufferingHints(BufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        public final String getCompressionFormat() {
            return this.compressionFormat;
        }

        @Override
        public final Builder compressionFormat(String compressionFormat) {
            this.compressionFormat = compressionFormat;
            return this;
        }

        @Override
        public final Builder compressionFormat(CompressionFormat compressionFormat) {
            this.compressionFormat(compressionFormat.toString());
            return this;
        }

        public final void setCompressionFormat(String compressionFormat) {
            this.compressionFormat = compressionFormat;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return this.processingConfiguration != null ? this.processingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        public final String getS3BackupMode() {
            return this.s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(S3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode.toString());
            return this;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        public final S3DestinationUpdate.Builder getS3BackupUpdate() {
            return this.s3BackupUpdate != null ? this.s3BackupUpdate.toBuilder() : null;
        }

        @Override
        public final Builder s3BackupUpdate(S3DestinationUpdate s3BackupUpdate) {
            this.s3BackupUpdate = s3BackupUpdate;
            return this;
        }

        public final void setS3BackupUpdate(S3DestinationUpdate.BuilderImpl s3BackupUpdate) {
            this.s3BackupUpdate = s3BackupUpdate != null ? s3BackupUpdate.build() : null;
        }

        public final DataFormatConversionConfiguration.Builder getDataFormatConversionConfiguration() {
            return this.dataFormatConversionConfiguration != null ? this.dataFormatConversionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder dataFormatConversionConfiguration(DataFormatConversionConfiguration dataFormatConversionConfiguration) {
            this.dataFormatConversionConfiguration = dataFormatConversionConfiguration;
            return this;
        }

        public final void setDataFormatConversionConfiguration(DataFormatConversionConfiguration.BuilderImpl dataFormatConversionConfiguration) {
            this.dataFormatConversionConfiguration = dataFormatConversionConfiguration != null ? dataFormatConversionConfiguration.build() : null;
        }

        public ExtendedS3DestinationUpdate build() {
            return new ExtendedS3DestinationUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ExtendedS3DestinationUpdate> {
        public Builder roleARN(String var1);

        public Builder bucketARN(String var1);

        public Builder prefix(String var1);

        public Builder bufferingHints(BufferingHints var1);

        default public Builder bufferingHints(Consumer<BufferingHints.Builder> bufferingHints) {
            return this.bufferingHints((BufferingHints)((BufferingHints.Builder)BufferingHints.builder().applyMutation(bufferingHints)).build());
        }

        public Builder compressionFormat(String var1);

        public Builder compressionFormat(CompressionFormat var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);

        default public Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return this.cloudWatchLoggingOptions((CloudWatchLoggingOptions)((CloudWatchLoggingOptions.Builder)CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions)).build());
        }

        public Builder processingConfiguration(ProcessingConfiguration var1);

        default public Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return this.processingConfiguration((ProcessingConfiguration)((ProcessingConfiguration.Builder)ProcessingConfiguration.builder().applyMutation(processingConfiguration)).build());
        }

        public Builder s3BackupMode(String var1);

        public Builder s3BackupMode(S3BackupMode var1);

        public Builder s3BackupUpdate(S3DestinationUpdate var1);

        default public Builder s3BackupUpdate(Consumer<S3DestinationUpdate.Builder> s3BackupUpdate) {
            return this.s3BackupUpdate((S3DestinationUpdate)((S3DestinationUpdate.Builder)S3DestinationUpdate.builder().applyMutation(s3BackupUpdate)).build());
        }

        public Builder dataFormatConversionConfiguration(DataFormatConversionConfiguration var1);

        default public Builder dataFormatConversionConfiguration(Consumer<DataFormatConversionConfiguration.Builder> dataFormatConversionConfiguration) {
            return this.dataFormatConversionConfiguration((DataFormatConversionConfiguration)((DataFormatConversionConfiguration.Builder)DataFormatConversionConfiguration.builder().applyMutation(dataFormatConversionConfiguration)).build());
        }
    }
}

