/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.InputFormatConfiguration;
import software.amazon.awssdk.services.firehose.model.OutputFormatConfiguration;
import software.amazon.awssdk.services.firehose.model.SchemaConfiguration;
import software.amazon.awssdk.services.firehose.transform.DataFormatConversionConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataFormatConversionConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, DataFormatConversionConfiguration> {
    private final SchemaConfiguration schemaConfiguration;
    private final InputFormatConfiguration inputFormatConfiguration;
    private final OutputFormatConfiguration outputFormatConfiguration;
    private final Boolean enabled;

    private DataFormatConversionConfiguration(BuilderImpl builder) {
        this.schemaConfiguration = builder.schemaConfiguration;
        this.inputFormatConfiguration = builder.inputFormatConfiguration;
        this.outputFormatConfiguration = builder.outputFormatConfiguration;
        this.enabled = builder.enabled;
    }

    public SchemaConfiguration schemaConfiguration() {
        return this.schemaConfiguration;
    }

    public InputFormatConfiguration inputFormatConfiguration() {
        return this.inputFormatConfiguration;
    }

    public OutputFormatConfiguration outputFormatConfiguration() {
        return this.outputFormatConfiguration;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFormatConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFormatConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataFormatConversionConfiguration)) {
            return false;
        }
        DataFormatConversionConfiguration other = (DataFormatConversionConfiguration)obj;
        return Objects.equals(this.schemaConfiguration(), other.schemaConfiguration()) && Objects.equals(this.inputFormatConfiguration(), other.inputFormatConfiguration()) && Objects.equals(this.outputFormatConfiguration(), other.outputFormatConfiguration()) && Objects.equals(this.enabled(), other.enabled());
    }

    public String toString() {
        return ToString.builder((String)"DataFormatConversionConfiguration").add("SchemaConfiguration", (Object)this.schemaConfiguration()).add("InputFormatConfiguration", (Object)this.inputFormatConfiguration()).add("OutputFormatConfiguration", (Object)this.outputFormatConfiguration()).add("Enabled", (Object)this.enabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaConfiguration": {
                return Optional.ofNullable(clazz.cast(this.schemaConfiguration()));
            }
            case "InputFormatConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inputFormatConfiguration()));
            }
            case "OutputFormatConfiguration": {
                return Optional.ofNullable(clazz.cast(this.outputFormatConfiguration()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataFormatConversionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private SchemaConfiguration schemaConfiguration;
        private InputFormatConfiguration inputFormatConfiguration;
        private OutputFormatConfiguration outputFormatConfiguration;
        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(DataFormatConversionConfiguration model) {
            this.schemaConfiguration(model.schemaConfiguration);
            this.inputFormatConfiguration(model.inputFormatConfiguration);
            this.outputFormatConfiguration(model.outputFormatConfiguration);
            this.enabled(model.enabled);
        }

        public final SchemaConfiguration.Builder getSchemaConfiguration() {
            return this.schemaConfiguration != null ? this.schemaConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder schemaConfiguration(SchemaConfiguration schemaConfiguration) {
            this.schemaConfiguration = schemaConfiguration;
            return this;
        }

        public final void setSchemaConfiguration(SchemaConfiguration.BuilderImpl schemaConfiguration) {
            this.schemaConfiguration = schemaConfiguration != null ? schemaConfiguration.build() : null;
        }

        public final InputFormatConfiguration.Builder getInputFormatConfiguration() {
            return this.inputFormatConfiguration != null ? this.inputFormatConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder inputFormatConfiguration(InputFormatConfiguration inputFormatConfiguration) {
            this.inputFormatConfiguration = inputFormatConfiguration;
            return this;
        }

        public final void setInputFormatConfiguration(InputFormatConfiguration.BuilderImpl inputFormatConfiguration) {
            this.inputFormatConfiguration = inputFormatConfiguration != null ? inputFormatConfiguration.build() : null;
        }

        public final OutputFormatConfiguration.Builder getOutputFormatConfiguration() {
            return this.outputFormatConfiguration != null ? this.outputFormatConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder outputFormatConfiguration(OutputFormatConfiguration outputFormatConfiguration) {
            this.outputFormatConfiguration = outputFormatConfiguration;
            return this;
        }

        public final void setOutputFormatConfiguration(OutputFormatConfiguration.BuilderImpl outputFormatConfiguration) {
            this.outputFormatConfiguration = outputFormatConfiguration != null ? outputFormatConfiguration.build() : null;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public DataFormatConversionConfiguration build() {
            return new DataFormatConversionConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DataFormatConversionConfiguration> {
        public Builder schemaConfiguration(SchemaConfiguration var1);

        default public Builder schemaConfiguration(Consumer<SchemaConfiguration.Builder> schemaConfiguration) {
            return this.schemaConfiguration((SchemaConfiguration)((SchemaConfiguration.Builder)SchemaConfiguration.builder().applyMutation(schemaConfiguration)).build());
        }

        public Builder inputFormatConfiguration(InputFormatConfiguration var1);

        default public Builder inputFormatConfiguration(Consumer<InputFormatConfiguration.Builder> inputFormatConfiguration) {
            return this.inputFormatConfiguration((InputFormatConfiguration)((InputFormatConfiguration.Builder)InputFormatConfiguration.builder().applyMutation(inputFormatConfiguration)).build());
        }

        public Builder outputFormatConfiguration(OutputFormatConfiguration var1);

        default public Builder outputFormatConfiguration(Consumer<OutputFormatConfiguration.Builder> outputFormatConfiguration) {
            return this.outputFormatConfiguration((OutputFormatConfiguration)((OutputFormatConfiguration.Builder)OutputFormatConfiguration.builder().applyMutation(outputFormatConfiguration)).build());
        }

        public Builder enabled(Boolean var1);
    }
}

