/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspacedata.model.DataViewDestinationTypeParams;
import software.amazon.awssdk.services.finspacedata.model.FinspaceDataRequest;
import software.amazon.awssdk.services.finspacedata.model.PartitionColumnListCopier;
import software.amazon.awssdk.services.finspacedata.model.SortColumnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataViewRequest
extends FinspaceDataRequest
implements ToCopyableBuilder<Builder, CreateDataViewRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateDataViewRequest.getter(CreateDataViewRequest::clientToken)).setter(CreateDataViewRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DATASET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetId").getter(CreateDataViewRequest.getter(CreateDataViewRequest::datasetId)).setter(CreateDataViewRequest.setter(Builder::datasetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("datasetId").build()}).build();
    private static final SdkField<Boolean> AUTO_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("autoUpdate").getter(CreateDataViewRequest.getter(CreateDataViewRequest::autoUpdate)).setter(CreateDataViewRequest.setter(Builder::autoUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoUpdate").build()}).build();
    private static final SdkField<List<String>> SORT_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sortColumns").getter(CreateDataViewRequest.getter(CreateDataViewRequest::sortColumns)).setter(CreateDataViewRequest.setter(Builder::sortColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PARTITION_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("partitionColumns").getter(CreateDataViewRequest.getter(CreateDataViewRequest::partitionColumns)).setter(CreateDataViewRequest.setter(Builder::partitionColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partitionColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> AS_OF_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("asOfTimestamp").getter(CreateDataViewRequest.getter(CreateDataViewRequest::asOfTimestamp)).setter(CreateDataViewRequest.setter(Builder::asOfTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asOfTimestamp").build()}).build();
    private static final SdkField<DataViewDestinationTypeParams> DESTINATION_TYPE_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("destinationTypeParams").getter(CreateDataViewRequest.getter(CreateDataViewRequest::destinationTypeParams)).setter(CreateDataViewRequest.setter(Builder::destinationTypeParams)).constructor(DataViewDestinationTypeParams::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationTypeParams").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DATASET_ID_FIELD, AUTO_UPDATE_FIELD, SORT_COLUMNS_FIELD, PARTITION_COLUMNS_FIELD, AS_OF_TIMESTAMP_FIELD, DESTINATION_TYPE_PARAMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDataViewRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String datasetId;
    private final Boolean autoUpdate;
    private final List<String> sortColumns;
    private final List<String> partitionColumns;
    private final Long asOfTimestamp;
    private final DataViewDestinationTypeParams destinationTypeParams;

    private CreateDataViewRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.datasetId = builder.datasetId;
        this.autoUpdate = builder.autoUpdate;
        this.sortColumns = builder.sortColumns;
        this.partitionColumns = builder.partitionColumns;
        this.asOfTimestamp = builder.asOfTimestamp;
        this.destinationTypeParams = builder.destinationTypeParams;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String datasetId() {
        return this.datasetId;
    }

    public final Boolean autoUpdate() {
        return this.autoUpdate;
    }

    public final boolean hasSortColumns() {
        return this.sortColumns != null && !(this.sortColumns instanceof SdkAutoConstructList);
    }

    public final List<String> sortColumns() {
        return this.sortColumns;
    }

    public final boolean hasPartitionColumns() {
        return this.partitionColumns != null && !(this.partitionColumns instanceof SdkAutoConstructList);
    }

    public final List<String> partitionColumns() {
        return this.partitionColumns;
    }

    public final Long asOfTimestamp() {
        return this.asOfTimestamp;
    }

    public final DataViewDestinationTypeParams destinationTypeParams() {
        return this.destinationTypeParams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSortColumns() ? this.sortColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitionColumns() ? this.partitionColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.asOfTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationTypeParams());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataViewRequest)) {
            return false;
        }
        CreateDataViewRequest other = (CreateDataViewRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.datasetId(), other.datasetId()) && Objects.equals(this.autoUpdate(), other.autoUpdate()) && this.hasSortColumns() == other.hasSortColumns() && Objects.equals(this.sortColumns(), other.sortColumns()) && this.hasPartitionColumns() == other.hasPartitionColumns() && Objects.equals(this.partitionColumns(), other.partitionColumns()) && Objects.equals(this.asOfTimestamp(), other.asOfTimestamp()) && Objects.equals(this.destinationTypeParams(), other.destinationTypeParams());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataViewRequest").add("ClientToken", (Object)this.clientToken()).add("DatasetId", (Object)this.datasetId()).add("AutoUpdate", (Object)this.autoUpdate()).add("SortColumns", this.hasSortColumns() ? this.sortColumns() : null).add("PartitionColumns", this.hasPartitionColumns() ? this.partitionColumns() : null).add("AsOfTimestamp", (Object)this.asOfTimestamp()).add("DestinationTypeParams", (Object)this.destinationTypeParams()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "datasetId": {
                return Optional.ofNullable(clazz.cast(this.datasetId()));
            }
            case "autoUpdate": {
                return Optional.ofNullable(clazz.cast(this.autoUpdate()));
            }
            case "sortColumns": {
                return Optional.ofNullable(clazz.cast(this.sortColumns()));
            }
            case "partitionColumns": {
                return Optional.ofNullable(clazz.cast(this.partitionColumns()));
            }
            case "asOfTimestamp": {
                return Optional.ofNullable(clazz.cast(this.asOfTimestamp()));
            }
            case "destinationTypeParams": {
                return Optional.ofNullable(clazz.cast(this.destinationTypeParams()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("datasetId", DATASET_ID_FIELD);
        map.put("autoUpdate", AUTO_UPDATE_FIELD);
        map.put("sortColumns", SORT_COLUMNS_FIELD);
        map.put("partitionColumns", PARTITION_COLUMNS_FIELD);
        map.put("asOfTimestamp", AS_OF_TIMESTAMP_FIELD);
        map.put("destinationTypeParams", DESTINATION_TYPE_PARAMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataViewRequest, T> g) {
        return obj -> g.apply((CreateDataViewRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceDataRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String datasetId;
        private Boolean autoUpdate;
        private List<String> sortColumns = DefaultSdkAutoConstructList.getInstance();
        private List<String> partitionColumns = DefaultSdkAutoConstructList.getInstance();
        private Long asOfTimestamp;
        private DataViewDestinationTypeParams destinationTypeParams;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataViewRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.datasetId(model.datasetId);
            this.autoUpdate(model.autoUpdate);
            this.sortColumns(model.sortColumns);
            this.partitionColumns(model.partitionColumns);
            this.asOfTimestamp(model.asOfTimestamp);
            this.destinationTypeParams(model.destinationTypeParams);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDatasetId() {
            return this.datasetId;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final Boolean getAutoUpdate() {
            return this.autoUpdate;
        }

        public final void setAutoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
        }

        @Override
        public final Builder autoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
            return this;
        }

        public final Collection<String> getSortColumns() {
            if (this.sortColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sortColumns;
        }

        public final void setSortColumns(Collection<String> sortColumns) {
            this.sortColumns = SortColumnListCopier.copy(sortColumns);
        }

        @Override
        public final Builder sortColumns(Collection<String> sortColumns) {
            this.sortColumns = SortColumnListCopier.copy(sortColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortColumns(String ... sortColumns) {
            this.sortColumns(Arrays.asList(sortColumns));
            return this;
        }

        public final Collection<String> getPartitionColumns() {
            if (this.partitionColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.partitionColumns;
        }

        public final void setPartitionColumns(Collection<String> partitionColumns) {
            this.partitionColumns = PartitionColumnListCopier.copy(partitionColumns);
        }

        @Override
        public final Builder partitionColumns(Collection<String> partitionColumns) {
            this.partitionColumns = PartitionColumnListCopier.copy(partitionColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionColumns(String ... partitionColumns) {
            this.partitionColumns(Arrays.asList(partitionColumns));
            return this;
        }

        public final Long getAsOfTimestamp() {
            return this.asOfTimestamp;
        }

        public final void setAsOfTimestamp(Long asOfTimestamp) {
            this.asOfTimestamp = asOfTimestamp;
        }

        @Override
        public final Builder asOfTimestamp(Long asOfTimestamp) {
            this.asOfTimestamp = asOfTimestamp;
            return this;
        }

        public final DataViewDestinationTypeParams.Builder getDestinationTypeParams() {
            return this.destinationTypeParams != null ? this.destinationTypeParams.toBuilder() : null;
        }

        public final void setDestinationTypeParams(DataViewDestinationTypeParams.BuilderImpl destinationTypeParams) {
            this.destinationTypeParams = destinationTypeParams != null ? destinationTypeParams.build() : null;
        }

        @Override
        public final Builder destinationTypeParams(DataViewDestinationTypeParams destinationTypeParams) {
            this.destinationTypeParams = destinationTypeParams;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataViewRequest build() {
            return new CreateDataViewRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FinspaceDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataViewRequest> {
        public Builder clientToken(String var1);

        public Builder datasetId(String var1);

        public Builder autoUpdate(Boolean var1);

        public Builder sortColumns(Collection<String> var1);

        public Builder sortColumns(String ... var1);

        public Builder partitionColumns(Collection<String> var1);

        public Builder partitionColumns(String ... var1);

        public Builder asOfTimestamp(Long var1);

        public Builder destinationTypeParams(DataViewDestinationTypeParams var1);

        default public Builder destinationTypeParams(Consumer<DataViewDestinationTypeParams.Builder> destinationTypeParams) {
            return this.destinationTypeParams((DataViewDestinationTypeParams)((DataViewDestinationTypeParams.Builder)DataViewDestinationTypeParams.builder().applyMutation(destinationTypeParams)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

