/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.finspacedata.model.ExportFileFormat;
import software.amazon.awssdk.services.finspacedata.model.S3DestinationFormatOptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataViewDestinationTypeParams
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataViewDestinationTypeParams> {
    private static final SdkField<String> DESTINATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationType").getter(DataViewDestinationTypeParams.getter(DataViewDestinationTypeParams::destinationType)).setter(DataViewDestinationTypeParams.setter(Builder::destinationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationType").build()}).build();
    private static final SdkField<String> S3_DESTINATION_EXPORT_FILE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3DestinationExportFileFormat").getter(DataViewDestinationTypeParams.getter(DataViewDestinationTypeParams::s3DestinationExportFileFormatAsString)).setter(DataViewDestinationTypeParams.setter(Builder::s3DestinationExportFileFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3DestinationExportFileFormat").build()}).build();
    private static final SdkField<Map<String, String>> S3_DESTINATION_EXPORT_FILE_FORMAT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("s3DestinationExportFileFormatOptions").getter(DataViewDestinationTypeParams.getter(DataViewDestinationTypeParams::s3DestinationExportFileFormatOptions)).setter(DataViewDestinationTypeParams.setter(Builder::s3DestinationExportFileFormatOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3DestinationExportFileFormatOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_TYPE_FIELD, S3_DESTINATION_EXPORT_FILE_FORMAT_FIELD, S3_DESTINATION_EXPORT_FILE_FORMAT_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataViewDestinationTypeParams.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String destinationType;
    private final String s3DestinationExportFileFormat;
    private final Map<String, String> s3DestinationExportFileFormatOptions;

    private DataViewDestinationTypeParams(BuilderImpl builder) {
        this.destinationType = builder.destinationType;
        this.s3DestinationExportFileFormat = builder.s3DestinationExportFileFormat;
        this.s3DestinationExportFileFormatOptions = builder.s3DestinationExportFileFormatOptions;
    }

    public final String destinationType() {
        return this.destinationType;
    }

    public final ExportFileFormat s3DestinationExportFileFormat() {
        return ExportFileFormat.fromValue(this.s3DestinationExportFileFormat);
    }

    public final String s3DestinationExportFileFormatAsString() {
        return this.s3DestinationExportFileFormat;
    }

    public final boolean hasS3DestinationExportFileFormatOptions() {
        return this.s3DestinationExportFileFormatOptions != null && !(this.s3DestinationExportFileFormatOptions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> s3DestinationExportFileFormatOptions() {
        return this.s3DestinationExportFileFormatOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DestinationExportFileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasS3DestinationExportFileFormatOptions() ? this.s3DestinationExportFileFormatOptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataViewDestinationTypeParams)) {
            return false;
        }
        DataViewDestinationTypeParams other = (DataViewDestinationTypeParams)obj;
        return Objects.equals(this.destinationType(), other.destinationType()) && Objects.equals(this.s3DestinationExportFileFormatAsString(), other.s3DestinationExportFileFormatAsString()) && this.hasS3DestinationExportFileFormatOptions() == other.hasS3DestinationExportFileFormatOptions() && Objects.equals(this.s3DestinationExportFileFormatOptions(), other.s3DestinationExportFileFormatOptions());
    }

    public final String toString() {
        return ToString.builder((String)"DataViewDestinationTypeParams").add("DestinationType", (Object)this.destinationType()).add("S3DestinationExportFileFormat", (Object)this.s3DestinationExportFileFormatAsString()).add("S3DestinationExportFileFormatOptions", this.hasS3DestinationExportFileFormatOptions() ? this.s3DestinationExportFileFormatOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "destinationType": {
                return Optional.ofNullable(clazz.cast(this.destinationType()));
            }
            case "s3DestinationExportFileFormat": {
                return Optional.ofNullable(clazz.cast(this.s3DestinationExportFileFormatAsString()));
            }
            case "s3DestinationExportFileFormatOptions": {
                return Optional.ofNullable(clazz.cast(this.s3DestinationExportFileFormatOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("destinationType", DESTINATION_TYPE_FIELD);
        map.put("s3DestinationExportFileFormat", S3_DESTINATION_EXPORT_FILE_FORMAT_FIELD);
        map.put("s3DestinationExportFileFormatOptions", S3_DESTINATION_EXPORT_FILE_FORMAT_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataViewDestinationTypeParams, T> g) {
        return obj -> g.apply((DataViewDestinationTypeParams)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationType;
        private String s3DestinationExportFileFormat;
        private Map<String, String> s3DestinationExportFileFormatOptions = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataViewDestinationTypeParams model) {
            this.destinationType(model.destinationType);
            this.s3DestinationExportFileFormat(model.s3DestinationExportFileFormat);
            this.s3DestinationExportFileFormatOptions(model.s3DestinationExportFileFormatOptions);
        }

        public final String getDestinationType() {
            return this.destinationType;
        }

        public final void setDestinationType(String destinationType) {
            this.destinationType = destinationType;
        }

        @Override
        public final Builder destinationType(String destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        public final String getS3DestinationExportFileFormat() {
            return this.s3DestinationExportFileFormat;
        }

        public final void setS3DestinationExportFileFormat(String s3DestinationExportFileFormat) {
            this.s3DestinationExportFileFormat = s3DestinationExportFileFormat;
        }

        @Override
        public final Builder s3DestinationExportFileFormat(String s3DestinationExportFileFormat) {
            this.s3DestinationExportFileFormat = s3DestinationExportFileFormat;
            return this;
        }

        @Override
        public final Builder s3DestinationExportFileFormat(ExportFileFormat s3DestinationExportFileFormat) {
            this.s3DestinationExportFileFormat(s3DestinationExportFileFormat == null ? null : s3DestinationExportFileFormat.toString());
            return this;
        }

        public final Map<String, String> getS3DestinationExportFileFormatOptions() {
            if (this.s3DestinationExportFileFormatOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.s3DestinationExportFileFormatOptions;
        }

        public final void setS3DestinationExportFileFormatOptions(Map<String, String> s3DestinationExportFileFormatOptions) {
            this.s3DestinationExportFileFormatOptions = S3DestinationFormatOptionsCopier.copy(s3DestinationExportFileFormatOptions);
        }

        @Override
        public final Builder s3DestinationExportFileFormatOptions(Map<String, String> s3DestinationExportFileFormatOptions) {
            this.s3DestinationExportFileFormatOptions = S3DestinationFormatOptionsCopier.copy(s3DestinationExportFileFormatOptions);
            return this;
        }

        public DataViewDestinationTypeParams build() {
            return new DataViewDestinationTypeParams(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataViewDestinationTypeParams> {
        public Builder destinationType(String var1);

        public Builder s3DestinationExportFileFormat(String var1);

        public Builder s3DestinationExportFileFormat(ExportFileFormat var1);

        public Builder s3DestinationExportFileFormatOptions(Map<String, String> var1);
    }
}

