/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspacedata.model.ApplicationPermission;
import software.amazon.awssdk.services.finspacedata.model.ApplicationPermissionListCopier;
import software.amazon.awssdk.services.finspacedata.model.FinspaceDataRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePermissionGroupRequest
extends FinspaceDataRequest
implements ToCopyableBuilder<Builder, CreatePermissionGroupRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreatePermissionGroupRequest.getter(CreatePermissionGroupRequest::name)).setter(CreatePermissionGroupRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreatePermissionGroupRequest.getter(CreatePermissionGroupRequest::description)).setter(CreatePermissionGroupRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> APPLICATION_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("applicationPermissions").getter(CreatePermissionGroupRequest.getter(CreatePermissionGroupRequest::applicationPermissionsAsStrings)).setter(CreatePermissionGroupRequest.setter(Builder::applicationPermissionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationPermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreatePermissionGroupRequest.getter(CreatePermissionGroupRequest::clientToken)).setter(CreatePermissionGroupRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, APPLICATION_PERMISSIONS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("applicationPermissions", APPLICATION_PERMISSIONS_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
        }
    });
    private final String name;
    private final String description;
    private final List<String> applicationPermissions;
    private final String clientToken;

    private CreatePermissionGroupRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.applicationPermissions = builder.applicationPermissions;
        this.clientToken = builder.clientToken;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final List<ApplicationPermission> applicationPermissions() {
        return ApplicationPermissionListCopier.copyStringToEnum(this.applicationPermissions);
    }

    public final boolean hasApplicationPermissions() {
        return this.applicationPermissions != null && !(this.applicationPermissions instanceof SdkAutoConstructList);
    }

    public final List<String> applicationPermissionsAsStrings() {
        return this.applicationPermissions;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationPermissions() ? this.applicationPermissionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePermissionGroupRequest)) {
            return false;
        }
        CreatePermissionGroupRequest other = (CreatePermissionGroupRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasApplicationPermissions() == other.hasApplicationPermissions() && Objects.equals(this.applicationPermissionsAsStrings(), other.applicationPermissionsAsStrings()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePermissionGroupRequest").add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("ApplicationPermissions", this.hasApplicationPermissions() ? this.applicationPermissionsAsStrings() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "applicationPermissions": {
                return Optional.ofNullable(clazz.cast(this.applicationPermissionsAsStrings()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreatePermissionGroupRequest, T> g) {
        return obj -> g.apply((CreatePermissionGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceDataRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<String> applicationPermissions = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePermissionGroupRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.applicationPermissionsWithStrings(model.applicationPermissions);
            this.clientToken(model.clientToken);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getApplicationPermissions() {
            if (this.applicationPermissions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.applicationPermissions;
        }

        public final void setApplicationPermissions(Collection<String> applicationPermissions) {
            this.applicationPermissions = ApplicationPermissionListCopier.copy(applicationPermissions);
        }

        @Override
        public final Builder applicationPermissionsWithStrings(Collection<String> applicationPermissions) {
            this.applicationPermissions = ApplicationPermissionListCopier.copy(applicationPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationPermissionsWithStrings(String ... applicationPermissions) {
            this.applicationPermissionsWithStrings(Arrays.asList(applicationPermissions));
            return this;
        }

        @Override
        public final Builder applicationPermissions(Collection<ApplicationPermission> applicationPermissions) {
            this.applicationPermissions = ApplicationPermissionListCopier.copyEnumToString(applicationPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationPermissions(ApplicationPermission ... applicationPermissions) {
            this.applicationPermissions(Arrays.asList(applicationPermissions));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePermissionGroupRequest build() {
            return new CreatePermissionGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FinspaceDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePermissionGroupRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder applicationPermissionsWithStrings(Collection<String> var1);

        public Builder applicationPermissionsWithStrings(String ... var1);

        public Builder applicationPermissions(Collection<ApplicationPermission> var1);

        public Builder applicationPermissions(ApplicationPermission ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

