/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspacedata.model.FinspaceDataResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResetUserPasswordResponse
extends FinspaceDataResponse
implements ToCopyableBuilder<Builder, ResetUserPasswordResponse> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(ResetUserPasswordResponse.getter(ResetUserPasswordResponse::userId)).setter(ResetUserPasswordResponse.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final SdkField<String> TEMPORARY_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("temporaryPassword").getter(ResetUserPasswordResponse.getter(ResetUserPasswordResponse::temporaryPassword)).setter(ResetUserPasswordResponse.setter(Builder::temporaryPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("temporaryPassword").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD, TEMPORARY_PASSWORD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("userId", USER_ID_FIELD);
            this.put("temporaryPassword", TEMPORARY_PASSWORD_FIELD);
        }
    });
    private final String userId;
    private final String temporaryPassword;

    private ResetUserPasswordResponse(BuilderImpl builder) {
        super(builder);
        this.userId = builder.userId;
        this.temporaryPassword = builder.temporaryPassword;
    }

    public final String userId() {
        return this.userId;
    }

    public final String temporaryPassword() {
        return this.temporaryPassword;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.temporaryPassword());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetUserPasswordResponse)) {
            return false;
        }
        ResetUserPasswordResponse other = (ResetUserPasswordResponse)((Object)obj);
        return Objects.equals(this.userId(), other.userId()) && Objects.equals(this.temporaryPassword(), other.temporaryPassword());
    }

    public final String toString() {
        return ToString.builder((String)"ResetUserPasswordResponse").add("UserId", (Object)this.userId()).add("TemporaryPassword", (Object)(this.temporaryPassword() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "temporaryPassword": {
                return Optional.ofNullable(clazz.cast(this.temporaryPassword()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResetUserPasswordResponse, T> g) {
        return obj -> g.apply((ResetUserPasswordResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceDataResponse.BuilderImpl
    implements Builder {
        private String userId;
        private String temporaryPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetUserPasswordResponse model) {
            super(model);
            this.userId(model.userId);
            this.temporaryPassword(model.temporaryPassword);
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getTemporaryPassword() {
            return this.temporaryPassword;
        }

        public final void setTemporaryPassword(String temporaryPassword) {
            this.temporaryPassword = temporaryPassword;
        }

        @Override
        public final Builder temporaryPassword(String temporaryPassword) {
            this.temporaryPassword = temporaryPassword;
            return this;
        }

        @Override
        public ResetUserPasswordResponse build() {
            return new ResetUserPasswordResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FinspaceDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ResetUserPasswordResponse> {
        public Builder userId(String var1);

        public Builder temporaryPassword(String var1);
    }
}

