/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.finspacedata.DefaultFinspaceDataAsyncClient;
import software.amazon.awssdk.services.finspacedata.DefaultFinspaceDataBaseClientBuilder;
import software.amazon.awssdk.services.finspacedata.FinspaceDataAsyncClient;
import software.amazon.awssdk.services.finspacedata.FinspaceDataAsyncClientBuilder;
import software.amazon.awssdk.services.finspacedata.FinspaceDataServiceClientConfiguration;
import software.amazon.awssdk.services.finspacedata.endpoints.FinspaceDataEndpointProvider;

@SdkInternalApi
final class DefaultFinspaceDataAsyncClientBuilder
extends DefaultFinspaceDataBaseClientBuilder<FinspaceDataAsyncClientBuilder, FinspaceDataAsyncClient>
implements FinspaceDataAsyncClientBuilder {
    DefaultFinspaceDataAsyncClientBuilder() {
    }

    @Override
    public DefaultFinspaceDataAsyncClientBuilder endpointProvider(FinspaceDataEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final FinspaceDataAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultFinspaceDataAsyncClientBuilder.validateClientOptions(clientConfiguration);
        FinspaceDataServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultFinspaceDataAsyncClient client = new DefaultFinspaceDataAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private FinspaceDataServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return FinspaceDataServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

