/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspace.model.KxClusterStatus;
import software.amazon.awssdk.services.finspace.model.KxClusterType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KxAttachedCluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KxAttachedCluster> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(KxAttachedCluster.getter(KxAttachedCluster::clusterName)).setter(KxAttachedCluster.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<String> CLUSTER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterType").getter(KxAttachedCluster.getter(KxAttachedCluster::clusterTypeAsString)).setter(KxAttachedCluster.setter(Builder::clusterType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterType").build()}).build();
    private static final SdkField<String> CLUSTER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterStatus").getter(KxAttachedCluster.getter(KxAttachedCluster::clusterStatusAsString)).setter(KxAttachedCluster.setter(Builder::clusterStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, CLUSTER_TYPE_FIELD, CLUSTER_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KxAttachedCluster.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clusterName;
    private final String clusterType;
    private final String clusterStatus;

    private KxAttachedCluster(BuilderImpl builder) {
        this.clusterName = builder.clusterName;
        this.clusterType = builder.clusterType;
        this.clusterStatus = builder.clusterStatus;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final KxClusterType clusterType() {
        return KxClusterType.fromValue(this.clusterType);
    }

    public final String clusterTypeAsString() {
        return this.clusterType;
    }

    public final KxClusterStatus clusterStatus() {
        return KxClusterStatus.fromValue(this.clusterStatus);
    }

    public final String clusterStatusAsString() {
        return this.clusterStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxAttachedCluster)) {
            return false;
        }
        KxAttachedCluster other = (KxAttachedCluster)obj;
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.clusterTypeAsString(), other.clusterTypeAsString()) && Objects.equals(this.clusterStatusAsString(), other.clusterStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"KxAttachedCluster").add("ClusterName", (Object)this.clusterName()).add("ClusterType", (Object)this.clusterTypeAsString()).add("ClusterStatus", (Object)this.clusterStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "clusterType": {
                return Optional.ofNullable(clazz.cast(this.clusterTypeAsString()));
            }
            case "clusterStatus": {
                return Optional.ofNullable(clazz.cast(this.clusterStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("clusterType", CLUSTER_TYPE_FIELD);
        map.put("clusterStatus", CLUSTER_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KxAttachedCluster, T> g) {
        return obj -> g.apply((KxAttachedCluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterName;
        private String clusterType;
        private String clusterStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(KxAttachedCluster model) {
            this.clusterName(model.clusterName);
            this.clusterType(model.clusterType);
            this.clusterStatus(model.clusterStatus);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getClusterType() {
            return this.clusterType;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        @Override
        public final Builder clusterType(KxClusterType clusterType) {
            this.clusterType(clusterType == null ? null : clusterType.toString());
            return this;
        }

        public final String getClusterStatus() {
            return this.clusterStatus;
        }

        public final void setClusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
        }

        @Override
        public final Builder clusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
            return this;
        }

        @Override
        public final Builder clusterStatus(KxClusterStatus clusterStatus) {
            this.clusterStatus(clusterStatus == null ? null : clusterStatus.toString());
            return this;
        }

        public KxAttachedCluster build() {
            return new KxAttachedCluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KxAttachedCluster> {
        public Builder clusterName(String var1);

        public Builder clusterType(String var1);

        public Builder clusterType(KxClusterType var1);

        public Builder clusterStatus(String var1);

        public Builder clusterStatus(KxClusterStatus var1);
    }
}

