/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.finspace.model.AttributeMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FederationParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FederationParameters> {
    private static final SdkField<String> SAML_METADATA_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("samlMetadataDocument").getter(FederationParameters.getter(FederationParameters::samlMetadataDocument)).setter(FederationParameters.setter(Builder::samlMetadataDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samlMetadataDocument").build()}).build();
    private static final SdkField<String> SAML_METADATA_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("samlMetadataURL").getter(FederationParameters.getter(FederationParameters::samlMetadataURL)).setter(FederationParameters.setter(Builder::samlMetadataURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samlMetadataURL").build()}).build();
    private static final SdkField<String> APPLICATION_CALL_BACK_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationCallBackURL").getter(FederationParameters.getter(FederationParameters::applicationCallBackURL)).setter(FederationParameters.setter(Builder::applicationCallBackURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationCallBackURL").build()}).build();
    private static final SdkField<String> FEDERATION_URN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("federationURN").getter(FederationParameters.getter(FederationParameters::federationURN)).setter(FederationParameters.setter(Builder::federationURN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("federationURN").build()}).build();
    private static final SdkField<String> FEDERATION_PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("federationProviderName").getter(FederationParameters.getter(FederationParameters::federationProviderName)).setter(FederationParameters.setter(Builder::federationProviderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("federationProviderName").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("attributeMap").getter(FederationParameters.getter(FederationParameters::attributeMap)).setter(FederationParameters.setter(Builder::attributeMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAML_METADATA_DOCUMENT_FIELD, SAML_METADATA_URL_FIELD, APPLICATION_CALL_BACK_URL_FIELD, FEDERATION_URN_FIELD, FEDERATION_PROVIDER_NAME_FIELD, ATTRIBUTE_MAP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FederationParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String samlMetadataDocument;
    private final String samlMetadataURL;
    private final String applicationCallBackURL;
    private final String federationURN;
    private final String federationProviderName;
    private final Map<String, String> attributeMap;

    private FederationParameters(BuilderImpl builder) {
        this.samlMetadataDocument = builder.samlMetadataDocument;
        this.samlMetadataURL = builder.samlMetadataURL;
        this.applicationCallBackURL = builder.applicationCallBackURL;
        this.federationURN = builder.federationURN;
        this.federationProviderName = builder.federationProviderName;
        this.attributeMap = builder.attributeMap;
    }

    public final String samlMetadataDocument() {
        return this.samlMetadataDocument;
    }

    public final String samlMetadataURL() {
        return this.samlMetadataURL;
    }

    public final String applicationCallBackURL() {
        return this.applicationCallBackURL;
    }

    public final String federationURN() {
        return this.federationURN;
    }

    public final String federationProviderName() {
        return this.federationProviderName;
    }

    public final boolean hasAttributeMap() {
        return this.attributeMap != null && !(this.attributeMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributeMap() {
        return this.attributeMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.samlMetadataDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.samlMetadataURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationCallBackURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.federationURN());
        hashCode = 31 * hashCode + Objects.hashCode(this.federationProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeMap() ? this.attributeMap() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FederationParameters)) {
            return false;
        }
        FederationParameters other = (FederationParameters)obj;
        return Objects.equals(this.samlMetadataDocument(), other.samlMetadataDocument()) && Objects.equals(this.samlMetadataURL(), other.samlMetadataURL()) && Objects.equals(this.applicationCallBackURL(), other.applicationCallBackURL()) && Objects.equals(this.federationURN(), other.federationURN()) && Objects.equals(this.federationProviderName(), other.federationProviderName()) && this.hasAttributeMap() == other.hasAttributeMap() && Objects.equals(this.attributeMap(), other.attributeMap());
    }

    public final String toString() {
        return ToString.builder((String)"FederationParameters").add("SamlMetadataDocument", (Object)this.samlMetadataDocument()).add("SamlMetadataURL", (Object)this.samlMetadataURL()).add("ApplicationCallBackURL", (Object)this.applicationCallBackURL()).add("FederationURN", (Object)this.federationURN()).add("FederationProviderName", (Object)this.federationProviderName()).add("AttributeMap", this.hasAttributeMap() ? this.attributeMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "samlMetadataDocument": {
                return Optional.ofNullable(clazz.cast(this.samlMetadataDocument()));
            }
            case "samlMetadataURL": {
                return Optional.ofNullable(clazz.cast(this.samlMetadataURL()));
            }
            case "applicationCallBackURL": {
                return Optional.ofNullable(clazz.cast(this.applicationCallBackURL()));
            }
            case "federationURN": {
                return Optional.ofNullable(clazz.cast(this.federationURN()));
            }
            case "federationProviderName": {
                return Optional.ofNullable(clazz.cast(this.federationProviderName()));
            }
            case "attributeMap": {
                return Optional.ofNullable(clazz.cast(this.attributeMap()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("samlMetadataDocument", SAML_METADATA_DOCUMENT_FIELD);
        map.put("samlMetadataURL", SAML_METADATA_URL_FIELD);
        map.put("applicationCallBackURL", APPLICATION_CALL_BACK_URL_FIELD);
        map.put("federationURN", FEDERATION_URN_FIELD);
        map.put("federationProviderName", FEDERATION_PROVIDER_NAME_FIELD);
        map.put("attributeMap", ATTRIBUTE_MAP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FederationParameters, T> g) {
        return obj -> g.apply((FederationParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String samlMetadataDocument;
        private String samlMetadataURL;
        private String applicationCallBackURL;
        private String federationURN;
        private String federationProviderName;
        private Map<String, String> attributeMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FederationParameters model) {
            this.samlMetadataDocument(model.samlMetadataDocument);
            this.samlMetadataURL(model.samlMetadataURL);
            this.applicationCallBackURL(model.applicationCallBackURL);
            this.federationURN(model.federationURN);
            this.federationProviderName(model.federationProviderName);
            this.attributeMap(model.attributeMap);
        }

        public final String getSamlMetadataDocument() {
            return this.samlMetadataDocument;
        }

        public final void setSamlMetadataDocument(String samlMetadataDocument) {
            this.samlMetadataDocument = samlMetadataDocument;
        }

        @Override
        public final Builder samlMetadataDocument(String samlMetadataDocument) {
            this.samlMetadataDocument = samlMetadataDocument;
            return this;
        }

        public final String getSamlMetadataURL() {
            return this.samlMetadataURL;
        }

        public final void setSamlMetadataURL(String samlMetadataURL) {
            this.samlMetadataURL = samlMetadataURL;
        }

        @Override
        public final Builder samlMetadataURL(String samlMetadataURL) {
            this.samlMetadataURL = samlMetadataURL;
            return this;
        }

        public final String getApplicationCallBackURL() {
            return this.applicationCallBackURL;
        }

        public final void setApplicationCallBackURL(String applicationCallBackURL) {
            this.applicationCallBackURL = applicationCallBackURL;
        }

        @Override
        public final Builder applicationCallBackURL(String applicationCallBackURL) {
            this.applicationCallBackURL = applicationCallBackURL;
            return this;
        }

        public final String getFederationURN() {
            return this.federationURN;
        }

        public final void setFederationURN(String federationURN) {
            this.federationURN = federationURN;
        }

        @Override
        public final Builder federationURN(String federationURN) {
            this.federationURN = federationURN;
            return this;
        }

        public final String getFederationProviderName() {
            return this.federationProviderName;
        }

        public final void setFederationProviderName(String federationProviderName) {
            this.federationProviderName = federationProviderName;
        }

        @Override
        public final Builder federationProviderName(String federationProviderName) {
            this.federationProviderName = federationProviderName;
            return this;
        }

        public final Map<String, String> getAttributeMap() {
            if (this.attributeMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributeMap;
        }

        public final void setAttributeMap(Map<String, String> attributeMap) {
            this.attributeMap = AttributeMapCopier.copy(attributeMap);
        }

        @Override
        public final Builder attributeMap(Map<String, String> attributeMap) {
            this.attributeMap = AttributeMapCopier.copy(attributeMap);
            return this;
        }

        public FederationParameters build() {
            return new FederationParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FederationParameters> {
        public Builder samlMetadataDocument(String var1);

        public Builder samlMetadataURL(String var1);

        public Builder applicationCallBackURL(String var1);

        public Builder federationURN(String var1);

        public Builder federationProviderName(String var1);

        public Builder attributeMap(Map<String, String> var1);
    }
}

