/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspace.model.AvailabilityZoneIdsCopier;
import software.amazon.awssdk.services.finspace.model.CustomDNSConfigurationCopier;
import software.amazon.awssdk.services.finspace.model.CustomDNSServer;
import software.amazon.awssdk.services.finspace.model.DnsStatus;
import software.amazon.awssdk.services.finspace.model.EnvironmentStatus;
import software.amazon.awssdk.services.finspace.model.FinspaceResponse;
import software.amazon.awssdk.services.finspace.model.TgwStatus;
import software.amazon.awssdk.services.finspace.model.TransitGatewayConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateKxEnvironmentNetworkResponse
extends FinspaceResponse
implements ToCopyableBuilder<Builder, UpdateKxEnvironmentNetworkResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateKxEnvironmentNetworkResponse.getter(UpdateKxEnvironmentNetworkResponse::name)).setter(UpdateKxEnvironmentNetworkResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(UpdateKxEnvironmentNetworkResponse.getter(UpdateKxEnvironmentNetworkResponse::environmentId)).setter(UpdateKxEnvironmentNetworkResponse.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsAccountId").getter(UpdateKxEnvironmentNetworkResponse.getter(UpdateKxEnvironmentNetworkResponse::awsAccountId)).setter(UpdateKxEnvironmentNetworkResponse.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateKxEnvironmentNetworkResponse.getter(UpdateKxEnvironmentNetworkResponse::statusAsString)).setter(UpdateKxEnvironmentNetworkResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TGW_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tgwStatus").getter(UpdateKxEnvironmentNetworkResponse.getter(UpdateKxEnvironmentNetworkResponse::tgwStatusAsString)).setter(UpdateKxEnvironmentNetworkResponse.setter(Builder::tgwStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tgwStatus").build()}).build();
    private static final SdkField<String> DNS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dnsStatus").getter(UpdateKxEnvironmentNetworkResponse.getter(UpdateKxEnvironmentNetworkResponse::dnsStatusAsString)).setter(UpdateKxEnvironmentNetworkResponse.setter(Builder::dnsStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsStatus").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(UpdateKxEnvironmentNetworkResponse.getter(UpdateKxEnvironmentNetworkResponse::errorMessage)).setter(UpdateKxEnvironmentNetworkResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateKxEnvironmentNetworkResponse.getter(UpdateKxEnvironmentNetworkResponse::description)).setter(UpdateKxEnvironmentNetworkResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentArn").getter(UpdateKxEnvironmentNetworkResponse.getter(UpdateKxEnvironmentNetworkResponse::environmentArn)).setter(UpdateKxEnvironmentNetworkResponse.setter(Builder::environmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentArn").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(UpdateKxEnvironmentNetworkResponse.getter(UpdateKxEnvironmentNetworkResponse::kmsKeyId)).setter(UpdateKxEnvironmentNetworkResponse.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<String> DEDICATED_SERVICE_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dedicatedServiceAccountId").getter(UpdateKxEnvironmentNetworkResponse.getter(UpdateKxEnvironmentNetworkResponse::dedicatedServiceAccountId)).setter(UpdateKxEnvironmentNetworkResponse.setter(Builder::dedicatedServiceAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dedicatedServiceAccountId").build()}).build();
    private static final SdkField<TransitGatewayConfiguration> TRANSIT_GATEWAY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("transitGatewayConfiguration").getter(UpdateKxEnvironmentNetworkResponse.getter(UpdateKxEnvironmentNetworkResponse::transitGatewayConfiguration)).setter(UpdateKxEnvironmentNetworkResponse.setter(Builder::transitGatewayConfiguration)).constructor(TransitGatewayConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transitGatewayConfiguration").build()}).build();
    private static final SdkField<List<CustomDNSServer>> CUSTOM_DNS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("customDNSConfiguration").getter(UpdateKxEnvironmentNetworkResponse.getter(UpdateKxEnvironmentNetworkResponse::customDNSConfiguration)).setter(UpdateKxEnvironmentNetworkResponse.setter(Builder::customDNSConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDNSConfiguration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomDNSServer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTimestamp").getter(UpdateKxEnvironmentNetworkResponse.getter(UpdateKxEnvironmentNetworkResponse::creationTimestamp)).setter(UpdateKxEnvironmentNetworkResponse.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimestamp").build()}).build();
    private static final SdkField<Instant> UPDATE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTimestamp").getter(UpdateKxEnvironmentNetworkResponse.getter(UpdateKxEnvironmentNetworkResponse::updateTimestamp)).setter(UpdateKxEnvironmentNetworkResponse.setter(Builder::updateTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTimestamp").build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("availabilityZoneIds").getter(UpdateKxEnvironmentNetworkResponse.getter(UpdateKxEnvironmentNetworkResponse::availabilityZoneIds)).setter(UpdateKxEnvironmentNetworkResponse.setter(Builder::availabilityZoneIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ENVIRONMENT_ID_FIELD, AWS_ACCOUNT_ID_FIELD, STATUS_FIELD, TGW_STATUS_FIELD, DNS_STATUS_FIELD, ERROR_MESSAGE_FIELD, DESCRIPTION_FIELD, ENVIRONMENT_ARN_FIELD, KMS_KEY_ID_FIELD, DEDICATED_SERVICE_ACCOUNT_ID_FIELD, TRANSIT_GATEWAY_CONFIGURATION_FIELD, CUSTOM_DNS_CONFIGURATION_FIELD, CREATION_TIMESTAMP_FIELD, UPDATE_TIMESTAMP_FIELD, AVAILABILITY_ZONE_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateKxEnvironmentNetworkResponse.memberNameToFieldInitializer();
    private final String name;
    private final String environmentId;
    private final String awsAccountId;
    private final String status;
    private final String tgwStatus;
    private final String dnsStatus;
    private final String errorMessage;
    private final String description;
    private final String environmentArn;
    private final String kmsKeyId;
    private final String dedicatedServiceAccountId;
    private final TransitGatewayConfiguration transitGatewayConfiguration;
    private final List<CustomDNSServer> customDNSConfiguration;
    private final Instant creationTimestamp;
    private final Instant updateTimestamp;
    private final List<String> availabilityZoneIds;

    private UpdateKxEnvironmentNetworkResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.environmentId = builder.environmentId;
        this.awsAccountId = builder.awsAccountId;
        this.status = builder.status;
        this.tgwStatus = builder.tgwStatus;
        this.dnsStatus = builder.dnsStatus;
        this.errorMessage = builder.errorMessage;
        this.description = builder.description;
        this.environmentArn = builder.environmentArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.dedicatedServiceAccountId = builder.dedicatedServiceAccountId;
        this.transitGatewayConfiguration = builder.transitGatewayConfiguration;
        this.customDNSConfiguration = builder.customDNSConfiguration;
        this.creationTimestamp = builder.creationTimestamp;
        this.updateTimestamp = builder.updateTimestamp;
        this.availabilityZoneIds = builder.availabilityZoneIds;
    }

    public final String name() {
        return this.name;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final EnvironmentStatus status() {
        return EnvironmentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final TgwStatus tgwStatus() {
        return TgwStatus.fromValue(this.tgwStatus);
    }

    public final String tgwStatusAsString() {
        return this.tgwStatus;
    }

    public final DnsStatus dnsStatus() {
        return DnsStatus.fromValue(this.dnsStatus);
    }

    public final String dnsStatusAsString() {
        return this.dnsStatus;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final String description() {
        return this.description;
    }

    public final String environmentArn() {
        return this.environmentArn;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String dedicatedServiceAccountId() {
        return this.dedicatedServiceAccountId;
    }

    public final TransitGatewayConfiguration transitGatewayConfiguration() {
        return this.transitGatewayConfiguration;
    }

    public final boolean hasCustomDNSConfiguration() {
        return this.customDNSConfiguration != null && !(this.customDNSConfiguration instanceof SdkAutoConstructList);
    }

    public final List<CustomDNSServer> customDNSConfiguration() {
        return this.customDNSConfiguration;
    }

    public final Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public final Instant updateTimestamp() {
        return this.updateTimestamp;
    }

    public final boolean hasAvailabilityZoneIds() {
        return this.availabilityZoneIds != null && !(this.availabilityZoneIds instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZoneIds() {
        return this.availabilityZoneIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tgwStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dedicatedServiceAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomDNSConfiguration() ? this.customDNSConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZoneIds() ? this.availabilityZoneIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKxEnvironmentNetworkResponse)) {
            return false;
        }
        UpdateKxEnvironmentNetworkResponse other = (UpdateKxEnvironmentNetworkResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.tgwStatusAsString(), other.tgwStatusAsString()) && Objects.equals(this.dnsStatusAsString(), other.dnsStatusAsString()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.environmentArn(), other.environmentArn()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.dedicatedServiceAccountId(), other.dedicatedServiceAccountId()) && Objects.equals(this.transitGatewayConfiguration(), other.transitGatewayConfiguration()) && this.hasCustomDNSConfiguration() == other.hasCustomDNSConfiguration() && Objects.equals(this.customDNSConfiguration(), other.customDNSConfiguration()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.updateTimestamp(), other.updateTimestamp()) && this.hasAvailabilityZoneIds() == other.hasAvailabilityZoneIds() && Objects.equals(this.availabilityZoneIds(), other.availabilityZoneIds());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateKxEnvironmentNetworkResponse").add("Name", (Object)this.name()).add("EnvironmentId", (Object)this.environmentId()).add("AwsAccountId", (Object)this.awsAccountId()).add("Status", (Object)this.statusAsString()).add("TgwStatus", (Object)this.tgwStatusAsString()).add("DnsStatus", (Object)this.dnsStatusAsString()).add("ErrorMessage", (Object)this.errorMessage()).add("Description", (Object)this.description()).add("EnvironmentArn", (Object)this.environmentArn()).add("KmsKeyId", (Object)this.kmsKeyId()).add("DedicatedServiceAccountId", (Object)this.dedicatedServiceAccountId()).add("TransitGatewayConfiguration", (Object)this.transitGatewayConfiguration()).add("CustomDNSConfiguration", this.hasCustomDNSConfiguration() ? this.customDNSConfiguration() : null).add("CreationTimestamp", (Object)this.creationTimestamp()).add("UpdateTimestamp", (Object)this.updateTimestamp()).add("AvailabilityZoneIds", this.hasAvailabilityZoneIds() ? this.availabilityZoneIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "awsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "tgwStatus": {
                return Optional.ofNullable(clazz.cast(this.tgwStatusAsString()));
            }
            case "dnsStatus": {
                return Optional.ofNullable(clazz.cast(this.dnsStatusAsString()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "environmentArn": {
                return Optional.ofNullable(clazz.cast(this.environmentArn()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "dedicatedServiceAccountId": {
                return Optional.ofNullable(clazz.cast(this.dedicatedServiceAccountId()));
            }
            case "transitGatewayConfiguration": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayConfiguration()));
            }
            case "customDNSConfiguration": {
                return Optional.ofNullable(clazz.cast(this.customDNSConfiguration()));
            }
            case "creationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "updateTimestamp": {
                return Optional.ofNullable(clazz.cast(this.updateTimestamp()));
            }
            case "availabilityZoneIds": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("tgwStatus", TGW_STATUS_FIELD);
        map.put("dnsStatus", DNS_STATUS_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("environmentArn", ENVIRONMENT_ARN_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("dedicatedServiceAccountId", DEDICATED_SERVICE_ACCOUNT_ID_FIELD);
        map.put("transitGatewayConfiguration", TRANSIT_GATEWAY_CONFIGURATION_FIELD);
        map.put("customDNSConfiguration", CUSTOM_DNS_CONFIGURATION_FIELD);
        map.put("creationTimestamp", CREATION_TIMESTAMP_FIELD);
        map.put("updateTimestamp", UPDATE_TIMESTAMP_FIELD);
        map.put("availabilityZoneIds", AVAILABILITY_ZONE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateKxEnvironmentNetworkResponse, T> g) {
        return obj -> g.apply((UpdateKxEnvironmentNetworkResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceResponse.BuilderImpl
    implements Builder {
        private String name;
        private String environmentId;
        private String awsAccountId;
        private String status;
        private String tgwStatus;
        private String dnsStatus;
        private String errorMessage;
        private String description;
        private String environmentArn;
        private String kmsKeyId;
        private String dedicatedServiceAccountId;
        private TransitGatewayConfiguration transitGatewayConfiguration;
        private List<CustomDNSServer> customDNSConfiguration = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTimestamp;
        private Instant updateTimestamp;
        private List<String> availabilityZoneIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKxEnvironmentNetworkResponse model) {
            super(model);
            this.name(model.name);
            this.environmentId(model.environmentId);
            this.awsAccountId(model.awsAccountId);
            this.status(model.status);
            this.tgwStatus(model.tgwStatus);
            this.dnsStatus(model.dnsStatus);
            this.errorMessage(model.errorMessage);
            this.description(model.description);
            this.environmentArn(model.environmentArn);
            this.kmsKeyId(model.kmsKeyId);
            this.dedicatedServiceAccountId(model.dedicatedServiceAccountId);
            this.transitGatewayConfiguration(model.transitGatewayConfiguration);
            this.customDNSConfiguration(model.customDNSConfiguration);
            this.creationTimestamp(model.creationTimestamp);
            this.updateTimestamp(model.updateTimestamp);
            this.availabilityZoneIds(model.availabilityZoneIds);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTgwStatus() {
            return this.tgwStatus;
        }

        public final void setTgwStatus(String tgwStatus) {
            this.tgwStatus = tgwStatus;
        }

        @Override
        public final Builder tgwStatus(String tgwStatus) {
            this.tgwStatus = tgwStatus;
            return this;
        }

        @Override
        public final Builder tgwStatus(TgwStatus tgwStatus) {
            this.tgwStatus(tgwStatus == null ? null : tgwStatus.toString());
            return this;
        }

        public final String getDnsStatus() {
            return this.dnsStatus;
        }

        public final void setDnsStatus(String dnsStatus) {
            this.dnsStatus = dnsStatus;
        }

        @Override
        public final Builder dnsStatus(String dnsStatus) {
            this.dnsStatus = dnsStatus;
            return this;
        }

        @Override
        public final Builder dnsStatus(DnsStatus dnsStatus) {
            this.dnsStatus(dnsStatus == null ? null : dnsStatus.toString());
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEnvironmentArn() {
            return this.environmentArn;
        }

        public final void setEnvironmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
        }

        @Override
        public final Builder environmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getDedicatedServiceAccountId() {
            return this.dedicatedServiceAccountId;
        }

        public final void setDedicatedServiceAccountId(String dedicatedServiceAccountId) {
            this.dedicatedServiceAccountId = dedicatedServiceAccountId;
        }

        @Override
        public final Builder dedicatedServiceAccountId(String dedicatedServiceAccountId) {
            this.dedicatedServiceAccountId = dedicatedServiceAccountId;
            return this;
        }

        public final TransitGatewayConfiguration.Builder getTransitGatewayConfiguration() {
            return this.transitGatewayConfiguration != null ? this.transitGatewayConfiguration.toBuilder() : null;
        }

        public final void setTransitGatewayConfiguration(TransitGatewayConfiguration.BuilderImpl transitGatewayConfiguration) {
            this.transitGatewayConfiguration = transitGatewayConfiguration != null ? transitGatewayConfiguration.build() : null;
        }

        @Override
        public final Builder transitGatewayConfiguration(TransitGatewayConfiguration transitGatewayConfiguration) {
            this.transitGatewayConfiguration = transitGatewayConfiguration;
            return this;
        }

        public final List<CustomDNSServer.Builder> getCustomDNSConfiguration() {
            List<CustomDNSServer.Builder> result = CustomDNSConfigurationCopier.copyToBuilder(this.customDNSConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomDNSConfiguration(Collection<CustomDNSServer.BuilderImpl> customDNSConfiguration) {
            this.customDNSConfiguration = CustomDNSConfigurationCopier.copyFromBuilder(customDNSConfiguration);
        }

        @Override
        public final Builder customDNSConfiguration(Collection<CustomDNSServer> customDNSConfiguration) {
            this.customDNSConfiguration = CustomDNSConfigurationCopier.copy(customDNSConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customDNSConfiguration(CustomDNSServer ... customDNSConfiguration) {
            this.customDNSConfiguration(Arrays.asList(customDNSConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customDNSConfiguration(Consumer<CustomDNSServer.Builder> ... customDNSConfiguration) {
            this.customDNSConfiguration(Stream.of(customDNSConfiguration).map(c -> (CustomDNSServer)((CustomDNSServer.Builder)CustomDNSServer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final Instant getUpdateTimestamp() {
            return this.updateTimestamp;
        }

        public final void setUpdateTimestamp(Instant updateTimestamp) {
            this.updateTimestamp = updateTimestamp;
        }

        @Override
        public final Builder updateTimestamp(Instant updateTimestamp) {
            this.updateTimestamp = updateTimestamp;
            return this;
        }

        public final Collection<String> getAvailabilityZoneIds() {
            if (this.availabilityZoneIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZoneIds;
        }

        public final void setAvailabilityZoneIds(Collection<String> availabilityZoneIds) {
            this.availabilityZoneIds = AvailabilityZoneIdsCopier.copy(availabilityZoneIds);
        }

        @Override
        public final Builder availabilityZoneIds(Collection<String> availabilityZoneIds) {
            this.availabilityZoneIds = AvailabilityZoneIdsCopier.copy(availabilityZoneIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZoneIds(String ... availabilityZoneIds) {
            this.availabilityZoneIds(Arrays.asList(availabilityZoneIds));
            return this;
        }

        @Override
        public UpdateKxEnvironmentNetworkResponse build() {
            return new UpdateKxEnvironmentNetworkResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FinspaceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateKxEnvironmentNetworkResponse> {
        public Builder name(String var1);

        public Builder environmentId(String var1);

        public Builder awsAccountId(String var1);

        public Builder status(String var1);

        public Builder status(EnvironmentStatus var1);

        public Builder tgwStatus(String var1);

        public Builder tgwStatus(TgwStatus var1);

        public Builder dnsStatus(String var1);

        public Builder dnsStatus(DnsStatus var1);

        public Builder errorMessage(String var1);

        public Builder description(String var1);

        public Builder environmentArn(String var1);

        public Builder kmsKeyId(String var1);

        public Builder dedicatedServiceAccountId(String var1);

        public Builder transitGatewayConfiguration(TransitGatewayConfiguration var1);

        default public Builder transitGatewayConfiguration(Consumer<TransitGatewayConfiguration.Builder> transitGatewayConfiguration) {
            return this.transitGatewayConfiguration((TransitGatewayConfiguration)((TransitGatewayConfiguration.Builder)TransitGatewayConfiguration.builder().applyMutation(transitGatewayConfiguration)).build());
        }

        public Builder customDNSConfiguration(Collection<CustomDNSServer> var1);

        public Builder customDNSConfiguration(CustomDNSServer ... var1);

        public Builder customDNSConfiguration(Consumer<CustomDNSServer.Builder> ... var1);

        public Builder creationTimestamp(Instant var1);

        public Builder updateTimestamp(Instant var1);

        public Builder availabilityZoneIds(Collection<String> var1);

        public Builder availabilityZoneIds(String ... var1);
    }
}

