/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspace.model.FinspaceRequest;
import software.amazon.awssdk.services.finspace.model.KxNAS1Configuration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateKxVolumeRequest
extends FinspaceRequest
implements ToCopyableBuilder<Builder, UpdateKxVolumeRequest> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(UpdateKxVolumeRequest.getter(UpdateKxVolumeRequest::environmentId)).setter(UpdateKxVolumeRequest.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentId").build()}).build();
    private static final SdkField<String> VOLUME_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("volumeName").getter(UpdateKxVolumeRequest.getter(UpdateKxVolumeRequest::volumeName)).setter(UpdateKxVolumeRequest.setter(Builder::volumeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("volumeName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateKxVolumeRequest.getter(UpdateKxVolumeRequest::description)).setter(UpdateKxVolumeRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateKxVolumeRequest.getter(UpdateKxVolumeRequest::clientToken)).setter(UpdateKxVolumeRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<KxNAS1Configuration> NAS1_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("nas1Configuration").getter(UpdateKxVolumeRequest.getter(UpdateKxVolumeRequest::nas1Configuration)).setter(UpdateKxVolumeRequest.setter(Builder::nas1Configuration)).constructor(KxNAS1Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nas1Configuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD, VOLUME_NAME_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD, NAS1_CONFIGURATION_FIELD));
    private final String environmentId;
    private final String volumeName;
    private final String description;
    private final String clientToken;
    private final KxNAS1Configuration nas1Configuration;

    private UpdateKxVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.volumeName = builder.volumeName;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
        this.nas1Configuration = builder.nas1Configuration;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String volumeName() {
        return this.volumeName;
    }

    public final String description() {
        return this.description;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final KxNAS1Configuration nas1Configuration() {
        return this.nas1Configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.nas1Configuration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKxVolumeRequest)) {
            return false;
        }
        UpdateKxVolumeRequest other = (UpdateKxVolumeRequest)((Object)obj);
        return Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.volumeName(), other.volumeName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.nas1Configuration(), other.nas1Configuration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateKxVolumeRequest").add("EnvironmentId", (Object)this.environmentId()).add("VolumeName", (Object)this.volumeName()).add("Description", (Object)this.description()).add("ClientToken", (Object)this.clientToken()).add("Nas1Configuration", (Object)this.nas1Configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "volumeName": {
                return Optional.ofNullable(clazz.cast(this.volumeName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "nas1Configuration": {
                return Optional.ofNullable(clazz.cast(this.nas1Configuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateKxVolumeRequest, T> g) {
        return obj -> g.apply((UpdateKxVolumeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceRequest.BuilderImpl
    implements Builder {
        private String environmentId;
        private String volumeName;
        private String description;
        private String clientToken;
        private KxNAS1Configuration nas1Configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKxVolumeRequest model) {
            super(model);
            this.environmentId(model.environmentId);
            this.volumeName(model.volumeName);
            this.description(model.description);
            this.clientToken(model.clientToken);
            this.nas1Configuration(model.nas1Configuration);
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getVolumeName() {
            return this.volumeName;
        }

        public final void setVolumeName(String volumeName) {
            this.volumeName = volumeName;
        }

        @Override
        public final Builder volumeName(String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final KxNAS1Configuration.Builder getNas1Configuration() {
            return this.nas1Configuration != null ? this.nas1Configuration.toBuilder() : null;
        }

        public final void setNas1Configuration(KxNAS1Configuration.BuilderImpl nas1Configuration) {
            this.nas1Configuration = nas1Configuration != null ? nas1Configuration.build() : null;
        }

        @Override
        public final Builder nas1Configuration(KxNAS1Configuration nas1Configuration) {
            this.nas1Configuration = nas1Configuration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateKxVolumeRequest build() {
            return new UpdateKxVolumeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FinspaceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateKxVolumeRequest> {
        public Builder environmentId(String var1);

        public Builder volumeName(String var1);

        public Builder description(String var1);

        public Builder clientToken(String var1);

        public Builder nas1Configuration(KxNAS1Configuration var1);

        default public Builder nas1Configuration(Consumer<KxNAS1Configuration.Builder> nas1Configuration) {
            return this.nas1Configuration((KxNAS1Configuration)((KxNAS1Configuration.Builder)KxNAS1Configuration.builder().applyMutation(nas1Configuration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

