/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.finspace.model.FinspaceRequest;
import software.amazon.awssdk.services.finspace.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateKxScalingGroupRequest
extends FinspaceRequest
implements ToCopyableBuilder<Builder, CreateKxScalingGroupRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateKxScalingGroupRequest.getter(CreateKxScalingGroupRequest::clientToken)).setter(CreateKxScalingGroupRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(CreateKxScalingGroupRequest.getter(CreateKxScalingGroupRequest::environmentId)).setter(CreateKxScalingGroupRequest.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentId").build()}).build();
    private static final SdkField<String> SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scalingGroupName").getter(CreateKxScalingGroupRequest.getter(CreateKxScalingGroupRequest::scalingGroupName)).setter(CreateKxScalingGroupRequest.setter(Builder::scalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingGroupName").build()}).build();
    private static final SdkField<String> HOST_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostType").getter(CreateKxScalingGroupRequest.getter(CreateKxScalingGroupRequest::hostType)).setter(CreateKxScalingGroupRequest.setter(Builder::hostType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostType").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZoneId").getter(CreateKxScalingGroupRequest.getter(CreateKxScalingGroupRequest::availabilityZoneId)).setter(CreateKxScalingGroupRequest.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateKxScalingGroupRequest.getter(CreateKxScalingGroupRequest::tags)).setter(CreateKxScalingGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, ENVIRONMENT_ID_FIELD, SCALING_GROUP_NAME_FIELD, HOST_TYPE_FIELD, AVAILABILITY_ZONE_ID_FIELD, TAGS_FIELD));
    private final String clientToken;
    private final String environmentId;
    private final String scalingGroupName;
    private final String hostType;
    private final String availabilityZoneId;
    private final Map<String, String> tags;

    private CreateKxScalingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.environmentId = builder.environmentId;
        this.scalingGroupName = builder.scalingGroupName;
        this.hostType = builder.hostType;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.tags = builder.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String scalingGroupName() {
        return this.scalingGroupName;
    }

    public final String hostType() {
        return this.hostType;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostType());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKxScalingGroupRequest)) {
            return false;
        }
        CreateKxScalingGroupRequest other = (CreateKxScalingGroupRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.scalingGroupName(), other.scalingGroupName()) && Objects.equals(this.hostType(), other.hostType()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateKxScalingGroupRequest").add("ClientToken", (Object)this.clientToken()).add("EnvironmentId", (Object)this.environmentId()).add("ScalingGroupName", (Object)this.scalingGroupName()).add("HostType", (Object)this.hostType()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "scalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.scalingGroupName()));
            }
            case "hostType": {
                return Optional.ofNullable(clazz.cast(this.hostType()));
            }
            case "availabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateKxScalingGroupRequest, T> g) {
        return obj -> g.apply((CreateKxScalingGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String environmentId;
        private String scalingGroupName;
        private String hostType;
        private String availabilityZoneId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKxScalingGroupRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.environmentId(model.environmentId);
            this.scalingGroupName(model.scalingGroupName);
            this.hostType(model.hostType);
            this.availabilityZoneId(model.availabilityZoneId);
            this.tags(model.tags);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getScalingGroupName() {
            return this.scalingGroupName;
        }

        public final void setScalingGroupName(String scalingGroupName) {
            this.scalingGroupName = scalingGroupName;
        }

        @Override
        public final Builder scalingGroupName(String scalingGroupName) {
            this.scalingGroupName = scalingGroupName;
            return this;
        }

        public final String getHostType() {
            return this.hostType;
        }

        public final void setHostType(String hostType) {
            this.hostType = hostType;
        }

        @Override
        public final Builder hostType(String hostType) {
            this.hostType = hostType;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateKxScalingGroupRequest build() {
            return new CreateKxScalingGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FinspaceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateKxScalingGroupRequest> {
        public Builder clientToken(String var1);

        public Builder environmentId(String var1);

        public Builder scalingGroupName(String var1);

        public Builder hostType(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

