/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure for the metadata of a cluster. It includes information like the CPUs needed, memory of instances, number
 * of instances, and the port used while establishing a connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityConfiguration.Builder, CapacityConfiguration> {
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeType").getter(getter(CapacityConfiguration::nodeType)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeType").build()).build();

    private static final SdkField<Integer> NODE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("nodeCount").getter(getter(CapacityConfiguration::nodeCount)).setter(setter(Builder::nodeCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_TYPE_FIELD,
            NODE_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String nodeType;

    private final Integer nodeCount;

    private CapacityConfiguration(BuilderImpl builder) {
        this.nodeType = builder.nodeType;
        this.nodeCount = builder.nodeCount;
    }

    /**
     * <p>
     * The type that determines the hardware of the host computer used for your cluster instance. Each node type offers
     * different memory and storage capabilities. Choose a node type based on the requirements of the application or
     * software that you plan to run on your instance.
     * </p>
     * <p>
     * You can only specify one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>kx.s.large</code> – The node type with a configuration of 12 GiB memory and 2 vCPUs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>kx.s.xlarge</code> – The node type with a configuration of 27 GiB memory and 4 vCPUs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>kx.s.2xlarge</code> – The node type with a configuration of 54 GiB memory and 8 vCPUs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>kx.s.4xlarge</code> – The node type with a configuration of 108 GiB memory and 16 vCPUs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>kx.s.8xlarge</code> – The node type with a configuration of 216 GiB memory and 32 vCPUs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>kx.s.16xlarge</code> – The node type with a configuration of 432 GiB memory and 64 vCPUs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>kx.s.32xlarge</code> – The node type with a configuration of 864 GiB memory and 128 vCPUs.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type that determines the hardware of the host computer used for your cluster instance. Each node type
     *         offers different memory and storage capabilities. Choose a node type based on the requirements of the
     *         application or software that you plan to run on your instance.</p>
     *         <p>
     *         You can only specify one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>kx.s.large</code> – The node type with a configuration of 12 GiB memory and 2 vCPUs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>kx.s.xlarge</code> – The node type with a configuration of 27 GiB memory and 4 vCPUs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>kx.s.2xlarge</code> – The node type with a configuration of 54 GiB memory and 8 vCPUs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>kx.s.4xlarge</code> – The node type with a configuration of 108 GiB memory and 16 vCPUs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>kx.s.8xlarge</code> – The node type with a configuration of 216 GiB memory and 32 vCPUs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>kx.s.16xlarge</code> – The node type with a configuration of 432 GiB memory and 64 vCPUs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>kx.s.32xlarge</code> – The node type with a configuration of 864 GiB memory and 128 vCPUs.
     *         </p>
     *         </li>
     */
    public final String nodeType() {
        return nodeType;
    }

    /**
     * <p>
     * The number of instances running in a cluster.
     * </p>
     * 
     * @return The number of instances running in a cluster.
     */
    public final Integer nodeCount() {
        return nodeCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(nodeCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityConfiguration)) {
            return false;
        }
        CapacityConfiguration other = (CapacityConfiguration) obj;
        return Objects.equals(nodeType(), other.nodeType()) && Objects.equals(nodeCount(), other.nodeCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityConfiguration").add("NodeType", nodeType()).add("NodeCount", nodeCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nodeType":
            return Optional.ofNullable(clazz.cast(nodeType()));
        case "nodeCount":
            return Optional.ofNullable(clazz.cast(nodeCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CapacityConfiguration, T> g) {
        return obj -> g.apply((CapacityConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityConfiguration> {
        /**
         * <p>
         * The type that determines the hardware of the host computer used for your cluster instance. Each node type
         * offers different memory and storage capabilities. Choose a node type based on the requirements of the
         * application or software that you plan to run on your instance.
         * </p>
         * <p>
         * You can only specify one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>kx.s.large</code> – The node type with a configuration of 12 GiB memory and 2 vCPUs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kx.s.xlarge</code> – The node type with a configuration of 27 GiB memory and 4 vCPUs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kx.s.2xlarge</code> – The node type with a configuration of 54 GiB memory and 8 vCPUs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kx.s.4xlarge</code> – The node type with a configuration of 108 GiB memory and 16 vCPUs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kx.s.8xlarge</code> – The node type with a configuration of 216 GiB memory and 32 vCPUs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kx.s.16xlarge</code> – The node type with a configuration of 432 GiB memory and 64 vCPUs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kx.s.32xlarge</code> – The node type with a configuration of 864 GiB memory and 128 vCPUs.
         * </p>
         * </li>
         * </ul>
         * 
         * @param nodeType
         *        The type that determines the hardware of the host computer used for your cluster instance. Each node
         *        type offers different memory and storage capabilities. Choose a node type based on the requirements of
         *        the application or software that you plan to run on your instance.</p>
         *        <p>
         *        You can only specify one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>kx.s.large</code> – The node type with a configuration of 12 GiB memory and 2 vCPUs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kx.s.xlarge</code> – The node type with a configuration of 27 GiB memory and 4 vCPUs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kx.s.2xlarge</code> – The node type with a configuration of 54 GiB memory and 8 vCPUs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kx.s.4xlarge</code> – The node type with a configuration of 108 GiB memory and 16 vCPUs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kx.s.8xlarge</code> – The node type with a configuration of 216 GiB memory and 32 vCPUs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kx.s.16xlarge</code> – The node type with a configuration of 432 GiB memory and 64 vCPUs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kx.s.32xlarge</code> – The node type with a configuration of 864 GiB memory and 128 vCPUs.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * The number of instances running in a cluster.
         * </p>
         * 
         * @param nodeCount
         *        The number of instances running in a cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeCount(Integer nodeCount);
    }

    static final class BuilderImpl implements Builder {
        private String nodeType;

        private Integer nodeCount;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityConfiguration model) {
            nodeType(model.nodeType);
            nodeCount(model.nodeCount);
        }

        public final String getNodeType() {
            return nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final Integer getNodeCount() {
            return nodeCount;
        }

        public final void setNodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
        }

        @Override
        public final Builder nodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
            return this;
        }

        @Override
        public CapacityConfiguration build() {
            return new CapacityConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
