/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspace.model.FederationMode;
import software.amazon.awssdk.services.finspace.model.FederationParameters;
import software.amazon.awssdk.services.finspace.model.FinspaceRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEnvironmentRequest
extends FinspaceRequest
implements ToCopyableBuilder<Builder, UpdateEnvironmentRequest> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::environmentId)).setter(UpdateEnvironmentRequest.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::name)).setter(UpdateEnvironmentRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::description)).setter(UpdateEnvironmentRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> FEDERATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("federationMode").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::federationModeAsString)).setter(UpdateEnvironmentRequest.setter(Builder::federationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("federationMode").build()}).build();
    private static final SdkField<FederationParameters> FEDERATION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("federationParameters").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::federationParameters)).setter(UpdateEnvironmentRequest.setter(Builder::federationParameters)).constructor(FederationParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("federationParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, FEDERATION_MODE_FIELD, FEDERATION_PARAMETERS_FIELD));
    private final String environmentId;
    private final String name;
    private final String description;
    private final String federationMode;
    private final FederationParameters federationParameters;

    private UpdateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.name = builder.name;
        this.description = builder.description;
        this.federationMode = builder.federationMode;
        this.federationParameters = builder.federationParameters;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final FederationMode federationMode() {
        return FederationMode.fromValue(this.federationMode);
    }

    public final String federationModeAsString() {
        return this.federationMode;
    }

    public final FederationParameters federationParameters() {
        return this.federationParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.federationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.federationParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEnvironmentRequest)) {
            return false;
        }
        UpdateEnvironmentRequest other = (UpdateEnvironmentRequest)((Object)obj);
        return Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.federationModeAsString(), other.federationModeAsString()) && Objects.equals(this.federationParameters(), other.federationParameters());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEnvironmentRequest").add("EnvironmentId", (Object)this.environmentId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("FederationMode", (Object)this.federationModeAsString()).add("FederationParameters", (Object)this.federationParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "federationMode": {
                return Optional.ofNullable(clazz.cast(this.federationModeAsString()));
            }
            case "federationParameters": {
                return Optional.ofNullable(clazz.cast(this.federationParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEnvironmentRequest, T> g) {
        return obj -> g.apply((UpdateEnvironmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceRequest.BuilderImpl
    implements Builder {
        private String environmentId;
        private String name;
        private String description;
        private String federationMode;
        private FederationParameters federationParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEnvironmentRequest model) {
            super(model);
            this.environmentId(model.environmentId);
            this.name(model.name);
            this.description(model.description);
            this.federationMode(model.federationMode);
            this.federationParameters(model.federationParameters);
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getFederationMode() {
            return this.federationMode;
        }

        @Override
        public final Builder federationMode(String federationMode) {
            this.federationMode = federationMode;
            return this;
        }

        @Override
        public final Builder federationMode(FederationMode federationMode) {
            this.federationMode(federationMode == null ? null : federationMode.toString());
            return this;
        }

        public final void setFederationMode(String federationMode) {
            this.federationMode = federationMode;
        }

        public final FederationParameters.Builder getFederationParameters() {
            return this.federationParameters != null ? this.federationParameters.toBuilder() : null;
        }

        @Override
        public final Builder federationParameters(FederationParameters federationParameters) {
            this.federationParameters = federationParameters;
            return this;
        }

        public final void setFederationParameters(FederationParameters.BuilderImpl federationParameters) {
            this.federationParameters = federationParameters != null ? federationParameters.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEnvironmentRequest build() {
            return new UpdateEnvironmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FinspaceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEnvironmentRequest> {
        public Builder environmentId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder federationMode(String var1);

        public Builder federationMode(FederationMode var1);

        public Builder federationParameters(FederationParameters var1);

        default public Builder federationParameters(Consumer<FederationParameters.Builder> federationParameters) {
            return this.federationParameters((FederationParameters)((FederationParameters.Builder)FederationParameters.builder().applyMutation(federationParameters)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

