/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InstanceType {
    I4_I_METAL("i4i.metal"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InstanceType> VALUE_MAP;
    private final String value;

    private InstanceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceType> knownValues() {
        EnumSet<InstanceType> knownValues = EnumSet.allOf(InstanceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InstanceType.class, InstanceType::toString);
    }
}

