/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.evs.model.EvsResponse;
import software.amazon.awssdk.services.evs.model.Vlan;
import software.amazon.awssdk.services.evs.model.VlanListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEnvironmentVlansResponse
extends EvsResponse
implements ToCopyableBuilder<Builder, ListEnvironmentVlansResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEnvironmentVlansResponse.getter(ListEnvironmentVlansResponse::nextToken)).setter(ListEnvironmentVlansResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<Vlan>> ENVIRONMENT_VLANS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("environmentVlans").getter(ListEnvironmentVlansResponse.getter(ListEnvironmentVlansResponse::environmentVlans)).setter(ListEnvironmentVlansResponse.setter(Builder::environmentVlans)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVlans").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Vlan::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ENVIRONMENT_VLANS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEnvironmentVlansResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<Vlan> environmentVlans;

    private ListEnvironmentVlansResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.environmentVlans = builder.environmentVlans;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasEnvironmentVlans() {
        return this.environmentVlans != null && !(this.environmentVlans instanceof SdkAutoConstructList);
    }

    public final List<Vlan> environmentVlans() {
        return this.environmentVlans;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentVlans() ? this.environmentVlans() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentVlansResponse)) {
            return false;
        }
        ListEnvironmentVlansResponse other = (ListEnvironmentVlansResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasEnvironmentVlans() == other.hasEnvironmentVlans() && Objects.equals(this.environmentVlans(), other.environmentVlans());
    }

    public final String toString() {
        return ToString.builder((String)"ListEnvironmentVlansResponse").add("NextToken", (Object)this.nextToken()).add("EnvironmentVlans", this.hasEnvironmentVlans() ? this.environmentVlans() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "environmentVlans": {
                return Optional.ofNullable(clazz.cast(this.environmentVlans()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("environmentVlans", ENVIRONMENT_VLANS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEnvironmentVlansResponse, T> g) {
        return obj -> g.apply((ListEnvironmentVlansResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EvsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<Vlan> environmentVlans = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnvironmentVlansResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.environmentVlans(model.environmentVlans);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Vlan.Builder> getEnvironmentVlans() {
            List<Vlan.Builder> result = VlanListCopier.copyToBuilder(this.environmentVlans);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentVlans(Collection<Vlan.BuilderImpl> environmentVlans) {
            this.environmentVlans = VlanListCopier.copyFromBuilder(environmentVlans);
        }

        @Override
        public final Builder environmentVlans(Collection<Vlan> environmentVlans) {
            this.environmentVlans = VlanListCopier.copy(environmentVlans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentVlans(Vlan ... environmentVlans) {
            this.environmentVlans(Arrays.asList(environmentVlans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentVlans(Consumer<Vlan.Builder> ... environmentVlans) {
            this.environmentVlans(Stream.of(environmentVlans).map(c -> (Vlan)((Vlan.Builder)Vlan.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListEnvironmentVlansResponse build() {
            return new ListEnvironmentVlansResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EvsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEnvironmentVlansResponse> {
        public Builder nextToken(String var1);

        public Builder environmentVlans(Collection<Vlan> var1);

        public Builder environmentVlans(Vlan ... var1);

        public Builder environmentVlans(Consumer<Vlan.Builder> ... var1);
    }
}

