/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.evs.EvsAsyncClient;
import software.amazon.awssdk.services.evs.internal.UserAgentUtils;
import software.amazon.awssdk.services.evs.model.Host;
import software.amazon.awssdk.services.evs.model.ListEnvironmentHostsRequest;
import software.amazon.awssdk.services.evs.model.ListEnvironmentHostsResponse;

public class ListEnvironmentHostsPublisher
implements SdkPublisher<ListEnvironmentHostsResponse> {
    private final EvsAsyncClient client;
    private final ListEnvironmentHostsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEnvironmentHostsPublisher(EvsAsyncClient client, ListEnvironmentHostsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEnvironmentHostsPublisher(EvsAsyncClient client, ListEnvironmentHostsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEnvironmentHostsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEnvironmentHostsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Host> environmentHosts() {
        Function<ListEnvironmentHostsResponse, Iterator> getIterator = response -> {
            if (response != null && response.environmentHosts() != null) {
                return response.environmentHosts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEnvironmentHostsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEnvironmentHostsResponseFetcher
    implements AsyncPageFetcher<ListEnvironmentHostsResponse> {
        private ListEnvironmentHostsResponseFetcher() {
        }

        public boolean hasNextPage(ListEnvironmentHostsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEnvironmentHostsResponse> nextPage(ListEnvironmentHostsResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentHostsPublisher.this.client.listEnvironmentHosts(ListEnvironmentHostsPublisher.this.firstRequest);
            }
            return ListEnvironmentHostsPublisher.this.client.listEnvironmentHosts((ListEnvironmentHostsRequest)((Object)ListEnvironmentHostsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

