/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.evidently.model.ExperimentExecution;
import software.amazon.awssdk.services.evidently.model.ExperimentSchedule;
import software.amazon.awssdk.services.evidently.model.ExperimentStatus;
import software.amazon.awssdk.services.evidently.model.ExperimentType;
import software.amazon.awssdk.services.evidently.model.MetricGoal;
import software.amazon.awssdk.services.evidently.model.MetricGoalsListCopier;
import software.amazon.awssdk.services.evidently.model.OnlineAbDefinition;
import software.amazon.awssdk.services.evidently.model.TagMapCopier;
import software.amazon.awssdk.services.evidently.model.Treatment;
import software.amazon.awssdk.services.evidently.model.TreatmentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Experiment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Experiment> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Experiment.getter(Experiment::arn)).setter(Experiment.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTime").getter(Experiment.getter(Experiment::createdTime)).setter(Experiment.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Experiment.getter(Experiment::description)).setter(Experiment.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<ExperimentExecution> EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("execution").getter(Experiment.getter(Experiment::execution)).setter(Experiment.setter(Builder::execution)).constructor(ExperimentExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("execution").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedTime").getter(Experiment.getter(Experiment::lastUpdatedTime)).setter(Experiment.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final SdkField<List<MetricGoal>> METRIC_GOALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metricGoals").getter(Experiment.getter(Experiment::metricGoals)).setter(Experiment.setter(Builder::metricGoals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricGoals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricGoal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Experiment.getter(Experiment::name)).setter(Experiment.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<OnlineAbDefinition> ONLINE_AB_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("onlineAbDefinition").getter(Experiment.getter(Experiment::onlineAbDefinition)).setter(Experiment.setter(Builder::onlineAbDefinition)).constructor(OnlineAbDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onlineAbDefinition").build()}).build();
    private static final SdkField<String> PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("project").getter(Experiment.getter(Experiment::project)).setter(Experiment.setter(Builder::project)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("project").build()}).build();
    private static final SdkField<String> RANDOMIZATION_SALT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("randomizationSalt").getter(Experiment.getter(Experiment::randomizationSalt)).setter(Experiment.setter(Builder::randomizationSalt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("randomizationSalt").build()}).build();
    private static final SdkField<Long> SAMPLING_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("samplingRate").getter(Experiment.getter(Experiment::samplingRate)).setter(Experiment.setter(Builder::samplingRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samplingRate").build()}).build();
    private static final SdkField<ExperimentSchedule> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("schedule").getter(Experiment.getter(Experiment::schedule)).setter(Experiment.setter(Builder::schedule)).constructor(ExperimentSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()}).build();
    private static final SdkField<String> SEGMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("segment").getter(Experiment.getter(Experiment::segment)).setter(Experiment.setter(Builder::segment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segment").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Experiment.getter(Experiment::statusAsString)).setter(Experiment.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(Experiment.getter(Experiment::statusReason)).setter(Experiment.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(Experiment.getter(Experiment::tags)).setter(Experiment.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<Treatment>> TREATMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("treatments").getter(Experiment.getter(Experiment::treatments)).setter(Experiment.setter(Builder::treatments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treatments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Treatment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Experiment.getter(Experiment::typeAsString)).setter(Experiment.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_TIME_FIELD, DESCRIPTION_FIELD, EXECUTION_FIELD, LAST_UPDATED_TIME_FIELD, METRIC_GOALS_FIELD, NAME_FIELD, ONLINE_AB_DEFINITION_FIELD, PROJECT_FIELD, RANDOMIZATION_SALT_FIELD, SAMPLING_RATE_FIELD, SCHEDULE_FIELD, SEGMENT_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, TAGS_FIELD, TREATMENTS_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Experiment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant createdTime;
    private final String description;
    private final ExperimentExecution execution;
    private final Instant lastUpdatedTime;
    private final List<MetricGoal> metricGoals;
    private final String name;
    private final OnlineAbDefinition onlineAbDefinition;
    private final String project;
    private final String randomizationSalt;
    private final Long samplingRate;
    private final ExperimentSchedule schedule;
    private final String segment;
    private final String status;
    private final String statusReason;
    private final Map<String, String> tags;
    private final List<Treatment> treatments;
    private final String type;

    private Experiment(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdTime = builder.createdTime;
        this.description = builder.description;
        this.execution = builder.execution;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.metricGoals = builder.metricGoals;
        this.name = builder.name;
        this.onlineAbDefinition = builder.onlineAbDefinition;
        this.project = builder.project;
        this.randomizationSalt = builder.randomizationSalt;
        this.samplingRate = builder.samplingRate;
        this.schedule = builder.schedule;
        this.segment = builder.segment;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.tags = builder.tags;
        this.treatments = builder.treatments;
        this.type = builder.type;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String description() {
        return this.description;
    }

    public final ExperimentExecution execution() {
        return this.execution;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final boolean hasMetricGoals() {
        return this.metricGoals != null && !(this.metricGoals instanceof SdkAutoConstructList);
    }

    public final List<MetricGoal> metricGoals() {
        return this.metricGoals;
    }

    public final String name() {
        return this.name;
    }

    public final OnlineAbDefinition onlineAbDefinition() {
        return this.onlineAbDefinition;
    }

    public final String project() {
        return this.project;
    }

    public final String randomizationSalt() {
        return this.randomizationSalt;
    }

    public final Long samplingRate() {
        return this.samplingRate;
    }

    public final ExperimentSchedule schedule() {
        return this.schedule;
    }

    public final String segment() {
        return this.segment;
    }

    public final ExperimentStatus status() {
        return ExperimentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasTreatments() {
        return this.treatments != null && !(this.treatments instanceof SdkAutoConstructList);
    }

    public final List<Treatment> treatments() {
        return this.treatments;
    }

    public final ExperimentType type() {
        return ExperimentType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.execution());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricGoals() ? this.metricGoals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.onlineAbDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.project());
        hashCode = 31 * hashCode + Objects.hashCode(this.randomizationSalt());
        hashCode = 31 * hashCode + Objects.hashCode(this.samplingRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.segment());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTreatments() ? this.treatments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Experiment)) {
            return false;
        }
        Experiment other = (Experiment)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.execution(), other.execution()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && this.hasMetricGoals() == other.hasMetricGoals() && Objects.equals(this.metricGoals(), other.metricGoals()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.onlineAbDefinition(), other.onlineAbDefinition()) && Objects.equals(this.project(), other.project()) && Objects.equals(this.randomizationSalt(), other.randomizationSalt()) && Objects.equals(this.samplingRate(), other.samplingRate()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.segment(), other.segment()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasTreatments() == other.hasTreatments() && Objects.equals(this.treatments(), other.treatments()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Experiment").add("Arn", (Object)this.arn()).add("CreatedTime", (Object)this.createdTime()).add("Description", (Object)this.description()).add("Execution", (Object)this.execution()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("MetricGoals", this.hasMetricGoals() ? this.metricGoals() : null).add("Name", (Object)this.name()).add("OnlineAbDefinition", (Object)this.onlineAbDefinition()).add("Project", (Object)this.project()).add("RandomizationSalt", (Object)this.randomizationSalt()).add("SamplingRate", (Object)this.samplingRate()).add("Schedule", (Object)this.schedule()).add("Segment", (Object)this.segment()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("Tags", this.hasTags() ? this.tags() : null).add("Treatments", this.hasTreatments() ? this.treatments() : null).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "execution": {
                return Optional.ofNullable(clazz.cast(this.execution()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "metricGoals": {
                return Optional.ofNullable(clazz.cast(this.metricGoals()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "onlineAbDefinition": {
                return Optional.ofNullable(clazz.cast(this.onlineAbDefinition()));
            }
            case "project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
            case "randomizationSalt": {
                return Optional.ofNullable(clazz.cast(this.randomizationSalt()));
            }
            case "samplingRate": {
                return Optional.ofNullable(clazz.cast(this.samplingRate()));
            }
            case "schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "segment": {
                return Optional.ofNullable(clazz.cast(this.segment()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "treatments": {
                return Optional.ofNullable(clazz.cast(this.treatments()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("createdTime", CREATED_TIME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("execution", EXECUTION_FIELD);
        map.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("metricGoals", METRIC_GOALS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("onlineAbDefinition", ONLINE_AB_DEFINITION_FIELD);
        map.put("project", PROJECT_FIELD);
        map.put("randomizationSalt", RANDOMIZATION_SALT_FIELD);
        map.put("samplingRate", SAMPLING_RATE_FIELD);
        map.put("schedule", SCHEDULE_FIELD);
        map.put("segment", SEGMENT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("treatments", TREATMENTS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Experiment, T> g) {
        return obj -> g.apply((Experiment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant createdTime;
        private String description;
        private ExperimentExecution execution;
        private Instant lastUpdatedTime;
        private List<MetricGoal> metricGoals = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private OnlineAbDefinition onlineAbDefinition;
        private String project;
        private String randomizationSalt;
        private Long samplingRate;
        private ExperimentSchedule schedule;
        private String segment;
        private String status;
        private String statusReason;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<Treatment> treatments = DefaultSdkAutoConstructList.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Experiment model) {
            this.arn(model.arn);
            this.createdTime(model.createdTime);
            this.description(model.description);
            this.execution(model.execution);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.metricGoals(model.metricGoals);
            this.name(model.name);
            this.onlineAbDefinition(model.onlineAbDefinition);
            this.project(model.project);
            this.randomizationSalt(model.randomizationSalt);
            this.samplingRate(model.samplingRate);
            this.schedule(model.schedule);
            this.segment(model.segment);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.tags(model.tags);
            this.treatments(model.treatments);
            this.type(model.type);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ExperimentExecution.Builder getExecution() {
            return this.execution != null ? this.execution.toBuilder() : null;
        }

        public final void setExecution(ExperimentExecution.BuilderImpl execution) {
            this.execution = execution != null ? execution.build() : null;
        }

        @Override
        public final Builder execution(ExperimentExecution execution) {
            this.execution = execution;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final List<MetricGoal.Builder> getMetricGoals() {
            List<MetricGoal.Builder> result = MetricGoalsListCopier.copyToBuilder(this.metricGoals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricGoals(Collection<MetricGoal.BuilderImpl> metricGoals) {
            this.metricGoals = MetricGoalsListCopier.copyFromBuilder(metricGoals);
        }

        @Override
        public final Builder metricGoals(Collection<MetricGoal> metricGoals) {
            this.metricGoals = MetricGoalsListCopier.copy(metricGoals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricGoals(MetricGoal ... metricGoals) {
            this.metricGoals(Arrays.asList(metricGoals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricGoals(Consumer<MetricGoal.Builder> ... metricGoals) {
            this.metricGoals(Stream.of(metricGoals).map(c -> (MetricGoal)((MetricGoal.Builder)MetricGoal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final OnlineAbDefinition.Builder getOnlineAbDefinition() {
            return this.onlineAbDefinition != null ? this.onlineAbDefinition.toBuilder() : null;
        }

        public final void setOnlineAbDefinition(OnlineAbDefinition.BuilderImpl onlineAbDefinition) {
            this.onlineAbDefinition = onlineAbDefinition != null ? onlineAbDefinition.build() : null;
        }

        @Override
        public final Builder onlineAbDefinition(OnlineAbDefinition onlineAbDefinition) {
            this.onlineAbDefinition = onlineAbDefinition;
            return this;
        }

        public final String getProject() {
            return this.project;
        }

        public final void setProject(String project) {
            this.project = project;
        }

        @Override
        public final Builder project(String project) {
            this.project = project;
            return this;
        }

        public final String getRandomizationSalt() {
            return this.randomizationSalt;
        }

        public final void setRandomizationSalt(String randomizationSalt) {
            this.randomizationSalt = randomizationSalt;
        }

        @Override
        public final Builder randomizationSalt(String randomizationSalt) {
            this.randomizationSalt = randomizationSalt;
            return this;
        }

        public final Long getSamplingRate() {
            return this.samplingRate;
        }

        public final void setSamplingRate(Long samplingRate) {
            this.samplingRate = samplingRate;
        }

        @Override
        public final Builder samplingRate(Long samplingRate) {
            this.samplingRate = samplingRate;
            return this;
        }

        public final ExperimentSchedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(ExperimentSchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(ExperimentSchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getSegment() {
            return this.segment;
        }

        public final void setSegment(String segment) {
            this.segment = segment;
        }

        @Override
        public final Builder segment(String segment) {
            this.segment = segment;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExperimentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final List<Treatment.Builder> getTreatments() {
            List<Treatment.Builder> result = TreatmentListCopier.copyToBuilder(this.treatments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTreatments(Collection<Treatment.BuilderImpl> treatments) {
            this.treatments = TreatmentListCopier.copyFromBuilder(treatments);
        }

        @Override
        public final Builder treatments(Collection<Treatment> treatments) {
            this.treatments = TreatmentListCopier.copy(treatments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder treatments(Treatment ... treatments) {
            this.treatments(Arrays.asList(treatments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder treatments(Consumer<Treatment.Builder> ... treatments) {
            this.treatments(Stream.of(treatments).map(c -> (Treatment)((Treatment.Builder)Treatment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ExperimentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public Experiment build() {
            return new Experiment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Experiment> {
        public Builder arn(String var1);

        public Builder createdTime(Instant var1);

        public Builder description(String var1);

        public Builder execution(ExperimentExecution var1);

        default public Builder execution(Consumer<ExperimentExecution.Builder> execution) {
            return this.execution((ExperimentExecution)((ExperimentExecution.Builder)ExperimentExecution.builder().applyMutation(execution)).build());
        }

        public Builder lastUpdatedTime(Instant var1);

        public Builder metricGoals(Collection<MetricGoal> var1);

        public Builder metricGoals(MetricGoal ... var1);

        public Builder metricGoals(Consumer<MetricGoal.Builder> ... var1);

        public Builder name(String var1);

        public Builder onlineAbDefinition(OnlineAbDefinition var1);

        default public Builder onlineAbDefinition(Consumer<OnlineAbDefinition.Builder> onlineAbDefinition) {
            return this.onlineAbDefinition((OnlineAbDefinition)((OnlineAbDefinition.Builder)OnlineAbDefinition.builder().applyMutation(onlineAbDefinition)).build());
        }

        public Builder project(String var1);

        public Builder randomizationSalt(String var1);

        public Builder samplingRate(Long var1);

        public Builder schedule(ExperimentSchedule var1);

        default public Builder schedule(Consumer<ExperimentSchedule.Builder> schedule) {
            return this.schedule((ExperimentSchedule)((ExperimentSchedule.Builder)ExperimentSchedule.builder().applyMutation(schedule)).build());
        }

        public Builder segment(String var1);

        public Builder status(String var1);

        public Builder status(ExperimentStatus var1);

        public Builder statusReason(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder treatments(Collection<Treatment> var1);

        public Builder treatments(Treatment ... var1);

        public Builder treatments(Consumer<Treatment.Builder> ... var1);

        public Builder type(String var1);

        public Builder type(ExperimentType var1);
    }
}

