/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.evidently.EvidentlyClient;
import software.amazon.awssdk.services.evidently.internal.UserAgentUtils;
import software.amazon.awssdk.services.evidently.model.FeatureSummary;
import software.amazon.awssdk.services.evidently.model.ListFeaturesRequest;
import software.amazon.awssdk.services.evidently.model.ListFeaturesResponse;

public class ListFeaturesIterable
implements SdkIterable<ListFeaturesResponse> {
    private final EvidentlyClient client;
    private final ListFeaturesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFeaturesIterable(EvidentlyClient client, ListFeaturesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFeaturesResponseFetcher();
    }

    public Iterator<ListFeaturesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FeatureSummary> features() {
        Function<ListFeaturesResponse, Iterator> getIterator = response -> {
            if (response != null && response.features() != null) {
                return response.features().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFeaturesResponseFetcher
    implements SyncPageFetcher<ListFeaturesResponse> {
        private ListFeaturesResponseFetcher() {
        }

        public boolean hasNextPage(ListFeaturesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFeaturesResponse nextPage(ListFeaturesResponse previousPage) {
            if (previousPage == null) {
                return ListFeaturesIterable.this.client.listFeatures(ListFeaturesIterable.this.firstRequest);
            }
            return ListFeaturesIterable.this.client.listFeatures((ListFeaturesRequest)((Object)ListFeaturesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

