/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.evidently.model.EvidentlyResponse;
import software.amazon.awssdk.services.evidently.model.Experiment;
import software.amazon.awssdk.services.evidently.model.ExperimentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListExperimentsResponse
extends EvidentlyResponse
implements ToCopyableBuilder<Builder, ListExperimentsResponse> {
    private static final SdkField<List<Experiment>> EXPERIMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("experiments").getter(ListExperimentsResponse.getter(ListExperimentsResponse::experiments)).setter(ListExperimentsResponse.setter(Builder::experiments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experiments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Experiment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListExperimentsResponse.getter(ListExperimentsResponse::nextToken)).setter(ListExperimentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPERIMENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Experiment> experiments;
    private final String nextToken;

    private ListExperimentsResponse(BuilderImpl builder) {
        super(builder);
        this.experiments = builder.experiments;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasExperiments() {
        return this.experiments != null && !(this.experiments instanceof SdkAutoConstructList);
    }

    public final List<Experiment> experiments() {
        return this.experiments;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExperiments() ? this.experiments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExperimentsResponse)) {
            return false;
        }
        ListExperimentsResponse other = (ListExperimentsResponse)((Object)obj);
        return this.hasExperiments() == other.hasExperiments() && Objects.equals(this.experiments(), other.experiments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListExperimentsResponse").add("Experiments", this.hasExperiments() ? this.experiments() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "experiments": {
                return Optional.ofNullable(clazz.cast(this.experiments()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListExperimentsResponse, T> g) {
        return obj -> g.apply((ListExperimentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EvidentlyResponse.BuilderImpl
    implements Builder {
        private List<Experiment> experiments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExperimentsResponse model) {
            super(model);
            this.experiments(model.experiments);
            this.nextToken(model.nextToken);
        }

        public final List<Experiment.Builder> getExperiments() {
            List<Experiment.Builder> result = ExperimentListCopier.copyToBuilder(this.experiments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExperiments(Collection<Experiment.BuilderImpl> experiments) {
            this.experiments = ExperimentListCopier.copyFromBuilder(experiments);
        }

        @Override
        public final Builder experiments(Collection<Experiment> experiments) {
            this.experiments = ExperimentListCopier.copy(experiments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder experiments(Experiment ... experiments) {
            this.experiments(Arrays.asList(experiments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder experiments(Consumer<Experiment.Builder> ... experiments) {
            this.experiments(Stream.of(experiments).map(c -> (Experiment)((Experiment.Builder)Experiment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListExperimentsResponse build() {
            return new ListExperimentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EvidentlyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListExperimentsResponse> {
        public Builder experiments(Collection<Experiment> var1);

        public Builder experiments(Experiment ... var1);

        public Builder experiments(Consumer<Experiment.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

