/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.evidently.DefaultEvidentlyBaseClientBuilder;
import software.amazon.awssdk.services.evidently.DefaultEvidentlyClient;
import software.amazon.awssdk.services.evidently.EvidentlyClient;
import software.amazon.awssdk.services.evidently.EvidentlyClientBuilder;
import software.amazon.awssdk.services.evidently.EvidentlyServiceClientConfiguration;
import software.amazon.awssdk.services.evidently.endpoints.EvidentlyEndpointProvider;

@SdkInternalApi
final class DefaultEvidentlyClientBuilder
extends DefaultEvidentlyBaseClientBuilder<EvidentlyClientBuilder, EvidentlyClient>
implements EvidentlyClientBuilder {
    DefaultEvidentlyClientBuilder() {
    }

    @Override
    public DefaultEvidentlyClientBuilder endpointProvider(EvidentlyEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final EvidentlyClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultEvidentlyClientBuilder.validateClientOptions(clientConfiguration);
        EvidentlyServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultEvidentlyClient client = new DefaultEvidentlyClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private EvidentlyServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return EvidentlyServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

