/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.evidently.model.EvidentlyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluateFeatureRequest
extends EvidentlyRequest
implements ToCopyableBuilder<Builder, EvaluateFeatureRequest> {
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityId").getter(EvaluateFeatureRequest.getter(EvaluateFeatureRequest::entityId)).setter(EvaluateFeatureRequest.setter(Builder::entityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()}).build();
    private static final SdkField<String> EVALUATION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evaluationContext").getter(EvaluateFeatureRequest.getter(EvaluateFeatureRequest::evaluationContext)).setter(EvaluateFeatureRequest.setter(Builder::evaluationContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationContext").build(), JsonValueTrait.create()}).build();
    private static final SdkField<String> FEATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("feature").getter(EvaluateFeatureRequest.getter(EvaluateFeatureRequest::feature)).setter(EvaluateFeatureRequest.setter(Builder::feature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("feature").build()}).build();
    private static final SdkField<String> PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("project").getter(EvaluateFeatureRequest.getter(EvaluateFeatureRequest::project)).setter(EvaluateFeatureRequest.setter(Builder::project)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("project").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_FIELD, EVALUATION_CONTEXT_FIELD, FEATURE_FIELD, PROJECT_FIELD));
    private final String entityId;
    private final String evaluationContext;
    private final String feature;
    private final String project;

    private EvaluateFeatureRequest(BuilderImpl builder) {
        super(builder);
        this.entityId = builder.entityId;
        this.evaluationContext = builder.evaluationContext;
        this.feature = builder.feature;
        this.project = builder.project;
    }

    public final String entityId() {
        return this.entityId;
    }

    public final String evaluationContext() {
        return this.evaluationContext;
    }

    public final String feature() {
        return this.feature;
    }

    public final String project() {
        return this.project;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.feature());
        hashCode = 31 * hashCode + Objects.hashCode(this.project());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateFeatureRequest)) {
            return false;
        }
        EvaluateFeatureRequest other = (EvaluateFeatureRequest)((Object)obj);
        return Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.evaluationContext(), other.evaluationContext()) && Objects.equals(this.feature(), other.feature()) && Objects.equals(this.project(), other.project());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluateFeatureRequest").add("EntityId", (Object)this.entityId()).add("EvaluationContext", (Object)this.evaluationContext()).add("Feature", (Object)this.feature()).add("Project", (Object)this.project()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "evaluationContext": {
                return Optional.ofNullable(clazz.cast(this.evaluationContext()));
            }
            case "feature": {
                return Optional.ofNullable(clazz.cast(this.feature()));
            }
            case "project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluateFeatureRequest, T> g) {
        return obj -> g.apply((EvaluateFeatureRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EvidentlyRequest.BuilderImpl
    implements Builder {
        private String entityId;
        private String evaluationContext;
        private String feature;
        private String project;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateFeatureRequest model) {
            super(model);
            this.entityId(model.entityId);
            this.evaluationContext(model.evaluationContext);
            this.feature(model.feature);
            this.project(model.project);
        }

        public final String getEntityId() {
            return this.entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEvaluationContext() {
            return this.evaluationContext;
        }

        public final void setEvaluationContext(String evaluationContext) {
            this.evaluationContext = evaluationContext;
        }

        @Override
        public final Builder evaluationContext(String evaluationContext) {
            this.evaluationContext = evaluationContext;
            return this;
        }

        public final String getFeature() {
            return this.feature;
        }

        public final void setFeature(String feature) {
            this.feature = feature;
        }

        @Override
        public final Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        public final String getProject() {
            return this.project;
        }

        public final void setProject(String project) {
            this.project = project;
        }

        @Override
        public final Builder project(String project) {
            this.project = project;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EvaluateFeatureRequest build() {
            return new EvaluateFeatureRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EvidentlyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EvaluateFeatureRequest> {
        public Builder entityId(String var1);

        public Builder evaluationContext(String var1);

        public Builder feature(String var1);

        public Builder project(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

