/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.evidently.EvidentlyClient;
import software.amazon.awssdk.services.evidently.model.AccessDeniedException;
import software.amazon.awssdk.services.evidently.model.BatchEvaluateFeatureRequest;
import software.amazon.awssdk.services.evidently.model.BatchEvaluateFeatureResponse;
import software.amazon.awssdk.services.evidently.model.ConflictException;
import software.amazon.awssdk.services.evidently.model.CreateExperimentRequest;
import software.amazon.awssdk.services.evidently.model.CreateExperimentResponse;
import software.amazon.awssdk.services.evidently.model.CreateFeatureRequest;
import software.amazon.awssdk.services.evidently.model.CreateFeatureResponse;
import software.amazon.awssdk.services.evidently.model.CreateLaunchRequest;
import software.amazon.awssdk.services.evidently.model.CreateLaunchResponse;
import software.amazon.awssdk.services.evidently.model.CreateProjectRequest;
import software.amazon.awssdk.services.evidently.model.CreateProjectResponse;
import software.amazon.awssdk.services.evidently.model.CreateSegmentRequest;
import software.amazon.awssdk.services.evidently.model.CreateSegmentResponse;
import software.amazon.awssdk.services.evidently.model.DeleteExperimentRequest;
import software.amazon.awssdk.services.evidently.model.DeleteExperimentResponse;
import software.amazon.awssdk.services.evidently.model.DeleteFeatureRequest;
import software.amazon.awssdk.services.evidently.model.DeleteFeatureResponse;
import software.amazon.awssdk.services.evidently.model.DeleteLaunchRequest;
import software.amazon.awssdk.services.evidently.model.DeleteLaunchResponse;
import software.amazon.awssdk.services.evidently.model.DeleteProjectRequest;
import software.amazon.awssdk.services.evidently.model.DeleteProjectResponse;
import software.amazon.awssdk.services.evidently.model.DeleteSegmentRequest;
import software.amazon.awssdk.services.evidently.model.DeleteSegmentResponse;
import software.amazon.awssdk.services.evidently.model.EvaluateFeatureRequest;
import software.amazon.awssdk.services.evidently.model.EvaluateFeatureResponse;
import software.amazon.awssdk.services.evidently.model.EvidentlyException;
import software.amazon.awssdk.services.evidently.model.EvidentlyRequest;
import software.amazon.awssdk.services.evidently.model.GetExperimentRequest;
import software.amazon.awssdk.services.evidently.model.GetExperimentResponse;
import software.amazon.awssdk.services.evidently.model.GetExperimentResultsRequest;
import software.amazon.awssdk.services.evidently.model.GetExperimentResultsResponse;
import software.amazon.awssdk.services.evidently.model.GetFeatureRequest;
import software.amazon.awssdk.services.evidently.model.GetFeatureResponse;
import software.amazon.awssdk.services.evidently.model.GetLaunchRequest;
import software.amazon.awssdk.services.evidently.model.GetLaunchResponse;
import software.amazon.awssdk.services.evidently.model.GetProjectRequest;
import software.amazon.awssdk.services.evidently.model.GetProjectResponse;
import software.amazon.awssdk.services.evidently.model.GetSegmentRequest;
import software.amazon.awssdk.services.evidently.model.GetSegmentResponse;
import software.amazon.awssdk.services.evidently.model.InternalServerException;
import software.amazon.awssdk.services.evidently.model.ListExperimentsRequest;
import software.amazon.awssdk.services.evidently.model.ListExperimentsResponse;
import software.amazon.awssdk.services.evidently.model.ListFeaturesRequest;
import software.amazon.awssdk.services.evidently.model.ListFeaturesResponse;
import software.amazon.awssdk.services.evidently.model.ListLaunchesRequest;
import software.amazon.awssdk.services.evidently.model.ListLaunchesResponse;
import software.amazon.awssdk.services.evidently.model.ListProjectsRequest;
import software.amazon.awssdk.services.evidently.model.ListProjectsResponse;
import software.amazon.awssdk.services.evidently.model.ListSegmentReferencesRequest;
import software.amazon.awssdk.services.evidently.model.ListSegmentReferencesResponse;
import software.amazon.awssdk.services.evidently.model.ListSegmentsRequest;
import software.amazon.awssdk.services.evidently.model.ListSegmentsResponse;
import software.amazon.awssdk.services.evidently.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.evidently.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.evidently.model.PutProjectEventsRequest;
import software.amazon.awssdk.services.evidently.model.PutProjectEventsResponse;
import software.amazon.awssdk.services.evidently.model.ResourceNotFoundException;
import software.amazon.awssdk.services.evidently.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.evidently.model.ServiceUnavailableException;
import software.amazon.awssdk.services.evidently.model.StartExperimentRequest;
import software.amazon.awssdk.services.evidently.model.StartExperimentResponse;
import software.amazon.awssdk.services.evidently.model.StartLaunchRequest;
import software.amazon.awssdk.services.evidently.model.StartLaunchResponse;
import software.amazon.awssdk.services.evidently.model.StopExperimentRequest;
import software.amazon.awssdk.services.evidently.model.StopExperimentResponse;
import software.amazon.awssdk.services.evidently.model.StopLaunchRequest;
import software.amazon.awssdk.services.evidently.model.StopLaunchResponse;
import software.amazon.awssdk.services.evidently.model.TagResourceRequest;
import software.amazon.awssdk.services.evidently.model.TagResourceResponse;
import software.amazon.awssdk.services.evidently.model.TestSegmentPatternRequest;
import software.amazon.awssdk.services.evidently.model.TestSegmentPatternResponse;
import software.amazon.awssdk.services.evidently.model.ThrottlingException;
import software.amazon.awssdk.services.evidently.model.UntagResourceRequest;
import software.amazon.awssdk.services.evidently.model.UntagResourceResponse;
import software.amazon.awssdk.services.evidently.model.UpdateExperimentRequest;
import software.amazon.awssdk.services.evidently.model.UpdateExperimentResponse;
import software.amazon.awssdk.services.evidently.model.UpdateFeatureRequest;
import software.amazon.awssdk.services.evidently.model.UpdateFeatureResponse;
import software.amazon.awssdk.services.evidently.model.UpdateLaunchRequest;
import software.amazon.awssdk.services.evidently.model.UpdateLaunchResponse;
import software.amazon.awssdk.services.evidently.model.UpdateProjectDataDeliveryRequest;
import software.amazon.awssdk.services.evidently.model.UpdateProjectDataDeliveryResponse;
import software.amazon.awssdk.services.evidently.model.UpdateProjectRequest;
import software.amazon.awssdk.services.evidently.model.UpdateProjectResponse;
import software.amazon.awssdk.services.evidently.model.ValidationException;
import software.amazon.awssdk.services.evidently.paginators.ListExperimentsIterable;
import software.amazon.awssdk.services.evidently.paginators.ListFeaturesIterable;
import software.amazon.awssdk.services.evidently.paginators.ListLaunchesIterable;
import software.amazon.awssdk.services.evidently.paginators.ListProjectsIterable;
import software.amazon.awssdk.services.evidently.paginators.ListSegmentReferencesIterable;
import software.amazon.awssdk.services.evidently.paginators.ListSegmentsIterable;
import software.amazon.awssdk.services.evidently.transform.BatchEvaluateFeatureRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.CreateExperimentRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.CreateFeatureRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.CreateLaunchRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.CreateProjectRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.CreateSegmentRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.DeleteExperimentRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.DeleteFeatureRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.DeleteLaunchRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.DeleteProjectRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.DeleteSegmentRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.EvaluateFeatureRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.GetExperimentRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.GetExperimentResultsRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.GetFeatureRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.GetLaunchRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.GetProjectRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.GetSegmentRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.ListExperimentsRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.ListFeaturesRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.ListLaunchesRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.ListProjectsRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.ListSegmentReferencesRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.ListSegmentsRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.PutProjectEventsRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.StartExperimentRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.StartLaunchRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.StopExperimentRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.StopLaunchRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.TestSegmentPatternRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.UpdateExperimentRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.UpdateFeatureRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.UpdateLaunchRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.UpdateProjectDataDeliveryRequestMarshaller;
import software.amazon.awssdk.services.evidently.transform.UpdateProjectRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultEvidentlyClient
implements EvidentlyClient {
    private static final Logger log = Logger.loggerFor(DefaultEvidentlyClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultEvidentlyClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "evidently";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchEvaluateFeatureResponse batchEvaluateFeature(BatchEvaluateFeatureRequest batchEvaluateFeatureRequest) throws ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchEvaluateFeatureResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, batchEvaluateFeatureRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchEvaluateFeature");
            String hostPrefix = "dataplane.";
            String resolvedHostExpression = "dataplane.";
            BatchEvaluateFeatureResponse batchEvaluateFeatureResponse = (BatchEvaluateFeatureResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchEvaluateFeature").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)batchEvaluateFeatureRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchEvaluateFeatureRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchEvaluateFeatureResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$batchEvaluateFeature$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateExperimentResponse createExperiment(CreateExperimentRequest createExperimentRequest) throws ValidationException, ConflictException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateExperimentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, createExperimentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateExperiment");
            CreateExperimentResponse createExperimentResponse = (CreateExperimentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateExperiment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createExperimentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateExperimentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createExperimentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$createExperiment$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFeatureResponse createFeature(CreateFeatureRequest createFeatureRequest) throws ValidationException, ConflictException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFeatureResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, createFeatureRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFeature");
            CreateFeatureResponse createFeatureResponse = (CreateFeatureResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFeature").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFeatureRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateFeatureRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFeatureResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$createFeature$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLaunchResponse createLaunch(CreateLaunchRequest createLaunchRequest) throws ValidationException, ConflictException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLaunchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, createLaunchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLaunch");
            CreateLaunchResponse createLaunchResponse = (CreateLaunchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLaunch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLaunchRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateLaunchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createLaunchResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$createLaunch$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateProjectResponse createProject(CreateProjectRequest createProjectRequest) throws ValidationException, ConflictException, ServiceQuotaExceededException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateProjectResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, createProjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateProject");
            CreateProjectResponse createProjectResponse = (CreateProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateProject").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createProjectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createProjectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$createProject$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSegmentResponse createSegment(CreateSegmentRequest createSegmentRequest) throws ValidationException, ConflictException, ServiceQuotaExceededException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSegmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, createSegmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSegment");
            CreateSegmentResponse createSegmentResponse = (CreateSegmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSegment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSegmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSegmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSegmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$createSegment$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteExperimentResponse deleteExperiment(DeleteExperimentRequest deleteExperimentRequest) throws ValidationException, InternalServerException, ConflictException, ServiceUnavailableException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteExperimentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, deleteExperimentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteExperiment");
            DeleteExperimentResponse deleteExperimentResponse = (DeleteExperimentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteExperiment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteExperimentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteExperimentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteExperimentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$deleteExperiment$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFeatureResponse deleteFeature(DeleteFeatureRequest deleteFeatureRequest) throws ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFeatureResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, deleteFeatureRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFeature");
            DeleteFeatureResponse deleteFeatureResponse = (DeleteFeatureResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFeature").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFeatureRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFeatureRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFeatureResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$deleteFeature$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLaunchResponse deleteLaunch(DeleteLaunchRequest deleteLaunchRequest) throws ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLaunchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, deleteLaunchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLaunch");
            DeleteLaunchResponse deleteLaunchResponse = (DeleteLaunchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLaunch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLaunchRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLaunchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteLaunchResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$deleteLaunch$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteProjectResponse deleteProject(DeleteProjectRequest deleteProjectRequest) throws ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteProjectResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, deleteProjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteProject");
            DeleteProjectResponse deleteProjectResponse = (DeleteProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteProject").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteProjectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteProjectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$deleteProject$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSegmentResponse deleteSegment(DeleteSegmentRequest deleteSegmentRequest) throws ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSegmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, deleteSegmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSegment");
            DeleteSegmentResponse deleteSegmentResponse = (DeleteSegmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSegment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSegmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSegmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSegmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$deleteSegment$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EvaluateFeatureResponse evaluateFeature(EvaluateFeatureRequest evaluateFeatureRequest) throws ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EvaluateFeatureResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, evaluateFeatureRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EvaluateFeature");
            String hostPrefix = "dataplane.";
            String resolvedHostExpression = "dataplane.";
            EvaluateFeatureResponse evaluateFeatureResponse = (EvaluateFeatureResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EvaluateFeature").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)evaluateFeatureRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EvaluateFeatureRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return evaluateFeatureResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$evaluateFeature$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetExperimentResponse getExperiment(GetExperimentRequest getExperimentRequest) throws ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetExperimentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, getExperimentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetExperiment");
            GetExperimentResponse getExperimentResponse = (GetExperimentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetExperiment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getExperimentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetExperimentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getExperimentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$getExperiment$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetExperimentResultsResponse getExperimentResults(GetExperimentResultsRequest getExperimentResultsRequest) throws ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetExperimentResultsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, getExperimentResultsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetExperimentResults");
            GetExperimentResultsResponse getExperimentResultsResponse = (GetExperimentResultsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetExperimentResults").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getExperimentResultsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetExperimentResultsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getExperimentResultsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$getExperimentResults$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFeatureResponse getFeature(GetFeatureRequest getFeatureRequest) throws ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFeatureResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, getFeatureRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFeature");
            GetFeatureResponse getFeatureResponse = (GetFeatureResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFeature").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFeatureRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetFeatureRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getFeatureResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$getFeature$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLaunchResponse getLaunch(GetLaunchRequest getLaunchRequest) throws ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLaunchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, getLaunchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLaunch");
            GetLaunchResponse getLaunchResponse = (GetLaunchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLaunch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLaunchRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLaunchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLaunchResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$getLaunch$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetProjectResponse getProject(GetProjectRequest getProjectRequest) throws ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetProjectResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, getProjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetProject");
            GetProjectResponse getProjectResponse = (GetProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetProject").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getProjectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getProjectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$getProject$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSegmentResponse getSegment(GetSegmentRequest getSegmentRequest) throws ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSegmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, getSegmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSegment");
            GetSegmentResponse getSegmentResponse = (GetSegmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSegment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSegmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSegmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSegmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$getSegment$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListExperimentsResponse listExperiments(ListExperimentsRequest listExperimentsRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListExperimentsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, listExperimentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListExperiments");
            ListExperimentsResponse listExperimentsResponse = (ListExperimentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListExperiments").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listExperimentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListExperimentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listExperimentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$listExperiments$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListExperimentsIterable listExperimentsPaginator(ListExperimentsRequest listExperimentsRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        return new ListExperimentsIterable(this, this.applyPaginatorUserAgent(listExperimentsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFeaturesResponse listFeatures(ListFeaturesRequest listFeaturesRequest) throws ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFeaturesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, listFeaturesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFeatures");
            ListFeaturesResponse listFeaturesResponse = (ListFeaturesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFeatures").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFeaturesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListFeaturesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFeaturesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$listFeatures$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListFeaturesIterable listFeaturesPaginator(ListFeaturesRequest listFeaturesRequest) throws ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        return new ListFeaturesIterable(this, this.applyPaginatorUserAgent(listFeaturesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLaunchesResponse listLaunches(ListLaunchesRequest listLaunchesRequest) throws ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLaunchesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, listLaunchesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLaunches");
            ListLaunchesResponse listLaunchesResponse = (ListLaunchesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLaunches").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listLaunchesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListLaunchesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listLaunchesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$listLaunches$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListLaunchesIterable listLaunchesPaginator(ListLaunchesRequest listLaunchesRequest) throws ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        return new ListLaunchesIterable(this, this.applyPaginatorUserAgent(listLaunchesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListProjectsResponse listProjects(ListProjectsRequest listProjectsRequest) throws ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListProjectsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, listProjectsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListProjects");
            ListProjectsResponse listProjectsResponse = (ListProjectsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListProjects").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listProjectsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListProjectsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listProjectsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$listProjects$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListProjectsIterable listProjectsPaginator(ListProjectsRequest listProjectsRequest) throws ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        return new ListProjectsIterable(this, this.applyPaginatorUserAgent(listProjectsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSegmentReferencesResponse listSegmentReferences(ListSegmentReferencesRequest listSegmentReferencesRequest) throws ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSegmentReferencesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, listSegmentReferencesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSegmentReferences");
            ListSegmentReferencesResponse listSegmentReferencesResponse = (ListSegmentReferencesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSegmentReferences").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSegmentReferencesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSegmentReferencesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSegmentReferencesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$listSegmentReferences$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSegmentReferencesIterable listSegmentReferencesPaginator(ListSegmentReferencesRequest listSegmentReferencesRequest) throws ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        return new ListSegmentReferencesIterable(this, this.applyPaginatorUserAgent(listSegmentReferencesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSegmentsResponse listSegments(ListSegmentsRequest listSegmentsRequest) throws ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSegmentsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, listSegmentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSegments");
            ListSegmentsResponse listSegmentsResponse = (ListSegmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSegments").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSegmentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSegmentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSegmentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$listSegments$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSegmentsIterable listSegmentsPaginator(ListSegmentsRequest listSegmentsRequest) throws ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        return new ListSegmentsIterable(this, this.applyPaginatorUserAgent(listSegmentsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$listTagsForResource$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutProjectEventsResponse putProjectEvents(PutProjectEventsRequest putProjectEventsRequest) throws ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutProjectEventsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, putProjectEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutProjectEvents");
            String hostPrefix = "dataplane.";
            String resolvedHostExpression = "dataplane.";
            PutProjectEventsResponse putProjectEventsResponse = (PutProjectEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutProjectEvents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)putProjectEventsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutProjectEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putProjectEventsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$putProjectEvents$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartExperimentResponse startExperiment(StartExperimentRequest startExperimentRequest) throws ThrottlingException, ValidationException, ConflictException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartExperimentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, startExperimentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartExperiment");
            StartExperimentResponse startExperimentResponse = (StartExperimentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartExperiment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startExperimentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartExperimentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startExperimentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$startExperiment$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartLaunchResponse startLaunch(StartLaunchRequest startLaunchRequest) throws ThrottlingException, ValidationException, ConflictException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartLaunchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, startLaunchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartLaunch");
            StartLaunchResponse startLaunchResponse = (StartLaunchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartLaunch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startLaunchRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartLaunchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startLaunchResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$startLaunch$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopExperimentResponse stopExperiment(StopExperimentRequest stopExperimentRequest) throws ThrottlingException, ValidationException, ConflictException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopExperimentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, stopExperimentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopExperiment");
            StopExperimentResponse stopExperimentResponse = (StopExperimentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopExperiment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopExperimentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopExperimentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopExperimentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$stopExperiment$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopLaunchResponse stopLaunch(StopLaunchRequest stopLaunchRequest) throws ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopLaunchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, stopLaunchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopLaunch");
            StopLaunchResponse stopLaunchResponse = (StopLaunchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopLaunch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopLaunchRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopLaunchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopLaunchResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$stopLaunch$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$tagResource$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestSegmentPatternResponse testSegmentPattern(TestSegmentPatternRequest testSegmentPatternRequest) throws ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TestSegmentPatternResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, testSegmentPatternRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TestSegmentPattern");
            TestSegmentPatternResponse testSegmentPatternResponse = (TestSegmentPatternResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestSegmentPattern").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)testSegmentPatternRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TestSegmentPatternRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return testSegmentPatternResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$testSegmentPattern$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$untagResource$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateExperimentResponse updateExperiment(UpdateExperimentRequest updateExperimentRequest) throws ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateExperimentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, updateExperimentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateExperiment");
            UpdateExperimentResponse updateExperimentResponse = (UpdateExperimentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateExperiment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateExperimentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateExperimentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateExperimentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$updateExperiment$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFeatureResponse updateFeature(UpdateFeatureRequest updateFeatureRequest) throws ValidationException, ConflictException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFeatureResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, updateFeatureRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFeature");
            UpdateFeatureResponse updateFeatureResponse = (UpdateFeatureResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFeature").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFeatureRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFeatureRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFeatureResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$updateFeature$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateLaunchResponse updateLaunch(UpdateLaunchRequest updateLaunchRequest) throws ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLaunchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, updateLaunchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLaunch");
            UpdateLaunchResponse updateLaunchResponse = (UpdateLaunchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLaunch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateLaunchRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateLaunchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateLaunchResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$updateLaunch$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateProjectResponse updateProject(UpdateProjectRequest updateProjectRequest) throws ValidationException, ConflictException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateProjectResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, updateProjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateProject");
            UpdateProjectResponse updateProjectResponse = (UpdateProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateProject").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateProjectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateProjectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$updateProject$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateProjectDataDeliveryResponse updateProjectDataDelivery(UpdateProjectDataDeliveryRequest updateProjectDataDeliveryRequest) throws ValidationException, ConflictException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateProjectDataDeliveryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEvidentlyClient.resolveMetricPublishers(this.clientConfiguration, updateProjectDataDeliveryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Evidently");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateProjectDataDelivery");
            UpdateProjectDataDeliveryResponse updateProjectDataDeliveryResponse = (UpdateProjectDataDeliveryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateProjectDataDelivery").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateProjectDataDeliveryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateProjectDataDeliveryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateProjectDataDeliveryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEvidentlyClient.lambda$updateProjectDataDelivery$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(EvidentlyException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(Integer.valueOf(503)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends EvidentlyRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.18.36").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((EvidentlyRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateProjectDataDelivery$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateProject$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLaunch$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFeature$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateExperiment$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$testSegmentPattern$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopLaunch$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopExperiment$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startLaunch$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startExperiment$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putProjectEvents$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSegments$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSegmentReferences$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listProjects$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLaunches$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFeatures$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listExperiments$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSegment$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getProject$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLaunch$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFeature$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getExperimentResults$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getExperiment$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$evaluateFeature$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSegment$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteProject$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLaunch$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFeature$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteExperiment$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSegment$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createProject$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLaunch$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFeature$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createExperiment$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchEvaluateFeature$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

