/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.evidently.model.EvaluationRequest;
import software.amazon.awssdk.services.evidently.model.EvaluationRequestsListCopier;
import software.amazon.awssdk.services.evidently.model.EvidentlyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchEvaluateFeatureRequest
extends EvidentlyRequest
implements ToCopyableBuilder<Builder, BatchEvaluateFeatureRequest> {
    private static final SdkField<String> PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("project").getter(BatchEvaluateFeatureRequest.getter(BatchEvaluateFeatureRequest::project)).setter(BatchEvaluateFeatureRequest.setter(Builder::project)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("project").build()}).build();
    private static final SdkField<List<EvaluationRequest>> REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("requests").getter(BatchEvaluateFeatureRequest.getter(BatchEvaluateFeatureRequest::requests)).setter(BatchEvaluateFeatureRequest.setter(Builder::requests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_FIELD, REQUESTS_FIELD));
    private final String project;
    private final List<EvaluationRequest> requests;

    private BatchEvaluateFeatureRequest(BuilderImpl builder) {
        super(builder);
        this.project = builder.project;
        this.requests = builder.requests;
    }

    public final String project() {
        return this.project;
    }

    public final boolean hasRequests() {
        return this.requests != null && !(this.requests instanceof SdkAutoConstructList);
    }

    public final List<EvaluationRequest> requests() {
        return this.requests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.project());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequests() ? this.requests() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchEvaluateFeatureRequest)) {
            return false;
        }
        BatchEvaluateFeatureRequest other = (BatchEvaluateFeatureRequest)((Object)obj);
        return Objects.equals(this.project(), other.project()) && this.hasRequests() == other.hasRequests() && Objects.equals(this.requests(), other.requests());
    }

    public final String toString() {
        return ToString.builder((String)"BatchEvaluateFeatureRequest").add("Project", (Object)this.project()).add("Requests", this.hasRequests() ? this.requests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
            case "requests": {
                return Optional.ofNullable(clazz.cast(this.requests()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchEvaluateFeatureRequest, T> g) {
        return obj -> g.apply((BatchEvaluateFeatureRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EvidentlyRequest.BuilderImpl
    implements Builder {
        private String project;
        private List<EvaluationRequest> requests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchEvaluateFeatureRequest model) {
            super(model);
            this.project(model.project);
            this.requests(model.requests);
        }

        public final String getProject() {
            return this.project;
        }

        public final void setProject(String project) {
            this.project = project;
        }

        @Override
        @Transient
        public final Builder project(String project) {
            this.project = project;
            return this;
        }

        public final List<EvaluationRequest.Builder> getRequests() {
            List<EvaluationRequest.Builder> result = EvaluationRequestsListCopier.copyToBuilder(this.requests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRequests(Collection<EvaluationRequest.BuilderImpl> requests) {
            this.requests = EvaluationRequestsListCopier.copyFromBuilder(requests);
        }

        @Override
        @Transient
        public final Builder requests(Collection<EvaluationRequest> requests) {
            this.requests = EvaluationRequestsListCopier.copy(requests);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder requests(EvaluationRequest ... requests) {
            this.requests(Arrays.asList(requests));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder requests(Consumer<EvaluationRequest.Builder> ... requests) {
            this.requests(Stream.of(requests).map(c -> (EvaluationRequest)((EvaluationRequest.Builder)EvaluationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchEvaluateFeatureRequest build() {
            return new BatchEvaluateFeatureRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EvidentlyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchEvaluateFeatureRequest> {
        public Builder project(String var1);

        public Builder requests(Collection<EvaluationRequest> var1);

        public Builder requests(EvaluationRequest ... var1);

        public Builder requests(Consumer<EvaluationRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

