/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.eventbridge.model.EventResourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutEventsRequestEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PutEventsRequestEntry> {
    private static final SdkField<Instant> TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(PutEventsRequestEntry.getter(PutEventsRequestEntry::time)).setter(PutEventsRequestEntry.setter(Builder::time)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Time").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutEventsRequestEntry.getter(PutEventsRequestEntry::source)).setter(PutEventsRequestEntry.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<List<String>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PutEventsRequestEntry.getter(PutEventsRequestEntry::resources)).setter(PutEventsRequestEntry.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DETAIL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutEventsRequestEntry.getter(PutEventsRequestEntry::detailType)).setter(PutEventsRequestEntry.setter(Builder::detailType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailType").build()}).build();
    private static final SdkField<String> DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutEventsRequestEntry.getter(PutEventsRequestEntry::detail)).setter(PutEventsRequestEntry.setter(Builder::detail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Detail").build()}).build();
    private static final SdkField<String> EVENT_BUS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutEventsRequestEntry.getter(PutEventsRequestEntry::eventBusName)).setter(PutEventsRequestEntry.setter(Builder::eventBusName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBusName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_FIELD, SOURCE_FIELD, RESOURCES_FIELD, DETAIL_TYPE_FIELD, DETAIL_FIELD, EVENT_BUS_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant time;
    private final String source;
    private final List<String> resources;
    private final String detailType;
    private final String detail;
    private final String eventBusName;

    private PutEventsRequestEntry(BuilderImpl builder) {
        this.time = builder.time;
        this.source = builder.source;
        this.resources = builder.resources;
        this.detailType = builder.detailType;
        this.detail = builder.detail;
        this.eventBusName = builder.eventBusName;
    }

    public Instant time() {
        return this.time;
    }

    public String source() {
        return this.source;
    }

    public List<String> resources() {
        return this.resources;
    }

    public String detailType() {
        return this.detailType;
    }

    public String detail() {
        return this.detail;
    }

    public String eventBusName() {
        return this.eventBusName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.time());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.resources());
        hashCode = 31 * hashCode + Objects.hashCode(this.detailType());
        hashCode = 31 * hashCode + Objects.hashCode(this.detail());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventBusName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventsRequestEntry)) {
            return false;
        }
        PutEventsRequestEntry other = (PutEventsRequestEntry)obj;
        return Objects.equals(this.time(), other.time()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.detailType(), other.detailType()) && Objects.equals(this.detail(), other.detail()) && Objects.equals(this.eventBusName(), other.eventBusName());
    }

    public String toString() {
        return ToString.builder((String)"PutEventsRequestEntry").add("Time", (Object)this.time()).add("Source", (Object)this.source()).add("Resources", this.resources()).add("DetailType", (Object)this.detailType()).add("Detail", (Object)this.detail()).add("EventBusName", (Object)this.eventBusName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Time": {
                return Optional.ofNullable(clazz.cast(this.time()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "DetailType": {
                return Optional.ofNullable(clazz.cast(this.detailType()));
            }
            case "Detail": {
                return Optional.ofNullable(clazz.cast(this.detail()));
            }
            case "EventBusName": {
                return Optional.ofNullable(clazz.cast(this.eventBusName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutEventsRequestEntry, T> g) {
        return obj -> g.apply((PutEventsRequestEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant time;
        private String source;
        private List<String> resources = DefaultSdkAutoConstructList.getInstance();
        private String detailType;
        private String detail;
        private String eventBusName;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEventsRequestEntry model) {
            this.time(model.time);
            this.source(model.source);
            this.resources(model.resources);
            this.detailType(model.detailType);
            this.detail(model.detail);
            this.eventBusName(model.eventBusName);
        }

        public final Instant getTime() {
            return this.time;
        }

        @Override
        public final Builder time(Instant time) {
            this.time = time;
            return this;
        }

        public final void setTime(Instant time) {
            this.time = time;
        }

        public final String getSource() {
            return this.source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final Collection<String> getResources() {
            return this.resources;
        }

        @Override
        public final Builder resources(Collection<String> resources) {
            this.resources = EventResourceListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(String ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        public final void setResources(Collection<String> resources) {
            this.resources = EventResourceListCopier.copy(resources);
        }

        public final String getDetailType() {
            return this.detailType;
        }

        @Override
        public final Builder detailType(String detailType) {
            this.detailType = detailType;
            return this;
        }

        public final void setDetailType(String detailType) {
            this.detailType = detailType;
        }

        public final String getDetail() {
            return this.detail;
        }

        @Override
        public final Builder detail(String detail) {
            this.detail = detail;
            return this;
        }

        public final void setDetail(String detail) {
            this.detail = detail;
        }

        public final String getEventBusName() {
            return this.eventBusName;
        }

        @Override
        public final Builder eventBusName(String eventBusName) {
            this.eventBusName = eventBusName;
            return this;
        }

        public final void setEventBusName(String eventBusName) {
            this.eventBusName = eventBusName;
        }

        public PutEventsRequestEntry build() {
            return new PutEventsRequestEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PutEventsRequestEntry> {
        public Builder time(Instant var1);

        public Builder source(String var1);

        public Builder resources(Collection<String> var1);

        public Builder resources(String ... var1);

        public Builder detailType(String var1);

        public Builder detail(String var1);

        public Builder eventBusName(String var1);
    }
}

