/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The logging configuration settings for the event bus.
 * </p>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/eb-event-bus-logs.html">Configuring logs for event
 * buses</a> in the <i>EventBridge User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogConfig implements SdkPojo, Serializable, ToCopyableBuilder<LogConfig.Builder, LogConfig> {
    private static final SdkField<String> INCLUDE_DETAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IncludeDetail").getter(getter(LogConfig::includeDetailAsString)).setter(setter(Builder::includeDetail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeDetail").build()).build();

    private static final SdkField<String> LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Level")
            .getter(getter(LogConfig::levelAsString)).setter(setter(Builder::level))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Level").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDE_DETAIL_FIELD,
            LEVEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String includeDetail;

    private final String level;

    private LogConfig(BuilderImpl builder) {
        this.includeDetail = builder.includeDetail;
        this.level = builder.level;
    }

    /**
     * <p>
     * Whether EventBridge include detailed event information in the records it generates. Detailed data can be useful
     * for troubleshooting and debugging. This information includes details of the event itself, as well as target
     * details.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-bus-logs.html#eb-event-logs-data"
     * >Including detail data in event bus logs</a> in the <i>EventBridge User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #includeDetail}
     * will return {@link IncludeDetail#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #includeDetailAsString}.
     * </p>
     * 
     * @return Whether EventBridge include detailed event information in the records it generates. Detailed data can be
     *         useful for troubleshooting and debugging. This information includes details of the event itself, as well
     *         as target details.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-bus-logs.html#eb-event-logs-data"
     *         >Including detail data in event bus logs</a> in the <i>EventBridge User Guide</i>.
     * @see IncludeDetail
     */
    public final IncludeDetail includeDetail() {
        return IncludeDetail.fromValue(includeDetail);
    }

    /**
     * <p>
     * Whether EventBridge include detailed event information in the records it generates. Detailed data can be useful
     * for troubleshooting and debugging. This information includes details of the event itself, as well as target
     * details.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-bus-logs.html#eb-event-logs-data"
     * >Including detail data in event bus logs</a> in the <i>EventBridge User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #includeDetail}
     * will return {@link IncludeDetail#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #includeDetailAsString}.
     * </p>
     * 
     * @return Whether EventBridge include detailed event information in the records it generates. Detailed data can be
     *         useful for troubleshooting and debugging. This information includes details of the event itself, as well
     *         as target details.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-bus-logs.html#eb-event-logs-data"
     *         >Including detail data in event bus logs</a> in the <i>EventBridge User Guide</i>.
     * @see IncludeDetail
     */
    public final String includeDetailAsString() {
        return includeDetail;
    }

    /**
     * <p>
     * The level of logging detail to include. This applies to all log destinations for the event bus.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-bus-logs.html#eb-event-bus-logs-level"
     * >Specifying event bus log level</a> in the <i>EventBridge User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #level} will return
     * {@link Level#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #levelAsString}.
     * </p>
     * 
     * @return The level of logging detail to include. This applies to all log destinations for the event bus.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-bus-logs.html#eb-event-bus-logs-level"
     *         >Specifying event bus log level</a> in the <i>EventBridge User Guide</i>.
     * @see Level
     */
    public final Level level() {
        return Level.fromValue(level);
    }

    /**
     * <p>
     * The level of logging detail to include. This applies to all log destinations for the event bus.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-bus-logs.html#eb-event-bus-logs-level"
     * >Specifying event bus log level</a> in the <i>EventBridge User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #level} will return
     * {@link Level#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #levelAsString}.
     * </p>
     * 
     * @return The level of logging detail to include. This applies to all log destinations for the event bus.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-bus-logs.html#eb-event-bus-logs-level"
     *         >Specifying event bus log level</a> in the <i>EventBridge User Guide</i>.
     * @see Level
     */
    public final String levelAsString() {
        return level;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(includeDetailAsString());
        hashCode = 31 * hashCode + Objects.hashCode(levelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogConfig)) {
            return false;
        }
        LogConfig other = (LogConfig) obj;
        return Objects.equals(includeDetailAsString(), other.includeDetailAsString())
                && Objects.equals(levelAsString(), other.levelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogConfig").add("IncludeDetail", includeDetailAsString()).add("Level", levelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IncludeDetail":
            return Optional.ofNullable(clazz.cast(includeDetailAsString()));
        case "Level":
            return Optional.ofNullable(clazz.cast(levelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IncludeDetail", INCLUDE_DETAIL_FIELD);
        map.put("Level", LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogConfig, T> g) {
        return obj -> g.apply((LogConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogConfig> {
        /**
         * <p>
         * Whether EventBridge include detailed event information in the records it generates. Detailed data can be
         * useful for troubleshooting and debugging. This information includes details of the event itself, as well as
         * target details.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-bus-logs.html#eb-event-logs-data"
         * >Including detail data in event bus logs</a> in the <i>EventBridge User Guide</i>.
         * </p>
         * 
         * @param includeDetail
         *        Whether EventBridge include detailed event information in the records it generates. Detailed data can
         *        be useful for troubleshooting and debugging. This information includes details of the event itself, as
         *        well as target details.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-bus-logs.html#eb-event-logs-data"
         *        >Including detail data in event bus logs</a> in the <i>EventBridge User Guide</i>.
         * @see IncludeDetail
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IncludeDetail
         */
        Builder includeDetail(String includeDetail);

        /**
         * <p>
         * Whether EventBridge include detailed event information in the records it generates. Detailed data can be
         * useful for troubleshooting and debugging. This information includes details of the event itself, as well as
         * target details.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-bus-logs.html#eb-event-logs-data"
         * >Including detail data in event bus logs</a> in the <i>EventBridge User Guide</i>.
         * </p>
         * 
         * @param includeDetail
         *        Whether EventBridge include detailed event information in the records it generates. Detailed data can
         *        be useful for troubleshooting and debugging. This information includes details of the event itself, as
         *        well as target details.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-bus-logs.html#eb-event-logs-data"
         *        >Including detail data in event bus logs</a> in the <i>EventBridge User Guide</i>.
         * @see IncludeDetail
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IncludeDetail
         */
        Builder includeDetail(IncludeDetail includeDetail);

        /**
         * <p>
         * The level of logging detail to include. This applies to all log destinations for the event bus.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-bus-logs.html#eb-event-bus-logs-level"
         * >Specifying event bus log level</a> in the <i>EventBridge User Guide</i>.
         * </p>
         * 
         * @param level
         *        The level of logging detail to include. This applies to all log destinations for the event bus.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-bus-logs.html#eb-event-bus-logs-level"
         *        >Specifying event bus log level</a> in the <i>EventBridge User Guide</i>.
         * @see Level
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Level
         */
        Builder level(String level);

        /**
         * <p>
         * The level of logging detail to include. This applies to all log destinations for the event bus.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-bus-logs.html#eb-event-bus-logs-level"
         * >Specifying event bus log level</a> in the <i>EventBridge User Guide</i>.
         * </p>
         * 
         * @param level
         *        The level of logging detail to include. This applies to all log destinations for the event bus.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-bus-logs.html#eb-event-bus-logs-level"
         *        >Specifying event bus log level</a> in the <i>EventBridge User Guide</i>.
         * @see Level
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Level
         */
        Builder level(Level level);
    }

    static final class BuilderImpl implements Builder {
        private String includeDetail;

        private String level;

        private BuilderImpl() {
        }

        private BuilderImpl(LogConfig model) {
            includeDetail(model.includeDetail);
            level(model.level);
        }

        public final String getIncludeDetail() {
            return includeDetail;
        }

        public final void setIncludeDetail(String includeDetail) {
            this.includeDetail = includeDetail;
        }

        @Override
        public final Builder includeDetail(String includeDetail) {
            this.includeDetail = includeDetail;
            return this;
        }

        @Override
        public final Builder includeDetail(IncludeDetail includeDetail) {
            this.includeDetail(includeDetail == null ? null : includeDetail.toString());
            return this;
        }

        public final String getLevel() {
            return level;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        public final Builder level(Level level) {
            this.level(level == null ? null : level.toString());
            return this;
        }

        @Override
        public LogConfig build() {
            return new LogConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
