/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEventBusResponse extends EventBridgeResponse implements
        ToCopyableBuilder<DescribeEventBusResponse.Builder, DescribeEventBusResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeEventBusResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribeEventBusResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeEventBusResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyIdentifier").getter(getter(DescribeEventBusResponse::kmsKeyIdentifier))
            .setter(setter(Builder::kmsKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyIdentifier").build()).build();

    private static final SdkField<DeadLetterConfig> DEAD_LETTER_CONFIG_FIELD = SdkField
            .<DeadLetterConfig> builder(MarshallingType.SDK_POJO).memberName("DeadLetterConfig")
            .getter(getter(DescribeEventBusResponse::deadLetterConfig)).setter(setter(Builder::deadLetterConfig))
            .constructor(DeadLetterConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterConfig").build()).build();

    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Policy")
            .getter(getter(DescribeEventBusResponse::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()).build();

    private static final SdkField<LogConfig> LOG_CONFIG_FIELD = SdkField.<LogConfig> builder(MarshallingType.SDK_POJO)
            .memberName("LogConfig").getter(getter(DescribeEventBusResponse::logConfig)).setter(setter(Builder::logConfig))
            .constructor(LogConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogConfig").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeEventBusResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeEventBusResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            DESCRIPTION_FIELD, KMS_KEY_IDENTIFIER_FIELD, DEAD_LETTER_CONFIG_FIELD, POLICY_FIELD, LOG_CONFIG_FIELD,
            CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String arn;

    private final String description;

    private final String kmsKeyIdentifier;

    private final DeadLetterConfig deadLetterConfig;

    private final String policy;

    private final LogConfig logConfig;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private DescribeEventBusResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.arn = builder.arn;
        this.description = builder.description;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
        this.deadLetterConfig = builder.deadLetterConfig;
        this.policy = builder.policy;
        this.logConfig = builder.logConfig;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The name of the event bus. Currently, this is always <code>default</code>.
     * </p>
     * 
     * @return The name of the event bus. Currently, this is always <code>default</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the account permitted to write events to the current account.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the account permitted to write events to the current account.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The event bus description.
     * </p>
     * 
     * @return The event bus description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the KMS customer managed key for EventBridge to use to encrypt events on this event bus, if one
     * has been specified.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-encryption.html">Data encryption in
     * EventBridge</a> in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * 
     * @return The identifier of the KMS customer managed key for EventBridge to use to encrypt events on this event
     *         bus, if one has been specified.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-encryption.html">Data encryption in
     *         EventBridge</a> in the <i>Amazon EventBridge User Guide</i>.
     */
    public final String kmsKeyIdentifier() {
        return kmsKeyIdentifier;
    }

    /**
     * Returns the value of the DeadLetterConfig property for this object.
     * 
     * @return The value of the DeadLetterConfig property for this object.
     */
    public final DeadLetterConfig deadLetterConfig() {
        return deadLetterConfig;
    }

    /**
     * <p>
     * The policy that enables the external account to send events to your account.
     * </p>
     * 
     * @return The policy that enables the external account to send events to your account.
     */
    public final String policy() {
        return policy;
    }

    /**
     * <p>
     * The logging configuration settings for the event bus.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/eb-event-bus-logs.html">Configuring logs for event
     * buses</a> in the <i>EventBridge User Guide</i>.
     * </p>
     * 
     * @return The logging configuration settings for the event bus.</p>
     *         <p>
     *         For more information, see <a href="https://docs.aws.amazon.com/eb-event-bus-logs.html">Configuring logs
     *         for event buses</a> in the <i>EventBridge User Guide</i>.
     */
    public final LogConfig logConfig() {
        return logConfig;
    }

    /**
     * <p>
     * The time the event bus was created.
     * </p>
     * 
     * @return The time the event bus was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time the event bus was last modified.
     * </p>
     * 
     * @return The time the event bus was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(deadLetterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(logConfig());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventBusResponse)) {
            return false;
        }
        DescribeEventBusResponse other = (DescribeEventBusResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(description(), other.description())
                && Objects.equals(kmsKeyIdentifier(), other.kmsKeyIdentifier())
                && Objects.equals(deadLetterConfig(), other.deadLetterConfig()) && Objects.equals(policy(), other.policy())
                && Objects.equals(logConfig(), other.logConfig()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEventBusResponse").add("Name", name()).add("Arn", arn())
                .add("Description", description()).add("KmsKeyIdentifier", kmsKeyIdentifier())
                .add("DeadLetterConfig", deadLetterConfig()).add("Policy", policy()).add("LogConfig", logConfig())
                .add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "KmsKeyIdentifier":
            return Optional.ofNullable(clazz.cast(kmsKeyIdentifier()));
        case "DeadLetterConfig":
            return Optional.ofNullable(clazz.cast(deadLetterConfig()));
        case "Policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "LogConfig":
            return Optional.ofNullable(clazz.cast(logConfig()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("KmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
        map.put("DeadLetterConfig", DEAD_LETTER_CONFIG_FIELD);
        map.put("Policy", POLICY_FIELD);
        map.put("LogConfig", LOG_CONFIG_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventBusResponse, T> g) {
        return obj -> g.apply((DescribeEventBusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EventBridgeResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEventBusResponse> {
        /**
         * <p>
         * The name of the event bus. Currently, this is always <code>default</code>.
         * </p>
         * 
         * @param name
         *        The name of the event bus. Currently, this is always <code>default</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the account permitted to write events to the current account.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the account permitted to write events to the current account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The event bus description.
         * </p>
         * 
         * @param description
         *        The event bus description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the KMS customer managed key for EventBridge to use to encrypt events on this event bus, if
         * one has been specified.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-encryption.html">Data encryption in
         * EventBridge</a> in the <i>Amazon EventBridge User Guide</i>.
         * </p>
         * 
         * @param kmsKeyIdentifier
         *        The identifier of the KMS customer managed key for EventBridge to use to encrypt events on this event
         *        bus, if one has been specified.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-encryption.html">Data encryption in
         *        EventBridge</a> in the <i>Amazon EventBridge User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyIdentifier(String kmsKeyIdentifier);

        /**
         * Sets the value of the DeadLetterConfig property for this object.
         *
         * @param deadLetterConfig
         *        The new value for the DeadLetterConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deadLetterConfig(DeadLetterConfig deadLetterConfig);

        /**
         * Sets the value of the DeadLetterConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DeadLetterConfig.Builder} avoiding the
         * need to create one manually via {@link DeadLetterConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeadLetterConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #deadLetterConfig(DeadLetterConfig)}.
         * 
         * @param deadLetterConfig
         *        a consumer that will call methods on {@link DeadLetterConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deadLetterConfig(DeadLetterConfig)
         */
        default Builder deadLetterConfig(Consumer<DeadLetterConfig.Builder> deadLetterConfig) {
            return deadLetterConfig(DeadLetterConfig.builder().applyMutation(deadLetterConfig).build());
        }

        /**
         * <p>
         * The policy that enables the external account to send events to your account.
         * </p>
         * 
         * @param policy
         *        The policy that enables the external account to send events to your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * The logging configuration settings for the event bus.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/eb-event-bus-logs.html">Configuring logs for
         * event buses</a> in the <i>EventBridge User Guide</i>.
         * </p>
         * 
         * @param logConfig
         *        The logging configuration settings for the event bus.</p>
         *        <p>
         *        For more information, see <a href="https://docs.aws.amazon.com/eb-event-bus-logs.html">Configuring
         *        logs for event buses</a> in the <i>EventBridge User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfig(LogConfig logConfig);

        /**
         * <p>
         * The logging configuration settings for the event bus.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/eb-event-bus-logs.html">Configuring logs for
         * event buses</a> in the <i>EventBridge User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogConfig.Builder} avoiding the need to
         * create one manually via {@link LogConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #logConfig(LogConfig)}.
         * 
         * @param logConfig
         *        a consumer that will call methods on {@link LogConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfig(LogConfig)
         */
        default Builder logConfig(Consumer<LogConfig.Builder> logConfig) {
            return logConfig(LogConfig.builder().applyMutation(logConfig).build());
        }

        /**
         * <p>
         * The time the event bus was created.
         * </p>
         * 
         * @param creationTime
         *        The time the event bus was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time the event bus was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time the event bus was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl extends EventBridgeResponse.BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String description;

        private String kmsKeyIdentifier;

        private DeadLetterConfig deadLetterConfig;

        private String policy;

        private LogConfig logConfig;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventBusResponse model) {
            super(model);
            name(model.name);
            arn(model.arn);
            description(model.description);
            kmsKeyIdentifier(model.kmsKeyIdentifier);
            deadLetterConfig(model.deadLetterConfig);
            policy(model.policy);
            logConfig(model.logConfig);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        public final DeadLetterConfig.Builder getDeadLetterConfig() {
            return deadLetterConfig != null ? deadLetterConfig.toBuilder() : null;
        }

        public final void setDeadLetterConfig(DeadLetterConfig.BuilderImpl deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig != null ? deadLetterConfig.build() : null;
        }

        @Override
        public final Builder deadLetterConfig(DeadLetterConfig deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        public final String getPolicy() {
            return policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final LogConfig.Builder getLogConfig() {
            return logConfig != null ? logConfig.toBuilder() : null;
        }

        public final void setLogConfig(LogConfig.BuilderImpl logConfig) {
            this.logConfig = logConfig != null ? logConfig.build() : null;
        }

        @Override
        public final Builder logConfig(LogConfig logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public DescribeEventBusResponse build() {
            return new DescribeEventBusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
