/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.auth.scheme.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.auth.aws.signer.RegionSet;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.eventbridge.auth.scheme.EventBridgeAuthSchemeParams;
import software.amazon.awssdk.services.eventbridge.auth.scheme.internal.EventBridgeEndpointResolverAware;
import software.amazon.awssdk.services.eventbridge.endpoints.EventBridgeEndpointProvider;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultEventBridgeAuthSchemeParams
implements EventBridgeAuthSchemeParams,
EventBridgeEndpointResolverAware {
    private final String operation;
    private final Region region;
    private final RegionSet regionSet;
    private final String endpointId;
    private final EventBridgeEndpointProvider endpointProvider;

    private DefaultEventBridgeAuthSchemeParams(Builder builder) {
        this.operation = (String)Validate.paramNotNull((Object)builder.operation, (String)"operation");
        this.region = builder.region;
        this.regionSet = builder.regionSet;
        this.endpointId = builder.endpointId;
        this.endpointProvider = builder.endpointProvider;
    }

    public static EventBridgeAuthSchemeParams.Builder builder() {
        return new Builder();
    }

    @Override
    public String operation() {
        return this.operation;
    }

    @Override
    public Region region() {
        return this.region;
    }

    @Override
    public RegionSet regionSet() {
        return this.regionSet;
    }

    @Override
    public String endpointId() {
        return this.endpointId;
    }

    @Override
    public EventBridgeEndpointProvider endpointProvider() {
        return this.endpointProvider;
    }

    @Override
    public EventBridgeAuthSchemeParams.Builder toBuilder() {
        return new Builder(this);
    }

    private static final class Builder
    implements EventBridgeAuthSchemeParams.Builder,
    EventBridgeEndpointResolverAware.Builder {
        private String operation;
        private Region region;
        private RegionSet regionSet;
        private String endpointId;
        private EventBridgeEndpointProvider endpointProvider;

        Builder() {
        }

        Builder(DefaultEventBridgeAuthSchemeParams params) {
            this.operation = params.operation;
            this.region = params.region;
            this.regionSet = params.regionSet;
            this.endpointId = params.endpointId;
            this.endpointProvider = params.endpointProvider;
        }

        @Override
        public Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public Builder regionSet(RegionSet regionSet) {
            this.regionSet = regionSet;
            return this;
        }

        @Override
        public Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        @Override
        public Builder endpointProvider(EventBridgeEndpointProvider endpointProvider) {
            this.endpointProvider = endpointProvider;
            return this;
        }

        @Override
        public EventBridgeAuthSchemeParams build() {
            return new DefaultEventBridgeAuthSchemeParams(this);
        }
    }
}

