/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eventbridge.model.ApiDestinationHttpMethod;
import software.amazon.awssdk.services.eventbridge.model.ApiDestinationState;
import software.amazon.awssdk.services.eventbridge.model.EventBridgeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeApiDestinationResponse
extends EventBridgeResponse
implements ToCopyableBuilder<Builder, DescribeApiDestinationResponse> {
    private static final SdkField<String> API_DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiDestinationArn").getter(DescribeApiDestinationResponse.getter(DescribeApiDestinationResponse::apiDestinationArn)).setter(DescribeApiDestinationResponse.setter(Builder::apiDestinationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiDestinationArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeApiDestinationResponse.getter(DescribeApiDestinationResponse::name)).setter(DescribeApiDestinationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeApiDestinationResponse.getter(DescribeApiDestinationResponse::description)).setter(DescribeApiDestinationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> API_DESTINATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiDestinationState").getter(DescribeApiDestinationResponse.getter(DescribeApiDestinationResponse::apiDestinationStateAsString)).setter(DescribeApiDestinationResponse.setter(Builder::apiDestinationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiDestinationState").build()}).build();
    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionArn").getter(DescribeApiDestinationResponse.getter(DescribeApiDestinationResponse::connectionArn)).setter(DescribeApiDestinationResponse.setter(Builder::connectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionArn").build()}).build();
    private static final SdkField<String> INVOCATION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvocationEndpoint").getter(DescribeApiDestinationResponse.getter(DescribeApiDestinationResponse::invocationEndpoint)).setter(DescribeApiDestinationResponse.setter(Builder::invocationEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationEndpoint").build()}).build();
    private static final SdkField<String> HTTP_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpMethod").getter(DescribeApiDestinationResponse.getter(DescribeApiDestinationResponse::httpMethodAsString)).setter(DescribeApiDestinationResponse.setter(Builder::httpMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpMethod").build()}).build();
    private static final SdkField<Integer> INVOCATION_RATE_LIMIT_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InvocationRateLimitPerSecond").getter(DescribeApiDestinationResponse.getter(DescribeApiDestinationResponse::invocationRateLimitPerSecond)).setter(DescribeApiDestinationResponse.setter(Builder::invocationRateLimitPerSecond)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationRateLimitPerSecond").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeApiDestinationResponse.getter(DescribeApiDestinationResponse::creationTime)).setter(DescribeApiDestinationResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeApiDestinationResponse.getter(DescribeApiDestinationResponse::lastModifiedTime)).setter(DescribeApiDestinationResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_DESTINATION_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, API_DESTINATION_STATE_FIELD, CONNECTION_ARN_FIELD, INVOCATION_ENDPOINT_FIELD, HTTP_METHOD_FIELD, INVOCATION_RATE_LIMIT_PER_SECOND_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ApiDestinationArn", API_DESTINATION_ARN_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("ApiDestinationState", API_DESTINATION_STATE_FIELD);
            this.put("ConnectionArn", CONNECTION_ARN_FIELD);
            this.put("InvocationEndpoint", INVOCATION_ENDPOINT_FIELD);
            this.put("HttpMethod", HTTP_METHOD_FIELD);
            this.put("InvocationRateLimitPerSecond", INVOCATION_RATE_LIMIT_PER_SECOND_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        }
    });
    private final String apiDestinationArn;
    private final String name;
    private final String description;
    private final String apiDestinationState;
    private final String connectionArn;
    private final String invocationEndpoint;
    private final String httpMethod;
    private final Integer invocationRateLimitPerSecond;
    private final Instant creationTime;
    private final Instant lastModifiedTime;

    private DescribeApiDestinationResponse(BuilderImpl builder) {
        super(builder);
        this.apiDestinationArn = builder.apiDestinationArn;
        this.name = builder.name;
        this.description = builder.description;
        this.apiDestinationState = builder.apiDestinationState;
        this.connectionArn = builder.connectionArn;
        this.invocationEndpoint = builder.invocationEndpoint;
        this.httpMethod = builder.httpMethod;
        this.invocationRateLimitPerSecond = builder.invocationRateLimitPerSecond;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String apiDestinationArn() {
        return this.apiDestinationArn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final ApiDestinationState apiDestinationState() {
        return ApiDestinationState.fromValue(this.apiDestinationState);
    }

    public final String apiDestinationStateAsString() {
        return this.apiDestinationState;
    }

    public final String connectionArn() {
        return this.connectionArn;
    }

    public final String invocationEndpoint() {
        return this.invocationEndpoint;
    }

    public final ApiDestinationHttpMethod httpMethod() {
        return ApiDestinationHttpMethod.fromValue(this.httpMethod);
    }

    public final String httpMethodAsString() {
        return this.httpMethod;
    }

    public final Integer invocationRateLimitPerSecond() {
        return this.invocationRateLimitPerSecond;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiDestinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiDestinationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationRateLimitPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApiDestinationResponse)) {
            return false;
        }
        DescribeApiDestinationResponse other = (DescribeApiDestinationResponse)((Object)obj);
        return Objects.equals(this.apiDestinationArn(), other.apiDestinationArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.apiDestinationStateAsString(), other.apiDestinationStateAsString()) && Objects.equals(this.connectionArn(), other.connectionArn()) && Objects.equals(this.invocationEndpoint(), other.invocationEndpoint()) && Objects.equals(this.httpMethodAsString(), other.httpMethodAsString()) && Objects.equals(this.invocationRateLimitPerSecond(), other.invocationRateLimitPerSecond()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeApiDestinationResponse").add("ApiDestinationArn", (Object)this.apiDestinationArn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ApiDestinationState", (Object)this.apiDestinationStateAsString()).add("ConnectionArn", (Object)this.connectionArn()).add("InvocationEndpoint", (Object)this.invocationEndpoint()).add("HttpMethod", (Object)this.httpMethodAsString()).add("InvocationRateLimitPerSecond", (Object)this.invocationRateLimitPerSecond()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiDestinationArn": {
                return Optional.ofNullable(clazz.cast(this.apiDestinationArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ApiDestinationState": {
                return Optional.ofNullable(clazz.cast(this.apiDestinationStateAsString()));
            }
            case "ConnectionArn": {
                return Optional.ofNullable(clazz.cast(this.connectionArn()));
            }
            case "InvocationEndpoint": {
                return Optional.ofNullable(clazz.cast(this.invocationEndpoint()));
            }
            case "HttpMethod": {
                return Optional.ofNullable(clazz.cast(this.httpMethodAsString()));
            }
            case "InvocationRateLimitPerSecond": {
                return Optional.ofNullable(clazz.cast(this.invocationRateLimitPerSecond()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeApiDestinationResponse, T> g) {
        return obj -> g.apply((DescribeApiDestinationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EventBridgeResponse.BuilderImpl
    implements Builder {
        private String apiDestinationArn;
        private String name;
        private String description;
        private String apiDestinationState;
        private String connectionArn;
        private String invocationEndpoint;
        private String httpMethod;
        private Integer invocationRateLimitPerSecond;
        private Instant creationTime;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApiDestinationResponse model) {
            super(model);
            this.apiDestinationArn(model.apiDestinationArn);
            this.name(model.name);
            this.description(model.description);
            this.apiDestinationState(model.apiDestinationState);
            this.connectionArn(model.connectionArn);
            this.invocationEndpoint(model.invocationEndpoint);
            this.httpMethod(model.httpMethod);
            this.invocationRateLimitPerSecond(model.invocationRateLimitPerSecond);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getApiDestinationArn() {
            return this.apiDestinationArn;
        }

        public final void setApiDestinationArn(String apiDestinationArn) {
            this.apiDestinationArn = apiDestinationArn;
        }

        @Override
        public final Builder apiDestinationArn(String apiDestinationArn) {
            this.apiDestinationArn = apiDestinationArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getApiDestinationState() {
            return this.apiDestinationState;
        }

        public final void setApiDestinationState(String apiDestinationState) {
            this.apiDestinationState = apiDestinationState;
        }

        @Override
        public final Builder apiDestinationState(String apiDestinationState) {
            this.apiDestinationState = apiDestinationState;
            return this;
        }

        @Override
        public final Builder apiDestinationState(ApiDestinationState apiDestinationState) {
            this.apiDestinationState(apiDestinationState == null ? null : apiDestinationState.toString());
            return this;
        }

        public final String getConnectionArn() {
            return this.connectionArn;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        @Override
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final String getInvocationEndpoint() {
            return this.invocationEndpoint;
        }

        public final void setInvocationEndpoint(String invocationEndpoint) {
            this.invocationEndpoint = invocationEndpoint;
        }

        @Override
        public final Builder invocationEndpoint(String invocationEndpoint) {
            this.invocationEndpoint = invocationEndpoint;
            return this;
        }

        public final String getHttpMethod() {
            return this.httpMethod;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        @Override
        public final Builder httpMethod(ApiDestinationHttpMethod httpMethod) {
            this.httpMethod(httpMethod == null ? null : httpMethod.toString());
            return this;
        }

        public final Integer getInvocationRateLimitPerSecond() {
            return this.invocationRateLimitPerSecond;
        }

        public final void setInvocationRateLimitPerSecond(Integer invocationRateLimitPerSecond) {
            this.invocationRateLimitPerSecond = invocationRateLimitPerSecond;
        }

        @Override
        public final Builder invocationRateLimitPerSecond(Integer invocationRateLimitPerSecond) {
            this.invocationRateLimitPerSecond = invocationRateLimitPerSecond;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public DescribeApiDestinationResponse build() {
            return new DescribeApiDestinationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EventBridgeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeApiDestinationResponse> {
        public Builder apiDestinationArn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder apiDestinationState(String var1);

        public Builder apiDestinationState(ApiDestinationState var1);

        public Builder connectionArn(String var1);

        public Builder invocationEndpoint(String var1);

        public Builder httpMethod(String var1);

        public Builder httpMethod(ApiDestinationHttpMethod var1);

        public Builder invocationRateLimitPerSecond(Integer var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

