/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eventbridge.model.RunCommandTarget;
import software.amazon.awssdk.services.eventbridge.model.RunCommandTargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RunCommandParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RunCommandParameters> {
    private static final SdkField<List<RunCommandTarget>> RUN_COMMAND_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RunCommandTargets").getter(RunCommandParameters.getter(RunCommandParameters::runCommandTargets)).setter(RunCommandParameters.setter(Builder::runCommandTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunCommandTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RunCommandTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUN_COMMAND_TARGETS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<RunCommandTarget> runCommandTargets;

    private RunCommandParameters(BuilderImpl builder) {
        this.runCommandTargets = builder.runCommandTargets;
    }

    public final boolean hasRunCommandTargets() {
        return this.runCommandTargets != null && !(this.runCommandTargets instanceof SdkAutoConstructList);
    }

    public final List<RunCommandTarget> runCommandTargets() {
        return this.runCommandTargets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRunCommandTargets() ? this.runCommandTargets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunCommandParameters)) {
            return false;
        }
        RunCommandParameters other = (RunCommandParameters)obj;
        return this.hasRunCommandTargets() == other.hasRunCommandTargets() && Objects.equals(this.runCommandTargets(), other.runCommandTargets());
    }

    public final String toString() {
        return ToString.builder((String)"RunCommandParameters").add("RunCommandTargets", this.hasRunCommandTargets() ? this.runCommandTargets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RunCommandTargets": {
                return Optional.ofNullable(clazz.cast(this.runCommandTargets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RunCommandParameters, T> g) {
        return obj -> g.apply((RunCommandParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<RunCommandTarget> runCommandTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RunCommandParameters model) {
            this.runCommandTargets(model.runCommandTargets);
        }

        public final List<RunCommandTarget.Builder> getRunCommandTargets() {
            List<RunCommandTarget.Builder> result = RunCommandTargetsCopier.copyToBuilder(this.runCommandTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRunCommandTargets(Collection<RunCommandTarget.BuilderImpl> runCommandTargets) {
            this.runCommandTargets = RunCommandTargetsCopier.copyFromBuilder(runCommandTargets);
        }

        @Override
        @Transient
        public final Builder runCommandTargets(Collection<RunCommandTarget> runCommandTargets) {
            this.runCommandTargets = RunCommandTargetsCopier.copy(runCommandTargets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder runCommandTargets(RunCommandTarget ... runCommandTargets) {
            this.runCommandTargets(Arrays.asList(runCommandTargets));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder runCommandTargets(Consumer<RunCommandTarget.Builder> ... runCommandTargets) {
            this.runCommandTargets(Stream.of(runCommandTargets).map(c -> (RunCommandTarget)((RunCommandTarget.Builder)RunCommandTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RunCommandParameters build() {
            return new RunCommandParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RunCommandParameters> {
        public Builder runCommandTargets(Collection<RunCommandTarget> var1);

        public Builder runCommandTargets(RunCommandTarget ... var1);

        public Builder runCommandTargets(Consumer<RunCommandTarget.Builder> ... var1);
    }
}

