/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing the <code>providerServiceARN</code>, <code>intermediateSourceConfiguration</code>, and
 * <code>providerConfiguration</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProviderProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<ProviderProperties.Builder, ProviderProperties> {
    private static final SdkField<String> PROVIDER_SERVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerServiceArn").getter(getter(ProviderProperties::providerServiceArn))
            .setter(setter(Builder::providerServiceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerServiceArn").build())
            .build();

    private static final SdkField<Document> PROVIDER_CONFIGURATION_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("providerConfiguration").getter(getter(ProviderProperties::providerConfiguration))
            .setter(setter(Builder::providerConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerConfiguration").build())
            .build();

    private static final SdkField<IntermediateSourceConfiguration> INTERMEDIATE_SOURCE_CONFIGURATION_FIELD = SdkField
            .<IntermediateSourceConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("intermediateSourceConfiguration")
            .getter(getter(ProviderProperties::intermediateSourceConfiguration))
            .setter(setter(Builder::intermediateSourceConfiguration))
            .constructor(IntermediateSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intermediateSourceConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_SERVICE_ARN_FIELD,
            PROVIDER_CONFIGURATION_FIELD, INTERMEDIATE_SOURCE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String providerServiceArn;

    private final Document providerConfiguration;

    private final IntermediateSourceConfiguration intermediateSourceConfiguration;

    private ProviderProperties(BuilderImpl builder) {
        this.providerServiceArn = builder.providerServiceArn;
        this.providerConfiguration = builder.providerConfiguration;
        this.intermediateSourceConfiguration = builder.intermediateSourceConfiguration;
    }

    /**
     * <p>
     * The ARN of the provider service.
     * </p>
     * 
     * @return The ARN of the provider service.
     */
    public final String providerServiceArn() {
        return providerServiceArn;
    }

    /**
     * <p>
     * The required configuration fields to use with the provider service.
     * </p>
     * 
     * @return The required configuration fields to use with the provider service.
     */
    public final Document providerConfiguration() {
        return providerConfiguration;
    }

    /**
     * <p>
     * The Amazon S3 location that temporarily stores your data while it processes. Your information won't be saved
     * permanently.
     * </p>
     * 
     * @return The Amazon S3 location that temporarily stores your data while it processes. Your information won't be
     *         saved permanently.
     */
    public final IntermediateSourceConfiguration intermediateSourceConfiguration() {
        return intermediateSourceConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(providerServiceArn());
        hashCode = 31 * hashCode + Objects.hashCode(providerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(intermediateSourceConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProviderProperties)) {
            return false;
        }
        ProviderProperties other = (ProviderProperties) obj;
        return Objects.equals(providerServiceArn(), other.providerServiceArn())
                && Objects.equals(providerConfiguration(), other.providerConfiguration())
                && Objects.equals(intermediateSourceConfiguration(), other.intermediateSourceConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProviderProperties").add("ProviderServiceArn", providerServiceArn())
                .add("ProviderConfiguration", providerConfiguration())
                .add("IntermediateSourceConfiguration", intermediateSourceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "providerServiceArn":
            return Optional.ofNullable(clazz.cast(providerServiceArn()));
        case "providerConfiguration":
            return Optional.ofNullable(clazz.cast(providerConfiguration()));
        case "intermediateSourceConfiguration":
            return Optional.ofNullable(clazz.cast(intermediateSourceConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("providerServiceArn", PROVIDER_SERVICE_ARN_FIELD);
        map.put("providerConfiguration", PROVIDER_CONFIGURATION_FIELD);
        map.put("intermediateSourceConfiguration", INTERMEDIATE_SOURCE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProviderProperties, T> g) {
        return obj -> g.apply((ProviderProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProviderProperties> {
        /**
         * <p>
         * The ARN of the provider service.
         * </p>
         * 
         * @param providerServiceArn
         *        The ARN of the provider service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerServiceArn(String providerServiceArn);

        /**
         * <p>
         * The required configuration fields to use with the provider service.
         * </p>
         * 
         * @param providerConfiguration
         *        The required configuration fields to use with the provider service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerConfiguration(Document providerConfiguration);

        /**
         * <p>
         * The Amazon S3 location that temporarily stores your data while it processes. Your information won't be saved
         * permanently.
         * </p>
         * 
         * @param intermediateSourceConfiguration
         *        The Amazon S3 location that temporarily stores your data while it processes. Your information won't be
         *        saved permanently.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intermediateSourceConfiguration(IntermediateSourceConfiguration intermediateSourceConfiguration);

        /**
         * <p>
         * The Amazon S3 location that temporarily stores your data while it processes. Your information won't be saved
         * permanently.
         * </p>
         * This is a convenience method that creates an instance of the {@link IntermediateSourceConfiguration.Builder}
         * avoiding the need to create one manually via {@link IntermediateSourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IntermediateSourceConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #intermediateSourceConfiguration(IntermediateSourceConfiguration)}.
         * 
         * @param intermediateSourceConfiguration
         *        a consumer that will call methods on {@link IntermediateSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intermediateSourceConfiguration(IntermediateSourceConfiguration)
         */
        default Builder intermediateSourceConfiguration(
                Consumer<IntermediateSourceConfiguration.Builder> intermediateSourceConfiguration) {
            return intermediateSourceConfiguration(IntermediateSourceConfiguration.builder()
                    .applyMutation(intermediateSourceConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String providerServiceArn;

        private Document providerConfiguration;

        private IntermediateSourceConfiguration intermediateSourceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ProviderProperties model) {
            providerServiceArn(model.providerServiceArn);
            providerConfiguration(model.providerConfiguration);
            intermediateSourceConfiguration(model.intermediateSourceConfiguration);
        }

        public final String getProviderServiceArn() {
            return providerServiceArn;
        }

        public final void setProviderServiceArn(String providerServiceArn) {
            this.providerServiceArn = providerServiceArn;
        }

        @Override
        public final Builder providerServiceArn(String providerServiceArn) {
            this.providerServiceArn = providerServiceArn;
            return this;
        }

        public final Document getProviderConfiguration() {
            return providerConfiguration;
        }

        public final void setProviderConfiguration(Document providerConfiguration) {
            this.providerConfiguration = providerConfiguration;
        }

        @Override
        public final Builder providerConfiguration(Document providerConfiguration) {
            this.providerConfiguration = providerConfiguration;
            return this;
        }

        public final IntermediateSourceConfiguration.Builder getIntermediateSourceConfiguration() {
            return intermediateSourceConfiguration != null ? intermediateSourceConfiguration.toBuilder() : null;
        }

        public final void setIntermediateSourceConfiguration(
                IntermediateSourceConfiguration.BuilderImpl intermediateSourceConfiguration) {
            this.intermediateSourceConfiguration = intermediateSourceConfiguration != null ? intermediateSourceConfiguration
                    .build() : null;
        }

        @Override
        public final Builder intermediateSourceConfiguration(IntermediateSourceConfiguration intermediateSourceConfiguration) {
            this.intermediateSourceConfiguration = intermediateSourceConfiguration;
            return this;
        }

        @Override
        public ProviderProperties build() {
            return new ProviderProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
