/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The matched record.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MatchedRecord implements SdkPojo, Serializable, ToCopyableBuilder<MatchedRecord.Builder, MatchedRecord> {
    private static final SdkField<String> INPUT_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputSourceARN").getter(getter(MatchedRecord::inputSourceARN)).setter(setter(Builder::inputSourceARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSourceARN").build()).build();

    private static final SdkField<String> RECORD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recordId").getter(getter(MatchedRecord::recordId)).setter(setter(Builder::recordId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_SOURCE_ARN_FIELD,
            RECORD_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String inputSourceARN;

    private final String recordId;

    private MatchedRecord(BuilderImpl builder) {
        this.inputSourceARN = builder.inputSourceARN;
        this.recordId = builder.recordId;
    }

    /**
     * <p>
     * The input source ARN of the matched record.
     * </p>
     * 
     * @return The input source ARN of the matched record.
     */
    public final String inputSourceARN() {
        return inputSourceARN;
    }

    /**
     * <p>
     * The record ID of the matched record.
     * </p>
     * 
     * @return The record ID of the matched record.
     */
    public final String recordId() {
        return recordId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputSourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(recordId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchedRecord)) {
            return false;
        }
        MatchedRecord other = (MatchedRecord) obj;
        return Objects.equals(inputSourceARN(), other.inputSourceARN()) && Objects.equals(recordId(), other.recordId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MatchedRecord").add("InputSourceARN", inputSourceARN()).add("RecordId", recordId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputSourceARN":
            return Optional.ofNullable(clazz.cast(inputSourceARN()));
        case "recordId":
            return Optional.ofNullable(clazz.cast(recordId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inputSourceARN", INPUT_SOURCE_ARN_FIELD);
        map.put("recordId", RECORD_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MatchedRecord, T> g) {
        return obj -> g.apply((MatchedRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MatchedRecord> {
        /**
         * <p>
         * The input source ARN of the matched record.
         * </p>
         * 
         * @param inputSourceARN
         *        The input source ARN of the matched record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSourceARN(String inputSourceARN);

        /**
         * <p>
         * The record ID of the matched record.
         * </p>
         * 
         * @param recordId
         *        The record ID of the matched record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordId(String recordId);
    }

    static final class BuilderImpl implements Builder {
        private String inputSourceARN;

        private String recordId;

        private BuilderImpl() {
        }

        private BuilderImpl(MatchedRecord model) {
            inputSourceARN(model.inputSourceARN);
            recordId(model.recordId);
        }

        public final String getInputSourceARN() {
            return inputSourceARN;
        }

        public final void setInputSourceARN(String inputSourceARN) {
            this.inputSourceARN = inputSourceARN;
        }

        @Override
        public final Builder inputSourceARN(String inputSourceARN) {
            this.inputSourceARN = inputSourceARN;
            return this;
        }

        public final String getRecordId() {
            return recordId;
        }

        public final void setRecordId(String recordId) {
            this.recordId = recordId;
        }

        @Override
        public final Builder recordId(String recordId) {
            this.recordId = recordId;
            return this;
        }

        @Override
        public MatchedRecord build() {
            return new MatchedRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
