/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSchemaMappingsResponse extends EntityResolutionResponse implements
        ToCopyableBuilder<ListSchemaMappingsResponse.Builder, ListSchemaMappingsResponse> {
    private static final SdkField<List<SchemaMappingSummary>> SCHEMA_LIST_FIELD = SdkField
            .<List<SchemaMappingSummary>> builder(MarshallingType.LIST)
            .memberName("schemaList")
            .getter(getter(ListSchemaMappingsResponse::schemaList))
            .setter(setter(Builder::schemaList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SchemaMappingSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SchemaMappingSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSchemaMappingsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<SchemaMappingSummary> schemaList;

    private final String nextToken;

    private ListSchemaMappingsResponse(BuilderImpl builder) {
        super(builder);
        this.schemaList = builder.schemaList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SchemaList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSchemaList() {
        return schemaList != null && !(schemaList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>SchemaMappingSummary</code> objects, each of which contain the fields <code>SchemaName</code>,
     * <code>SchemaArn</code>, <code>CreatedAt</code>, <code>UpdatedAt</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSchemaList} method.
     * </p>
     * 
     * @return A list of <code>SchemaMappingSummary</code> objects, each of which contain the fields
     *         <code>SchemaName</code>, <code>SchemaArn</code>, <code>CreatedAt</code>, <code>UpdatedAt</code>.
     */
    public final List<SchemaMappingSummary> schemaList() {
        return schemaList;
    }

    /**
     * <p>
     * The pagination token from the previous API call.
     * </p>
     * 
     * @return The pagination token from the previous API call.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSchemaList() ? schemaList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSchemaMappingsResponse)) {
            return false;
        }
        ListSchemaMappingsResponse other = (ListSchemaMappingsResponse) obj;
        return hasSchemaList() == other.hasSchemaList() && Objects.equals(schemaList(), other.schemaList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSchemaMappingsResponse").add("SchemaList", hasSchemaList() ? schemaList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "schemaList":
            return Optional.ofNullable(clazz.cast(schemaList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("schemaList", SCHEMA_LIST_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSchemaMappingsResponse, T> g) {
        return obj -> g.apply((ListSchemaMappingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EntityResolutionResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSchemaMappingsResponse> {
        /**
         * <p>
         * A list of <code>SchemaMappingSummary</code> objects, each of which contain the fields <code>SchemaName</code>, <code>SchemaArn</code>, <code>CreatedAt</code>, <code>UpdatedAt</code>.
         * </p>
         * 
         * @param schemaList
         *        A list of <code>SchemaMappingSummary</code> objects, each of which contain the fields
         *        <code>SchemaName</code>, <code>SchemaArn</code>, <code>CreatedAt</code>, <code>UpdatedAt</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaList(Collection<SchemaMappingSummary> schemaList);

        /**
         * <p>
         * A list of <code>SchemaMappingSummary</code> objects, each of which contain the fields <code>SchemaName</code>, <code>SchemaArn</code>, <code>CreatedAt</code>, <code>UpdatedAt</code>.
         * </p>
         * 
         * @param schemaList
         *        A list of <code>SchemaMappingSummary</code> objects, each of which contain the fields
         *        <code>SchemaName</code>, <code>SchemaArn</code>, <code>CreatedAt</code>, <code>UpdatedAt</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaList(SchemaMappingSummary... schemaList);

        /**
         * <p>
         * A list of <code>SchemaMappingSummary</code> objects, each of which contain the fields <code>SchemaName</code>, <code>SchemaArn</code>, <code>CreatedAt</code>, <code>UpdatedAt</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.SchemaMappingSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.entityresolution.model.SchemaMappingSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.SchemaMappingSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #schemaList(List<SchemaMappingSummary>)}.
         * 
         * @param schemaList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.SchemaMappingSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaList(java.util.Collection<SchemaMappingSummary>)
         */
        Builder schemaList(Consumer<SchemaMappingSummary.Builder>... schemaList);

        /**
         * <p>
         * The pagination token from the previous API call.
         * </p>
         * 
         * @param nextToken
         *        The pagination token from the previous API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EntityResolutionResponse.BuilderImpl implements Builder {
        private List<SchemaMappingSummary> schemaList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSchemaMappingsResponse model) {
            super(model);
            schemaList(model.schemaList);
            nextToken(model.nextToken);
        }

        public final List<SchemaMappingSummary.Builder> getSchemaList() {
            List<SchemaMappingSummary.Builder> result = SchemaMappingListCopier.copyToBuilder(this.schemaList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchemaList(Collection<SchemaMappingSummary.BuilderImpl> schemaList) {
            this.schemaList = SchemaMappingListCopier.copyFromBuilder(schemaList);
        }

        @Override
        public final Builder schemaList(Collection<SchemaMappingSummary> schemaList) {
            this.schemaList = SchemaMappingListCopier.copy(schemaList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaList(SchemaMappingSummary... schemaList) {
            schemaList(Arrays.asList(schemaList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaList(Consumer<SchemaMappingSummary.Builder>... schemaList) {
            schemaList(Stream.of(schemaList).map(c -> SchemaMappingSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSchemaMappingsResponse build() {
            return new ListSchemaMappingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
