/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of ID namespaces.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdNamespaceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<IdNamespaceSummary.Builder, IdNamespaceSummary> {
    private static final SdkField<String> ID_NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("idNamespaceName").getter(getter(IdNamespaceSummary::idNamespaceName))
            .setter(setter(Builder::idNamespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idNamespaceName").build()).build();

    private static final SdkField<String> ID_NAMESPACE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("idNamespaceArn").getter(getter(IdNamespaceSummary::idNamespaceArn))
            .setter(setter(Builder::idNamespaceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idNamespaceArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(IdNamespaceSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<IdNamespaceIdMappingWorkflowMetadata>> ID_MAPPING_WORKFLOW_PROPERTIES_FIELD = SdkField
            .<List<IdNamespaceIdMappingWorkflowMetadata>> builder(MarshallingType.LIST)
            .memberName("idMappingWorkflowProperties")
            .getter(getter(IdNamespaceSummary::idMappingWorkflowProperties))
            .setter(setter(Builder::idMappingWorkflowProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idMappingWorkflowProperties")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IdNamespaceIdMappingWorkflowMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdNamespaceIdMappingWorkflowMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(IdNamespaceSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(IdNamespaceSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(IdNamespaceSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_NAMESPACE_NAME_FIELD,
            ID_NAMESPACE_ARN_FIELD, DESCRIPTION_FIELD, ID_MAPPING_WORKFLOW_PROPERTIES_FIELD, TYPE_FIELD, CREATED_AT_FIELD,
            UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String idNamespaceName;

    private final String idNamespaceArn;

    private final String description;

    private final List<IdNamespaceIdMappingWorkflowMetadata> idMappingWorkflowProperties;

    private final String type;

    private final Instant createdAt;

    private final Instant updatedAt;

    private IdNamespaceSummary(BuilderImpl builder) {
        this.idNamespaceName = builder.idNamespaceName;
        this.idNamespaceArn = builder.idNamespaceArn;
        this.description = builder.description;
        this.idMappingWorkflowProperties = builder.idMappingWorkflowProperties;
        this.type = builder.type;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The name of the ID namespace.
     * </p>
     * 
     * @return The name of the ID namespace.
     */
    public final String idNamespaceName() {
        return idNamespaceName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the ID namespace.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the ID namespace.
     */
    public final String idNamespaceArn() {
        return idNamespaceArn;
    }

    /**
     * <p>
     * The description of the ID namespace.
     * </p>
     * 
     * @return The description of the ID namespace.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the IdMappingWorkflowProperties property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIdMappingWorkflowProperties() {
        return idMappingWorkflowProperties != null && !(idMappingWorkflowProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object which defines any additional configurations required by the ID mapping workflow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdMappingWorkflowProperties} method.
     * </p>
     * 
     * @return An object which defines any additional configurations required by the ID mapping workflow.
     */
    public final List<IdNamespaceIdMappingWorkflowMetadata> idMappingWorkflowProperties() {
        return idMappingWorkflowProperties;
    }

    /**
     * <p>
     * The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>.
     * </p>
     * <p>
     * The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed in an ID
     * mapping workflow.
     * </p>
     * <p>
     * The <code>TARGET</code> contains a configuration of <code>targetId</code> which all <code>sourceIds</code> will
     * resolve to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IdNamespaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>.</p>
     *         <p>
     *         The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed in
     *         an ID mapping workflow.
     *         </p>
     *         <p>
     *         The <code>TARGET</code> contains a configuration of <code>targetId</code> which all
     *         <code>sourceIds</code> will resolve to.
     * @see IdNamespaceType
     */
    public final IdNamespaceType type() {
        return IdNamespaceType.fromValue(type);
    }

    /**
     * <p>
     * The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>.
     * </p>
     * <p>
     * The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed in an ID
     * mapping workflow.
     * </p>
     * <p>
     * The <code>TARGET</code> contains a configuration of <code>targetId</code> which all <code>sourceIds</code> will
     * resolve to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IdNamespaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>.</p>
     *         <p>
     *         The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed in
     *         an ID mapping workflow.
     *         </p>
     *         <p>
     *         The <code>TARGET</code> contains a configuration of <code>targetId</code> which all
     *         <code>sourceIds</code> will resolve to.
     * @see IdNamespaceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The timestamp of when the ID namespace was created.
     * </p>
     * 
     * @return The timestamp of when the ID namespace was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp of when the ID namespace was last updated.
     * </p>
     * 
     * @return The timestamp of when the ID namespace was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(idNamespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(idNamespaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasIdMappingWorkflowProperties() ? idMappingWorkflowProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdNamespaceSummary)) {
            return false;
        }
        IdNamespaceSummary other = (IdNamespaceSummary) obj;
        return Objects.equals(idNamespaceName(), other.idNamespaceName())
                && Objects.equals(idNamespaceArn(), other.idNamespaceArn()) && Objects.equals(description(), other.description())
                && hasIdMappingWorkflowProperties() == other.hasIdMappingWorkflowProperties()
                && Objects.equals(idMappingWorkflowProperties(), other.idMappingWorkflowProperties())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdNamespaceSummary").add("IdNamespaceName", idNamespaceName())
                .add("IdNamespaceArn", idNamespaceArn()).add("Description", description())
                .add("IdMappingWorkflowProperties", hasIdMappingWorkflowProperties() ? idMappingWorkflowProperties() : null)
                .add("Type", typeAsString()).add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "idNamespaceName":
            return Optional.ofNullable(clazz.cast(idNamespaceName()));
        case "idNamespaceArn":
            return Optional.ofNullable(clazz.cast(idNamespaceArn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "idMappingWorkflowProperties":
            return Optional.ofNullable(clazz.cast(idMappingWorkflowProperties()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("idNamespaceName", ID_NAMESPACE_NAME_FIELD);
        map.put("idNamespaceArn", ID_NAMESPACE_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("idMappingWorkflowProperties", ID_MAPPING_WORKFLOW_PROPERTIES_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdNamespaceSummary, T> g) {
        return obj -> g.apply((IdNamespaceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdNamespaceSummary> {
        /**
         * <p>
         * The name of the ID namespace.
         * </p>
         * 
         * @param idNamespaceName
         *        The name of the ID namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idNamespaceName(String idNamespaceName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the ID namespace.
         * </p>
         * 
         * @param idNamespaceArn
         *        The Amazon Resource Name (ARN) of the ID namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idNamespaceArn(String idNamespaceArn);

        /**
         * <p>
         * The description of the ID namespace.
         * </p>
         * 
         * @param description
         *        The description of the ID namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An object which defines any additional configurations required by the ID mapping workflow.
         * </p>
         * 
         * @param idMappingWorkflowProperties
         *        An object which defines any additional configurations required by the ID mapping workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idMappingWorkflowProperties(Collection<IdNamespaceIdMappingWorkflowMetadata> idMappingWorkflowProperties);

        /**
         * <p>
         * An object which defines any additional configurations required by the ID mapping workflow.
         * </p>
         * 
         * @param idMappingWorkflowProperties
         *        An object which defines any additional configurations required by the ID mapping workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idMappingWorkflowProperties(IdNamespaceIdMappingWorkflowMetadata... idMappingWorkflowProperties);

        /**
         * <p>
         * An object which defines any additional configurations required by the ID mapping workflow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.IdNamespaceIdMappingWorkflowMetadata.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.entityresolution.model.IdNamespaceIdMappingWorkflowMetadata#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.IdNamespaceIdMappingWorkflowMetadata.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #idMappingWorkflowProperties(List<IdNamespaceIdMappingWorkflowMetadata>)}.
         * 
         * @param idMappingWorkflowProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.IdNamespaceIdMappingWorkflowMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #idMappingWorkflowProperties(java.util.Collection<IdNamespaceIdMappingWorkflowMetadata>)
         */
        Builder idMappingWorkflowProperties(Consumer<IdNamespaceIdMappingWorkflowMetadata.Builder>... idMappingWorkflowProperties);

        /**
         * <p>
         * The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>.
         * </p>
         * <p>
         * The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed in an
         * ID mapping workflow.
         * </p>
         * <p>
         * The <code>TARGET</code> contains a configuration of <code>targetId</code> which all <code>sourceIds</code>
         * will resolve to.
         * </p>
         * 
         * @param type
         *        The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>.</p>
         *        <p>
         *        The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed
         *        in an ID mapping workflow.
         *        </p>
         *        <p>
         *        The <code>TARGET</code> contains a configuration of <code>targetId</code> which all
         *        <code>sourceIds</code> will resolve to.
         * @see IdNamespaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdNamespaceType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>.
         * </p>
         * <p>
         * The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed in an
         * ID mapping workflow.
         * </p>
         * <p>
         * The <code>TARGET</code> contains a configuration of <code>targetId</code> which all <code>sourceIds</code>
         * will resolve to.
         * </p>
         * 
         * @param type
         *        The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>.</p>
         *        <p>
         *        The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed
         *        in an ID mapping workflow.
         *        </p>
         *        <p>
         *        The <code>TARGET</code> contains a configuration of <code>targetId</code> which all
         *        <code>sourceIds</code> will resolve to.
         * @see IdNamespaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdNamespaceType
         */
        Builder type(IdNamespaceType type);

        /**
         * <p>
         * The timestamp of when the ID namespace was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the ID namespace was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp of when the ID namespace was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when the ID namespace was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String idNamespaceName;

        private String idNamespaceArn;

        private String description;

        private List<IdNamespaceIdMappingWorkflowMetadata> idMappingWorkflowProperties = DefaultSdkAutoConstructList
                .getInstance();

        private String type;

        private Instant createdAt;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(IdNamespaceSummary model) {
            idNamespaceName(model.idNamespaceName);
            idNamespaceArn(model.idNamespaceArn);
            description(model.description);
            idMappingWorkflowProperties(model.idMappingWorkflowProperties);
            type(model.type);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
        }

        public final String getIdNamespaceName() {
            return idNamespaceName;
        }

        public final void setIdNamespaceName(String idNamespaceName) {
            this.idNamespaceName = idNamespaceName;
        }

        @Override
        public final Builder idNamespaceName(String idNamespaceName) {
            this.idNamespaceName = idNamespaceName;
            return this;
        }

        public final String getIdNamespaceArn() {
            return idNamespaceArn;
        }

        public final void setIdNamespaceArn(String idNamespaceArn) {
            this.idNamespaceArn = idNamespaceArn;
        }

        @Override
        public final Builder idNamespaceArn(String idNamespaceArn) {
            this.idNamespaceArn = idNamespaceArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<IdNamespaceIdMappingWorkflowMetadata.Builder> getIdMappingWorkflowProperties() {
            List<IdNamespaceIdMappingWorkflowMetadata.Builder> result = IdNamespaceIdMappingWorkflowMetadataListCopier
                    .copyToBuilder(this.idMappingWorkflowProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdMappingWorkflowProperties(
                Collection<IdNamespaceIdMappingWorkflowMetadata.BuilderImpl> idMappingWorkflowProperties) {
            this.idMappingWorkflowProperties = IdNamespaceIdMappingWorkflowMetadataListCopier
                    .copyFromBuilder(idMappingWorkflowProperties);
        }

        @Override
        public final Builder idMappingWorkflowProperties(
                Collection<IdNamespaceIdMappingWorkflowMetadata> idMappingWorkflowProperties) {
            this.idMappingWorkflowProperties = IdNamespaceIdMappingWorkflowMetadataListCopier.copy(idMappingWorkflowProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder idMappingWorkflowProperties(IdNamespaceIdMappingWorkflowMetadata... idMappingWorkflowProperties) {
            idMappingWorkflowProperties(Arrays.asList(idMappingWorkflowProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder idMappingWorkflowProperties(
                Consumer<IdNamespaceIdMappingWorkflowMetadata.Builder>... idMappingWorkflowProperties) {
            idMappingWorkflowProperties(Stream.of(idMappingWorkflowProperties)
                    .map(c -> IdNamespaceIdMappingWorkflowMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IdNamespaceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public IdNamespaceSummary build() {
            return new IdNamespaceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
