/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMatchIdRequest extends EntityResolutionRequest implements
        ToCopyableBuilder<GetMatchIdRequest.Builder, GetMatchIdRequest> {
    private static final SdkField<String> WORKFLOW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowName").getter(getter(GetMatchIdRequest::workflowName)).setter(setter(Builder::workflowName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workflowName").build()).build();

    private static final SdkField<Map<String, String>> RECORD_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("record")
            .getter(getter(GetMatchIdRequest::record))
            .setter(setter(Builder::record))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("record").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> APPLY_NORMALIZATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("applyNormalization").getter(getter(GetMatchIdRequest::applyNormalization))
            .setter(setter(Builder::applyNormalization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applyNormalization").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_NAME_FIELD,
            RECORD_FIELD, APPLY_NORMALIZATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workflowName;

    private final Map<String, String> record;

    private final Boolean applyNormalization;

    private GetMatchIdRequest(BuilderImpl builder) {
        super(builder);
        this.workflowName = builder.workflowName;
        this.record = builder.record;
        this.applyNormalization = builder.applyNormalization;
    }

    /**
     * <p>
     * The name of the workflow.
     * </p>
     * 
     * @return The name of the workflow.
     */
    public final String workflowName() {
        return workflowName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Record property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRecord() {
        return record != null && !(record instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The record to fetch the Match ID for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecord} method.
     * </p>
     * 
     * @return The record to fetch the Match ID for.
     */
    public final Map<String, String> record() {
        return record;
    }

    /**
     * <p>
     * Normalizes the attributes defined in the schema in the input data. For example, if an attribute has an
     * <code>AttributeType</code> of <code>PHONE_NUMBER</code>, and the data in the input table is in a format of
     * 1234567890, Entity Resolution will normalize this field in the output to (123)-456-7890.
     * </p>
     * 
     * @return Normalizes the attributes defined in the schema in the input data. For example, if an attribute has an
     *         <code>AttributeType</code> of <code>PHONE_NUMBER</code>, and the data in the input table is in a format
     *         of 1234567890, Entity Resolution will normalize this field in the output to (123)-456-7890.
     */
    public final Boolean applyNormalization() {
        return applyNormalization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workflowName());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecord() ? record() : null);
        hashCode = 31 * hashCode + Objects.hashCode(applyNormalization());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMatchIdRequest)) {
            return false;
        }
        GetMatchIdRequest other = (GetMatchIdRequest) obj;
        return Objects.equals(workflowName(), other.workflowName()) && hasRecord() == other.hasRecord()
                && Objects.equals(record(), other.record()) && Objects.equals(applyNormalization(), other.applyNormalization());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMatchIdRequest").add("WorkflowName", workflowName())
                .add("Record", record() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ApplyNormalization", applyNormalization()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workflowName":
            return Optional.ofNullable(clazz.cast(workflowName()));
        case "record":
            return Optional.ofNullable(clazz.cast(record()));
        case "applyNormalization":
            return Optional.ofNullable(clazz.cast(applyNormalization()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workflowName", WORKFLOW_NAME_FIELD);
        map.put("record", RECORD_FIELD);
        map.put("applyNormalization", APPLY_NORMALIZATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMatchIdRequest, T> g) {
        return obj -> g.apply((GetMatchIdRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EntityResolutionRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetMatchIdRequest> {
        /**
         * <p>
         * The name of the workflow.
         * </p>
         * 
         * @param workflowName
         *        The name of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowName(String workflowName);

        /**
         * <p>
         * The record to fetch the Match ID for.
         * </p>
         * 
         * @param record
         *        The record to fetch the Match ID for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder record(Map<String, String> record);

        /**
         * <p>
         * Normalizes the attributes defined in the schema in the input data. For example, if an attribute has an
         * <code>AttributeType</code> of <code>PHONE_NUMBER</code>, and the data in the input table is in a format of
         * 1234567890, Entity Resolution will normalize this field in the output to (123)-456-7890.
         * </p>
         * 
         * @param applyNormalization
         *        Normalizes the attributes defined in the schema in the input data. For example, if an attribute has an
         *        <code>AttributeType</code> of <code>PHONE_NUMBER</code>, and the data in the input table is in a
         *        format of 1234567890, Entity Resolution will normalize this field in the output to (123)-456-7890.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyNormalization(Boolean applyNormalization);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EntityResolutionRequest.BuilderImpl implements Builder {
        private String workflowName;

        private Map<String, String> record = DefaultSdkAutoConstructMap.getInstance();

        private Boolean applyNormalization;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMatchIdRequest model) {
            super(model);
            workflowName(model.workflowName);
            record(model.record);
            applyNormalization(model.applyNormalization);
        }

        public final String getWorkflowName() {
            return workflowName;
        }

        public final void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @Override
        public final Builder workflowName(String workflowName) {
            this.workflowName = workflowName;
            return this;
        }

        public final Map<String, String> getRecord() {
            if (record instanceof SdkAutoConstructMap) {
                return null;
            }
            return record;
        }

        public final void setRecord(Map<String, String> record) {
            this.record = RecordAttributeMapCopier.copy(record);
        }

        @Override
        public final Builder record(Map<String, String> record) {
            this.record = RecordAttributeMapCopier.copy(record);
            return this;
        }

        public final Boolean getApplyNormalization() {
            return applyNormalization;
        }

        public final void setApplyNormalization(Boolean applyNormalization) {
            this.applyNormalization = applyNormalization;
        }

        @Override
        public final Builder applyNormalization(Boolean applyNormalization) {
            this.applyNormalization = applyNormalization;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMatchIdRequest build() {
            return new GetMatchIdRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
