/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDashboardForJobRunRequest extends EmrServerlessRequest implements
        ToCopyableBuilder<GetDashboardForJobRunRequest.Builder, GetDashboardForJobRunRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(GetDashboardForJobRunRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> JOB_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobRunId").getter(getter(GetDashboardForJobRunRequest::jobRunId)).setter(setter(Builder::jobRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobRunId").build()).build();

    private static final SdkField<Integer> ATTEMPT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("attempt").getter(getter(GetDashboardForJobRunRequest::attempt)).setter(setter(Builder::attempt))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("attempt").build()).build();

    private static final SdkField<Boolean> ACCESS_SYSTEM_PROFILE_LOGS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("accessSystemProfileLogs")
            .getter(getter(GetDashboardForJobRunRequest::accessSystemProfileLogs))
            .setter(setter(Builder::accessSystemProfileLogs))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("accessSystemProfileLogs")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            JOB_RUN_ID_FIELD, ATTEMPT_FIELD, ACCESS_SYSTEM_PROFILE_LOGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String jobRunId;

    private final Integer attempt;

    private final Boolean accessSystemProfileLogs;

    private GetDashboardForJobRunRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.jobRunId = builder.jobRunId;
        this.attempt = builder.attempt;
        this.accessSystemProfileLogs = builder.accessSystemProfileLogs;
    }

    /**
     * <p>
     * The ID of the application.
     * </p>
     * 
     * @return The ID of the application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The ID of the job run.
     * </p>
     * 
     * @return The ID of the job run.
     */
    public final String jobRunId() {
        return jobRunId;
    }

    /**
     * <p>
     * An optimal parameter that indicates the amount of attempts for the job. If not specified, this value defaults to
     * the attempt of the latest job.
     * </p>
     * 
     * @return An optimal parameter that indicates the amount of attempts for the job. If not specified, this value
     *         defaults to the attempt of the latest job.
     */
    public final Integer attempt() {
        return attempt;
    }

    /**
     * <p>
     * Allows access to system profile logs for Lake Formation-enabled jobs. Default is false.
     * </p>
     * 
     * @return Allows access to system profile logs for Lake Formation-enabled jobs. Default is false.
     */
    public final Boolean accessSystemProfileLogs() {
        return accessSystemProfileLogs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(jobRunId());
        hashCode = 31 * hashCode + Objects.hashCode(attempt());
        hashCode = 31 * hashCode + Objects.hashCode(accessSystemProfileLogs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDashboardForJobRunRequest)) {
            return false;
        }
        GetDashboardForJobRunRequest other = (GetDashboardForJobRunRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(jobRunId(), other.jobRunId())
                && Objects.equals(attempt(), other.attempt())
                && Objects.equals(accessSystemProfileLogs(), other.accessSystemProfileLogs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDashboardForJobRunRequest").add("ApplicationId", applicationId()).add("JobRunId", jobRunId())
                .add("Attempt", attempt()).add("AccessSystemProfileLogs", accessSystemProfileLogs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "jobRunId":
            return Optional.ofNullable(clazz.cast(jobRunId()));
        case "attempt":
            return Optional.ofNullable(clazz.cast(attempt()));
        case "accessSystemProfileLogs":
            return Optional.ofNullable(clazz.cast(accessSystemProfileLogs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("jobRunId", JOB_RUN_ID_FIELD);
        map.put("attempt", ATTEMPT_FIELD);
        map.put("accessSystemProfileLogs", ACCESS_SYSTEM_PROFILE_LOGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDashboardForJobRunRequest, T> g) {
        return obj -> g.apply((GetDashboardForJobRunRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EmrServerlessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDashboardForJobRunRequest> {
        /**
         * <p>
         * The ID of the application.
         * </p>
         * 
         * @param applicationId
         *        The ID of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The ID of the job run.
         * </p>
         * 
         * @param jobRunId
         *        The ID of the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobRunId(String jobRunId);

        /**
         * <p>
         * An optimal parameter that indicates the amount of attempts for the job. If not specified, this value defaults
         * to the attempt of the latest job.
         * </p>
         * 
         * @param attempt
         *        An optimal parameter that indicates the amount of attempts for the job. If not specified, this value
         *        defaults to the attempt of the latest job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attempt(Integer attempt);

        /**
         * <p>
         * Allows access to system profile logs for Lake Formation-enabled jobs. Default is false.
         * </p>
         * 
         * @param accessSystemProfileLogs
         *        Allows access to system profile logs for Lake Formation-enabled jobs. Default is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessSystemProfileLogs(Boolean accessSystemProfileLogs);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrServerlessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String jobRunId;

        private Integer attempt;

        private Boolean accessSystemProfileLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDashboardForJobRunRequest model) {
            super(model);
            applicationId(model.applicationId);
            jobRunId(model.jobRunId);
            attempt(model.attempt);
            accessSystemProfileLogs(model.accessSystemProfileLogs);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getJobRunId() {
            return jobRunId;
        }

        public final void setJobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
        }

        @Override
        public final Builder jobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
            return this;
        }

        public final Integer getAttempt() {
            return attempt;
        }

        public final void setAttempt(Integer attempt) {
            this.attempt = attempt;
        }

        @Override
        public final Builder attempt(Integer attempt) {
            this.attempt = attempt;
            return this;
        }

        public final Boolean getAccessSystemProfileLogs() {
            return accessSystemProfileLogs;
        }

        public final void setAccessSystemProfileLogs(Boolean accessSystemProfileLogs) {
            this.accessSystemProfileLogs = accessSystemProfileLogs;
        }

        @Override
        public final Builder accessSystemProfileLogs(Boolean accessSystemProfileLogs) {
            this.accessSystemProfileLogs = accessSystemProfileLogs;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDashboardForJobRunRequest build() {
            return new GetDashboardForJobRunRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
