/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerLogRotationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerLogRotationConfiguration> {
    private static final SdkField<String> ROTATION_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rotationSize").getter(ContainerLogRotationConfiguration.getter(ContainerLogRotationConfiguration::rotationSize)).setter(ContainerLogRotationConfiguration.setter(Builder::rotationSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rotationSize").build()}).build();
    private static final SdkField<Integer> MAX_FILES_TO_KEEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxFilesToKeep").getter(ContainerLogRotationConfiguration.getter(ContainerLogRotationConfiguration::maxFilesToKeep)).setter(ContainerLogRotationConfiguration.setter(Builder::maxFilesToKeep)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxFilesToKeep").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROTATION_SIZE_FIELD, MAX_FILES_TO_KEEP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContainerLogRotationConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String rotationSize;
    private final Integer maxFilesToKeep;

    private ContainerLogRotationConfiguration(BuilderImpl builder) {
        this.rotationSize = builder.rotationSize;
        this.maxFilesToKeep = builder.maxFilesToKeep;
    }

    public final String rotationSize() {
        return this.rotationSize;
    }

    public final Integer maxFilesToKeep() {
        return this.maxFilesToKeep;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rotationSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxFilesToKeep());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerLogRotationConfiguration)) {
            return false;
        }
        ContainerLogRotationConfiguration other = (ContainerLogRotationConfiguration)obj;
        return Objects.equals(this.rotationSize(), other.rotationSize()) && Objects.equals(this.maxFilesToKeep(), other.maxFilesToKeep());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerLogRotationConfiguration").add("RotationSize", (Object)this.rotationSize()).add("MaxFilesToKeep", (Object)this.maxFilesToKeep()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "rotationSize": {
                return Optional.ofNullable(clazz.cast(this.rotationSize()));
            }
            case "maxFilesToKeep": {
                return Optional.ofNullable(clazz.cast(this.maxFilesToKeep()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rotationSize", ROTATION_SIZE_FIELD);
        map.put("maxFilesToKeep", MAX_FILES_TO_KEEP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContainerLogRotationConfiguration, T> g) {
        return obj -> g.apply((ContainerLogRotationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String rotationSize;
        private Integer maxFilesToKeep;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerLogRotationConfiguration model) {
            this.rotationSize(model.rotationSize);
            this.maxFilesToKeep(model.maxFilesToKeep);
        }

        public final String getRotationSize() {
            return this.rotationSize;
        }

        public final void setRotationSize(String rotationSize) {
            this.rotationSize = rotationSize;
        }

        @Override
        public final Builder rotationSize(String rotationSize) {
            this.rotationSize = rotationSize;
            return this;
        }

        public final Integer getMaxFilesToKeep() {
            return this.maxFilesToKeep;
        }

        public final void setMaxFilesToKeep(Integer maxFilesToKeep) {
            this.maxFilesToKeep = maxFilesToKeep;
        }

        @Override
        public final Builder maxFilesToKeep(Integer maxFilesToKeep) {
            this.maxFilesToKeep = maxFilesToKeep;
            return this;
        }

        public ContainerLogRotationConfiguration build() {
            return new ContainerLogRotationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerLogRotationConfiguration> {
        public Builder rotationSize(String var1);

        public Builder maxFilesToKeep(Integer var1);
    }
}

