/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emrcontainers.model.ContainerInfo;
import software.amazon.awssdk.services.emrcontainers.model.ContainerProviderType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerProvider
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerProvider> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ContainerProvider.getter(ContainerProvider::typeAsString)).setter(ContainerProvider.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ContainerProvider.getter(ContainerProvider::id)).setter(ContainerProvider.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<ContainerInfo> INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("info").getter(ContainerProvider.getter(ContainerProvider::info)).setter(ContainerProvider.setter(Builder::info)).constructor(ContainerInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("info").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ID_FIELD, INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("type", TYPE_FIELD);
            this.put("id", ID_FIELD);
            this.put("info", INFO_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String id;
    private final ContainerInfo info;

    private ContainerProvider(BuilderImpl builder) {
        this.type = builder.type;
        this.id = builder.id;
        this.info = builder.info;
    }

    public final ContainerProviderType type() {
        return ContainerProviderType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String id() {
        return this.id;
    }

    public final ContainerInfo info() {
        return this.info;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.info());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerProvider)) {
            return false;
        }
        ContainerProvider other = (ContainerProvider)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.info(), other.info());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerProvider").add("Type", (Object)this.typeAsString()).add("Id", (Object)this.id()).add("Info", (Object)this.info()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "info": {
                return Optional.ofNullable(clazz.cast(this.info()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ContainerProvider, T> g) {
        return obj -> g.apply((ContainerProvider)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String id;
        private ContainerInfo info;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerProvider model) {
            this.type(model.type);
            this.id(model.id);
            this.info(model.info);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ContainerProviderType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final ContainerInfo.Builder getInfo() {
            return this.info != null ? this.info.toBuilder() : null;
        }

        public final void setInfo(ContainerInfo.BuilderImpl info) {
            this.info = info != null ? info.build() : null;
        }

        @Override
        public final Builder info(ContainerInfo info) {
            this.info = info;
            return this;
        }

        public ContainerProvider build() {
            return new ContainerProvider(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerProvider> {
        public Builder type(String var1);

        public Builder type(ContainerProviderType var1);

        public Builder id(String var1);

        public Builder info(ContainerInfo var1);

        default public Builder info(Consumer<ContainerInfo.Builder> info) {
            return this.info((ContainerInfo)((ContainerInfo.Builder)ContainerInfo.builder().applyMutation(info)).build());
        }
    }
}

