/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.emrcontainers.DefaultEmrContainersAsyncClient;
import software.amazon.awssdk.services.emrcontainers.DefaultEmrContainersBaseClientBuilder;
import software.amazon.awssdk.services.emrcontainers.EmrContainersAsyncClient;
import software.amazon.awssdk.services.emrcontainers.EmrContainersAsyncClientBuilder;
import software.amazon.awssdk.services.emrcontainers.EmrContainersServiceClientConfiguration;
import software.amazon.awssdk.services.emrcontainers.endpoints.EmrContainersEndpointProvider;

@SdkInternalApi
final class DefaultEmrContainersAsyncClientBuilder
extends DefaultEmrContainersBaseClientBuilder<EmrContainersAsyncClientBuilder, EmrContainersAsyncClient>
implements EmrContainersAsyncClientBuilder {
    DefaultEmrContainersAsyncClientBuilder() {
    }

    @Override
    public DefaultEmrContainersAsyncClientBuilder endpointProvider(EmrContainersEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final EmrContainersAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultEmrContainersAsyncClientBuilder.validateClientOptions(clientConfiguration);
        EmrContainersServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultEmrContainersAsyncClient client = new DefaultEmrContainersAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private EmrContainersServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return EmrContainersServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

