/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.emrcontainers.EmrContainersClient;
import software.amazon.awssdk.services.emrcontainers.model.CancelJobRunRequest;
import software.amazon.awssdk.services.emrcontainers.model.CancelJobRunResponse;
import software.amazon.awssdk.services.emrcontainers.model.CreateManagedEndpointRequest;
import software.amazon.awssdk.services.emrcontainers.model.CreateManagedEndpointResponse;
import software.amazon.awssdk.services.emrcontainers.model.CreateVirtualClusterRequest;
import software.amazon.awssdk.services.emrcontainers.model.CreateVirtualClusterResponse;
import software.amazon.awssdk.services.emrcontainers.model.DeleteManagedEndpointRequest;
import software.amazon.awssdk.services.emrcontainers.model.DeleteManagedEndpointResponse;
import software.amazon.awssdk.services.emrcontainers.model.DeleteVirtualClusterRequest;
import software.amazon.awssdk.services.emrcontainers.model.DeleteVirtualClusterResponse;
import software.amazon.awssdk.services.emrcontainers.model.DescribeJobRunRequest;
import software.amazon.awssdk.services.emrcontainers.model.DescribeJobRunResponse;
import software.amazon.awssdk.services.emrcontainers.model.DescribeManagedEndpointRequest;
import software.amazon.awssdk.services.emrcontainers.model.DescribeManagedEndpointResponse;
import software.amazon.awssdk.services.emrcontainers.model.DescribeVirtualClusterRequest;
import software.amazon.awssdk.services.emrcontainers.model.DescribeVirtualClusterResponse;
import software.amazon.awssdk.services.emrcontainers.model.EmrContainersException;
import software.amazon.awssdk.services.emrcontainers.model.EmrContainersRequest;
import software.amazon.awssdk.services.emrcontainers.model.InternalServerException;
import software.amazon.awssdk.services.emrcontainers.model.ListJobRunsRequest;
import software.amazon.awssdk.services.emrcontainers.model.ListJobRunsResponse;
import software.amazon.awssdk.services.emrcontainers.model.ListManagedEndpointsRequest;
import software.amazon.awssdk.services.emrcontainers.model.ListManagedEndpointsResponse;
import software.amazon.awssdk.services.emrcontainers.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.emrcontainers.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.emrcontainers.model.ListVirtualClustersRequest;
import software.amazon.awssdk.services.emrcontainers.model.ListVirtualClustersResponse;
import software.amazon.awssdk.services.emrcontainers.model.ResourceNotFoundException;
import software.amazon.awssdk.services.emrcontainers.model.StartJobRunRequest;
import software.amazon.awssdk.services.emrcontainers.model.StartJobRunResponse;
import software.amazon.awssdk.services.emrcontainers.model.TagResourceRequest;
import software.amazon.awssdk.services.emrcontainers.model.TagResourceResponse;
import software.amazon.awssdk.services.emrcontainers.model.UntagResourceRequest;
import software.amazon.awssdk.services.emrcontainers.model.UntagResourceResponse;
import software.amazon.awssdk.services.emrcontainers.model.ValidationException;
import software.amazon.awssdk.services.emrcontainers.paginators.ListJobRunsIterable;
import software.amazon.awssdk.services.emrcontainers.paginators.ListManagedEndpointsIterable;
import software.amazon.awssdk.services.emrcontainers.paginators.ListVirtualClustersIterable;
import software.amazon.awssdk.services.emrcontainers.transform.CancelJobRunRequestMarshaller;
import software.amazon.awssdk.services.emrcontainers.transform.CreateManagedEndpointRequestMarshaller;
import software.amazon.awssdk.services.emrcontainers.transform.CreateVirtualClusterRequestMarshaller;
import software.amazon.awssdk.services.emrcontainers.transform.DeleteManagedEndpointRequestMarshaller;
import software.amazon.awssdk.services.emrcontainers.transform.DeleteVirtualClusterRequestMarshaller;
import software.amazon.awssdk.services.emrcontainers.transform.DescribeJobRunRequestMarshaller;
import software.amazon.awssdk.services.emrcontainers.transform.DescribeManagedEndpointRequestMarshaller;
import software.amazon.awssdk.services.emrcontainers.transform.DescribeVirtualClusterRequestMarshaller;
import software.amazon.awssdk.services.emrcontainers.transform.ListJobRunsRequestMarshaller;
import software.amazon.awssdk.services.emrcontainers.transform.ListManagedEndpointsRequestMarshaller;
import software.amazon.awssdk.services.emrcontainers.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.emrcontainers.transform.ListVirtualClustersRequestMarshaller;
import software.amazon.awssdk.services.emrcontainers.transform.StartJobRunRequestMarshaller;
import software.amazon.awssdk.services.emrcontainers.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.emrcontainers.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultEmrContainersClient
implements EmrContainersClient {
    private static final Logger log = Logger.loggerFor(DefaultEmrContainersClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultEmrContainersClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "emr-containers";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelJobRunResponse cancelJobRun(CancelJobRunRequest cancelJobRunRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, EmrContainersException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelJobRunResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEmrContainersClient.resolveMetricPublishers(this.clientConfiguration, cancelJobRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EMR containers");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelJobRun");
            CancelJobRunResponse cancelJobRunResponse = (CancelJobRunResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelJobRun").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelJobRunRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelJobRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelJobRunResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEmrContainersClient.lambda$cancelJobRun$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateManagedEndpointResponse createManagedEndpoint(CreateManagedEndpointRequest createManagedEndpointRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, EmrContainersException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateManagedEndpointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEmrContainersClient.resolveMetricPublishers(this.clientConfiguration, createManagedEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EMR containers");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateManagedEndpoint");
            CreateManagedEndpointResponse createManagedEndpointResponse = (CreateManagedEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateManagedEndpoint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createManagedEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateManagedEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createManagedEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEmrContainersClient.lambda$createManagedEndpoint$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateVirtualClusterResponse createVirtualCluster(CreateVirtualClusterRequest createVirtualClusterRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, EmrContainersException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVirtualClusterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEmrContainersClient.resolveMetricPublishers(this.clientConfiguration, createVirtualClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EMR containers");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVirtualCluster");
            CreateVirtualClusterResponse createVirtualClusterResponse = (CreateVirtualClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVirtualCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createVirtualClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateVirtualClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createVirtualClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEmrContainersClient.lambda$createVirtualCluster$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteManagedEndpointResponse deleteManagedEndpoint(DeleteManagedEndpointRequest deleteManagedEndpointRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, EmrContainersException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteManagedEndpointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEmrContainersClient.resolveMetricPublishers(this.clientConfiguration, deleteManagedEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EMR containers");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteManagedEndpoint");
            DeleteManagedEndpointResponse deleteManagedEndpointResponse = (DeleteManagedEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteManagedEndpoint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteManagedEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteManagedEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteManagedEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEmrContainersClient.lambda$deleteManagedEndpoint$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVirtualClusterResponse deleteVirtualCluster(DeleteVirtualClusterRequest deleteVirtualClusterRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, EmrContainersException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVirtualClusterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEmrContainersClient.resolveMetricPublishers(this.clientConfiguration, deleteVirtualClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EMR containers");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVirtualCluster");
            DeleteVirtualClusterResponse deleteVirtualClusterResponse = (DeleteVirtualClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVirtualCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteVirtualClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteVirtualClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteVirtualClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEmrContainersClient.lambda$deleteVirtualCluster$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeJobRunResponse describeJobRun(DescribeJobRunRequest describeJobRunRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, EmrContainersException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeJobRunResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEmrContainersClient.resolveMetricPublishers(this.clientConfiguration, describeJobRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EMR containers");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeJobRun");
            DescribeJobRunResponse describeJobRunResponse = (DescribeJobRunResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeJobRun").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeJobRunRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeJobRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeJobRunResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEmrContainersClient.lambda$describeJobRun$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeManagedEndpointResponse describeManagedEndpoint(DescribeManagedEndpointRequest describeManagedEndpointRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, EmrContainersException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeManagedEndpointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEmrContainersClient.resolveMetricPublishers(this.clientConfiguration, describeManagedEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EMR containers");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeManagedEndpoint");
            DescribeManagedEndpointResponse describeManagedEndpointResponse = (DescribeManagedEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeManagedEndpoint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeManagedEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeManagedEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeManagedEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEmrContainersClient.lambda$describeManagedEndpoint$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVirtualClusterResponse describeVirtualCluster(DescribeVirtualClusterRequest describeVirtualClusterRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, EmrContainersException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeVirtualClusterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEmrContainersClient.resolveMetricPublishers(this.clientConfiguration, describeVirtualClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EMR containers");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeVirtualCluster");
            DescribeVirtualClusterResponse describeVirtualClusterResponse = (DescribeVirtualClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeVirtualCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeVirtualClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeVirtualClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeVirtualClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEmrContainersClient.lambda$describeVirtualCluster$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListJobRunsResponse listJobRuns(ListJobRunsRequest listJobRunsRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, EmrContainersException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListJobRunsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEmrContainersClient.resolveMetricPublishers(this.clientConfiguration, listJobRunsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EMR containers");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListJobRuns");
            ListJobRunsResponse listJobRunsResponse = (ListJobRunsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListJobRuns").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listJobRunsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListJobRunsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listJobRunsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEmrContainersClient.lambda$listJobRuns$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListJobRunsIterable listJobRunsPaginator(ListJobRunsRequest listJobRunsRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, EmrContainersException {
        return new ListJobRunsIterable(this, this.applyPaginatorUserAgent(listJobRunsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListManagedEndpointsResponse listManagedEndpoints(ListManagedEndpointsRequest listManagedEndpointsRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, EmrContainersException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListManagedEndpointsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEmrContainersClient.resolveMetricPublishers(this.clientConfiguration, listManagedEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EMR containers");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListManagedEndpoints");
            ListManagedEndpointsResponse listManagedEndpointsResponse = (ListManagedEndpointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListManagedEndpoints").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listManagedEndpointsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListManagedEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listManagedEndpointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEmrContainersClient.lambda$listManagedEndpoints$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListManagedEndpointsIterable listManagedEndpointsPaginator(ListManagedEndpointsRequest listManagedEndpointsRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, EmrContainersException {
        return new ListManagedEndpointsIterable(this, this.applyPaginatorUserAgent(listManagedEndpointsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EmrContainersException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEmrContainersClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EMR containers");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEmrContainersClient.lambda$listTagsForResource$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVirtualClustersResponse listVirtualClusters(ListVirtualClustersRequest listVirtualClustersRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, EmrContainersException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVirtualClustersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEmrContainersClient.resolveMetricPublishers(this.clientConfiguration, listVirtualClustersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EMR containers");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVirtualClusters");
            ListVirtualClustersResponse listVirtualClustersResponse = (ListVirtualClustersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVirtualClusters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listVirtualClustersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListVirtualClustersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listVirtualClustersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEmrContainersClient.lambda$listVirtualClusters$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListVirtualClustersIterable listVirtualClustersPaginator(ListVirtualClustersRequest listVirtualClustersRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, EmrContainersException {
        return new ListVirtualClustersIterable(this, this.applyPaginatorUserAgent(listVirtualClustersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartJobRunResponse startJobRun(StartJobRunRequest startJobRunRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, EmrContainersException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartJobRunResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEmrContainersClient.resolveMetricPublishers(this.clientConfiguration, startJobRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EMR containers");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartJobRun");
            StartJobRunResponse startJobRunResponse = (StartJobRunResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartJobRun").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startJobRunRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartJobRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startJobRunResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEmrContainersClient.lambda$startJobRun$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EmrContainersException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEmrContainersClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EMR containers");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEmrContainersClient.lambda$tagResource$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EmrContainersException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEmrContainersClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EMR containers");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEmrContainersClient.lambda$untagResource$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(EmrContainersException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends EmrContainersRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.35").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((EmrContainersRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$untagResource$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startJobRun$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVirtualClusters$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listManagedEndpoints$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listJobRuns$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeVirtualCluster$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeManagedEndpoint$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeJobRun$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVirtualCluster$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteManagedEndpoint$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createVirtualCluster$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createManagedEndpoint$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelJobRun$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

