/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContainerProviderType {
    EKS("EKS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContainerProviderType> VALUE_MAP;
    private final String value;

    private ContainerProviderType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContainerProviderType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContainerProviderType> knownValues() {
        EnumSet<ContainerProviderType> knownValues = EnumSet.allOf(ContainerProviderType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContainerProviderType.class, ContainerProviderType::toString);
    }
}

