/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information about the container provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerProvider implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerProvider.Builder, ContainerProvider> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ContainerProvider::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ContainerProvider::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<ContainerInfo> INFO_FIELD = SdkField.<ContainerInfo> builder(MarshallingType.SDK_POJO)
            .memberName("info").getter(getter(ContainerProvider::info)).setter(setter(Builder::info))
            .constructor(ContainerInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("info").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ID_FIELD,
            INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String id;

    private final ContainerInfo info;

    private ContainerProvider(BuilderImpl builder) {
        this.type = builder.type;
        this.id = builder.id;
        this.info = builder.info;
    }

    /**
     * <p>
     * The type of the container provider. EKS is the only supported type as of now.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ContainerProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the container provider. EKS is the only supported type as of now.
     * @see ContainerProviderType
     */
    public final ContainerProviderType type() {
        return ContainerProviderType.fromValue(type);
    }

    /**
     * <p>
     * The type of the container provider. EKS is the only supported type as of now.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ContainerProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the container provider. EKS is the only supported type as of now.
     * @see ContainerProviderType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The ID of the container cluster.
     * </p>
     * 
     * @return The ID of the container cluster.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The information about the container cluster.
     * </p>
     * 
     * @return The information about the container cluster.
     */
    public final ContainerInfo info() {
        return info;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(info());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerProvider)) {
            return false;
        }
        ContainerProvider other = (ContainerProvider) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(id(), other.id())
                && Objects.equals(info(), other.info());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerProvider").add("Type", typeAsString()).add("Id", id()).add("Info", info()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "info":
            return Optional.ofNullable(clazz.cast(info()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerProvider, T> g) {
        return obj -> g.apply((ContainerProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerProvider> {
        /**
         * <p>
         * The type of the container provider. EKS is the only supported type as of now.
         * </p>
         * 
         * @param type
         *        The type of the container provider. EKS is the only supported type as of now.
         * @see ContainerProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerProviderType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the container provider. EKS is the only supported type as of now.
         * </p>
         * 
         * @param type
         *        The type of the container provider. EKS is the only supported type as of now.
         * @see ContainerProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerProviderType
         */
        Builder type(ContainerProviderType type);

        /**
         * <p>
         * The ID of the container cluster.
         * </p>
         * 
         * @param id
         *        The ID of the container cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The information about the container cluster.
         * </p>
         * 
         * @param info
         *        The information about the container cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder info(ContainerInfo info);

        /**
         * <p>
         * The information about the container cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link ContainerInfo.Builder} avoiding the need to
         * create one manually via {@link ContainerInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContainerInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #info(ContainerInfo)}.
         * 
         * @param info
         *        a consumer that will call methods on {@link ContainerInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #info(ContainerInfo)
         */
        default Builder info(Consumer<ContainerInfo.Builder> info) {
            return info(ContainerInfo.builder().applyMutation(info).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String id;

        private ContainerInfo info;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerProvider model) {
            type(model.type);
            id(model.id);
            info(model.info);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ContainerProviderType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final ContainerInfo.Builder getInfo() {
            return info != null ? info.toBuilder() : null;
        }

        @Override
        public final Builder info(ContainerInfo info) {
            this.info = info;
            return this;
        }

        public final void setInfo(ContainerInfo.BuilderImpl info) {
            this.info = info != null ? info.build() : null;
        }

        @Override
        public ContainerProvider build() {
            return new ContainerProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
